/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="ln", category="MATHEMATICAL", author="Confluent", description="The natural logarithm of a value.")
public class Ln {
    @Udf(description="Returns the natural logarithm (base e) of an INT value.")
    public Double ln(@UdfParameter(value="value", description="the value get the natual logarithm of.") Integer value) {
        return this.ln(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the natural logarithm (base e) of a BIGINT value.")
    public Double ln(@UdfParameter(value="value", description="the value get the natual logarithm of.") Long value) {
        return this.ln(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the natural logarithm (base e) of a DOUBLE value.")
    public Double ln(@UdfParameter(value="value", description="the value get the natual logarithm of.") Double value) {
        return value == null ? null : Double.valueOf(Math.log(value));
    }
}

