/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="log", category="MATHEMATICAL", author="Confluent", description="The logarithm of a value.")
public class Log {
    @Udf(description="Returns the base 10 logarithm of an INT value.")
    public Double log(@UdfParameter(value="value", description="the value get the base 10 logarithm of.") Integer value) {
        return this.log(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the base 10 logarithm of a BIGINT value.")
    public Double log(@UdfParameter(value="value", description="the value get the base 10 logarithm of.") Long value) {
        return this.log(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the base 10 logarithm of a DOUBLE value.")
    public Double log(@UdfParameter(value="value", description="the value get the base 10 logarithm of.") Double value) {
        return value == null ? null : Double.valueOf(Math.log(value));
    }

    @Udf(description="Returns the logarithm with the given base of an INT value.")
    public Double log(@UdfParameter(value="base", description="the base of the logarithm.") Integer base, @UdfParameter(value="value", description="the value get the logarithm of.") Integer value) {
        return this.log(base == null ? null : Double.valueOf(base.doubleValue()), value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the logarithm with the given base of a BIGINT value.")
    public Double log(@UdfParameter(value="base", description="the base of the logarithm.") Long base, @UdfParameter(value="value", description="the value get the logarithm of.") Long value) {
        return this.log(base == null ? null : Double.valueOf(base.doubleValue()), value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the logarithm with the given base of a DOUBLE value.")
    public Double log(@UdfParameter(value="base", description="the base of the logarithm.") Double base, @UdfParameter(value="value", description="the value get the logarithm of.") Double value) {
        if (base == null || value == null) {
            return null;
        }
        if (base <= 0.0 || base == 1.0) {
            return Double.NaN;
        }
        return Math.log(value) / Math.log(base);
    }
}

