/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="sin", category="MATHEMATICAL", author="Confluent", description="The sine of a value.")
public class Sin {
    @Udf(description="Returns the sine of an INT value")
    public Double sin(@UdfParameter(value="value", description="The value in radians to get the sine of.") Integer value) {
        return this.sin(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the sine of a BIGINT value")
    public Double sin(@UdfParameter(value="value", description="The value in radians to get the sine of.") Long value) {
        return this.sin(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the sine of a DOUBLE value")
    public Double sin(@UdfParameter(value="value", description="The value in radians to get the sine of.") Double value) {
        return value == null ? null : Double.valueOf(Math.sin(value));
    }
}

