/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.string.Concat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

@UdfDescription(name="concat_ws", category="STRING", description="Concatenate several strings or bytes, inserting a separator passed as the first argument between each one.")
public class ConcatWS {
    private static final Concat CONCAT = new Concat();

    @Udf
    public String concatWS(String ... inputs) {
        if (inputs == null || inputs.length < 2) {
            throw new KsqlFunctionException("Function Concat_WS expects at least two input arguments.");
        }
        String separator = inputs[0];
        if (separator == null) {
            return null;
        }
        return Arrays.stream(inputs, 1, inputs.length).filter(Objects::nonNull).collect(Collectors.joining(separator));
    }

    @Udf
    public ByteBuffer concatWS(ByteBuffer ... inputs) {
        if (inputs == null || inputs.length < 2) {
            throw new KsqlFunctionException("Function Concat_WS expects at least two input arguments.");
        }
        ByteBuffer separator = inputs[0];
        if (separator == null) {
            return null;
        }
        ArrayList<ByteBuffer> concatInputs = new ArrayList<ByteBuffer>();
        for (int i = 1; i < inputs.length; ++i) {
            if (!Objects.nonNull(inputs[i])) continue;
            if (concatInputs.size() != 0) {
                concatInputs.add(separator.duplicate());
            }
            concatInputs.add(inputs[i]);
        }
        return CONCAT.concat(concatInputs.toArray(new ByteBuffer[0]));
    }
}

