/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.regex.PatternSyntaxException;

@UdfDescription(name="regexp_replace", author="Confluent", category="REGULAR EXPRESSION", description="Replaces all matches of a regexp in a string with a new substring.")
public class RegexpReplace {
    @Udf(description="Returns a new string with all matches of regexp in str replaced with newStr")
    public String regexpReplace(@UdfParameter(description="The source string. If null, then function returns null.") String str, @UdfParameter(description="The regexp to match. If null, then function returns null.") String regexp, @UdfParameter(description="The string to replace the matches with. If null, then function returns null.") String newStr) {
        if (str == null || regexp == null || newStr == null) {
            return null;
        }
        try {
            return str.replaceAll(regexp, newStr);
        }
        catch (PatternSyntaxException e) {
            throw new KsqlFunctionException("Invalid regular expression pattern: " + regexp, (Throwable)e);
        }
    }
}

