/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import com.google.common.base.Splitter;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@UdfDescription(name="split", category="STRING", author="Confluent", description="Splits a string or bytes into an array of substrings or bytes based on a delimiter. If the delimiter is found at the beginning of the string/bytes, end of the string/bytes, or there are contiguous delimiters in the string/bytes, then empty strings/bytes are added to the array. If the delimiter is not found, then the original string or bytes is returned as the only element in the array. If the delimiter is empty, then all characters or bytes in the string or bytes are split.")
public class Split {
    static final String NAME = "split";
    private static final Pattern EMPTY_DELIMITER = Pattern.compile("");

    @Udf(description="Splits a string into an array of substrings based on a delimiter.")
    public List<String> split(@UdfParameter(description="The string to be split. If NULL, then function returns NULL.") String string, @UdfParameter(description="The delimiter to split a string by. If NULL, then function returns NULL.") String delimiter) {
        if (string == null || delimiter == null) {
            return null;
        }
        try {
            if (delimiter.isEmpty()) {
                return Arrays.asList(EMPTY_DELIMITER.split(string));
            }
            return Splitter.on((String)delimiter).splitToList((CharSequence)string);
        }
        catch (Exception e) {
            throw new KsqlFunctionException(String.format("Invalid delimiter '%s' in the split() function.", delimiter), (Throwable)e);
        }
    }

    @Udf(description="Splits a byte array into an array of bytes values based on a delimiter.")
    public List<ByteBuffer> split(@UdfParameter(description="The byte array to be split. If NULL, then function returns NULL.") ByteBuffer bytes, @UdfParameter(description="The delimiter to split the byte array by. If NULL, then function returns NULL.") ByteBuffer delimiter) {
        if (bytes == null || delimiter == null) {
            return null;
        }
        byte[] byteArray = BytesUtils.getByteArray((ByteBuffer)bytes);
        byte[] byteDelimiter = BytesUtils.getByteArray((ByteBuffer)delimiter);
        return BytesUtils.split((byte[])byteArray, (byte[])byteDelimiter).stream().map(ByteBuffer::wrap).collect(Collectors.toList());
    }
}

