/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.url;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.url.UrlParser;
import java.net.URI;

@UdfDescription(name="url_extract_port", category="URL", description="Extracts the port from an application/x-www-form-urlencoded encoded String. If there is no port or the string is invalid, this will return null.", author="Confluent")
public class UrlExtractPort {
    @Udf
    public Integer extractPort(@UdfParameter(description="a valid URL to extract a port from") String input) {
        Integer port = UrlParser.extract(input, URI::getPort);
        return port == null || port < 0 ? null : port;
    }
}

