/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.pull.PullPhysicalPlan;
import io.confluent.ksql.util.KsqlConstants;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;

public class PullQueryExecutorMetrics
implements Closeable {
    private static final String PULL_QUERY_METRIC_GROUP = "pull-query";
    private static final String PULL_REQUESTS = "pull-query-requests";
    private static final long MAX_LATENCY_BUCKET_VALUE_MICROS = TimeUnit.SECONDS.toMicros(10L);
    private static final int NUM_LATENCY_BUCKETS = 1000;
    private final List<Sensor> sensors;
    private final Sensor localRequestsSensor;
    private final Sensor remoteRequestsSensor;
    private final Sensor latencySensor;
    private final Map<MetricsKey, Sensor> latencySensorMap;
    private final Sensor requestRateSensor;
    private final Sensor errorRateSensor;
    private final Map<MetricsKey, Sensor> errorRateSensorMap;
    private final Sensor requestSizeSensor;
    private final Sensor responseSizeSensor;
    private final Map<MetricsKey, Sensor> responseSizeSensorMap;
    private final Sensor responseCode2XX;
    private final Sensor responseCode3XX;
    private final Sensor responseCode4XX;
    private final Sensor responseCode5XX;
    private final Map<MetricsKey, Sensor> rowsReturnedSensorMap;
    private final Map<MetricsKey, Sensor> rowsProcessedSensorMap;
    private final Metrics metrics;
    private final Map<String, String> legacyCustomMetricsTags;
    private final Map<String, String> customMetricsTags;
    private final String ksqlServiceIdLegacyPrefix;
    private final String ksqlServicePrefix;
    private final Time time;
    private Supplier<Integer> coordinatorThreadPoolSupplier;
    private Supplier<Integer> routerThreadPoolSupplier;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="metrics")
    public PullQueryExecutorMetrics(String ksqlServiceId, Map<String, String> customMetricsTags, Time time, Metrics metrics) {
        this.ksqlServiceIdLegacyPrefix = "_confluent-ksql-" + ksqlServiceId;
        this.legacyCustomMetricsTags = Objects.requireNonNull(customMetricsTags, "customMetricsTags");
        this.ksqlServicePrefix = "_confluent-ksql-";
        HashMap<String, String> metricsTags = new HashMap<String, String>(customMetricsTags);
        metricsTags.put("ksql_service_id", ksqlServiceId);
        this.customMetricsTags = ImmutableMap.copyOf(metricsTags);
        this.time = Objects.requireNonNull(time, "time");
        this.metrics = metrics;
        this.sensors = new ArrayList<Sensor>();
        this.localRequestsSensor = this.configureLocalRequestsSensor();
        this.remoteRequestsSensor = this.configureRemoteRequestsSensor();
        this.latencySensor = this.configureLatencySensor();
        this.latencySensorMap = this.configureLatencySensorMap();
        this.requestRateSensor = this.configureRateSensor();
        this.errorRateSensor = this.configureErrorRateSensor();
        this.errorRateSensorMap = this.configureErrorSensorMap();
        this.requestSizeSensor = this.configureRequestSizeSensor();
        this.responseSizeSensor = this.configureResponseSizeSensor();
        this.responseSizeSensorMap = this.configureResponseSizeSensorMap();
        this.responseCode2XX = this.configureStatusCodeSensor("2XX");
        this.responseCode3XX = this.configureStatusCodeSensor("3XX");
        this.responseCode4XX = this.configureStatusCodeSensor("4XX");
        this.responseCode5XX = this.configureStatusCodeSensor("5XX");
        this.rowsReturnedSensorMap = this.configureRowsReturnedSensorMap();
        this.rowsProcessedSensorMap = this.configureRowsProcessedSensorMap();
        this.configureThreadPoolMetrics();
    }

    @Override
    public void close() {
        this.sensors.forEach(sensor -> this.metrics.removeSensor(sensor.name()));
    }

    public void registerCoordinatorThreadPoolSupplier(Supplier<Integer> supplier) {
        this.coordinatorThreadPoolSupplier = supplier;
    }

    public void registerRouterThreadPoolSupplier(Supplier<Integer> supplier) {
        this.routerThreadPoolSupplier = supplier;
    }

    public void recordLocalRequests(double value) {
        this.localRequestsSensor.record(value);
    }

    public void recordRemoteRequests(double value) {
        this.remoteRequestsSensor.record(value);
    }

    public void recordLatency(long startTimeNanos, KsqlConstants.QuerySourceType sourceType, PullPhysicalPlan.PullPhysicalPlanType planType, KsqlConstants.RoutingNodeType routingNodeType) {
        MetricsKey key = new MetricsKey(sourceType, planType, routingNodeType);
        this.innerRecordLatency(startTimeNanos, key);
    }

    public void recordLatencyForError(long startTimeNanos) {
        MetricsKey key = new MetricsKey();
        this.innerRecordLatency(startTimeNanos, key);
    }

    private void innerRecordLatency(long startTimeNanos, MetricsKey key) {
        long nowNanos = this.time.nanoseconds();
        double latency = TimeUnit.NANOSECONDS.toMicros(nowNanos - startTimeNanos);
        this.latencySensor.record(latency);
        this.requestRateSensor.record(1.0);
        if (!this.latencySensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.latencySensorMap.get(key).record(latency);
    }

    public void recordErrorRate(double value, KsqlConstants.QuerySourceType sourceType, PullPhysicalPlan.PullPhysicalPlanType planType, KsqlConstants.RoutingNodeType routingNodeType) {
        this.errorRateSensor.record(value);
        MetricsKey key = new MetricsKey(sourceType, planType, routingNodeType);
        if (!this.errorRateSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.errorRateSensorMap.get(key).record(value);
    }

    public void recordErrorRateForNoResult(double value) {
        this.errorRateSensor.record(value);
        MetricsKey key = new MetricsKey();
        if (!this.errorRateSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.errorRateSensorMap.get(key).record(value);
    }

    public void recordRequestSize(double value) {
        this.requestSizeSensor.record(value);
    }

    public void recordResponseSize(double value, KsqlConstants.QuerySourceType sourceType, PullPhysicalPlan.PullPhysicalPlanType planType, KsqlConstants.RoutingNodeType routingNodeType) {
        this.responseSizeSensor.record(value);
        MetricsKey key = new MetricsKey(sourceType, planType, routingNodeType);
        if (!this.responseSizeSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.responseSizeSensorMap.get(key).record(value);
    }

    public void recordResponseSizeForError(long responseBytes) {
        this.responseSizeSensor.record((double)responseBytes);
        MetricsKey key = new MetricsKey();
        if (!this.responseSizeSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.responseSizeSensorMap.get(key).record((double)responseBytes);
    }

    public void recordStatusCode(int statusCode) {
        if (statusCode >= 200 && statusCode < 300) {
            this.responseCode2XX.record(1.0);
        } else if (statusCode >= 300 && statusCode < 400) {
            this.responseCode3XX.record(1.0);
        } else if (statusCode >= 400 && statusCode < 500) {
            this.responseCode4XX.record(1.0);
        } else if (statusCode >= 500) {
            this.responseCode5XX.record(1.0);
        }
    }

    public void recordRowsReturned(double value, KsqlConstants.QuerySourceType sourceType, PullPhysicalPlan.PullPhysicalPlanType planType, KsqlConstants.RoutingNodeType routingNodeType) {
        MetricsKey key = new MetricsKey(sourceType, planType, routingNodeType);
        if (!this.rowsReturnedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsReturnedSensorMap.get(key).record(value);
    }

    public void recordZeroRowsReturnedForError() {
        MetricsKey key = new MetricsKey();
        if (!this.rowsReturnedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsReturnedSensorMap.get(key).record(0.0);
    }

    public void recordRowsProcessed(double value, KsqlConstants.QuerySourceType sourceType, PullPhysicalPlan.PullPhysicalPlanType planType, KsqlConstants.RoutingNodeType routingNodeType) {
        MetricsKey key = new MetricsKey(sourceType, planType, routingNodeType);
        if (!this.rowsProcessedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsProcessedSensorMap.get(key).record(value);
    }

    public void recordZeroRowsProcessedForError() {
        MetricsKey key = new MetricsKey();
        if (!this.rowsProcessedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsProcessedSensorMap.get(key).record(0.0);
    }

    public List<Sensor> getSensors() {
        return Collections.unmodifiableList(this.sensors);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public Metrics getMetrics() {
        return this.metrics;
    }

    private Sensor configureLocalRequestsSensor() {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-local");
        this.addSensor(sensor, "pull-query-requests-local-count", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Count of local pull query requests", this.legacyCustomMetricsTags, (MeasurableStat)new CumulativeCount());
        this.addSensor(sensor, "pull-query-requests-local-rate", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Rate of local pull query requests", this.legacyCustomMetricsTags, (MeasurableStat)new Rate());
        this.addSensor(sensor, "pull-query-requests-local-count", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Count of local pull query requests", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.addSensor(sensor, "pull-query-requests-local-rate", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Rate of local pull query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureRemoteRequestsSensor() {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-remote");
        this.addSensor(sensor, "pull-query-requests-remote-count", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Count of remote pull query requests", this.legacyCustomMetricsTags, (MeasurableStat)new CumulativeCount());
        this.addSensor(sensor, "pull-query-requests-remote-rate", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Rate of remote pull query requests", this.legacyCustomMetricsTags, (MeasurableStat)new Rate());
        this.addSensor(sensor, "pull-query-requests-remote-count", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Count of remote pull query requests", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.addSensor(sensor, "pull-query-requests-remote-rate", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Rate of remote pull query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureRateSensor() {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-rate");
        this.addSensor(sensor, "pull-query-requests-rate", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Rate of pull query requests", this.legacyCustomMetricsTags, (MeasurableStat)new Rate());
        this.addSensor(sensor, "pull-query-requests-rate", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Rate of pull query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureErrorRateSensor() {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-error-rate");
        this.addSensor(sensor, "pull-query-requests-error-rate", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Rate of erroneous pull query requests", this.legacyCustomMetricsTags, (MeasurableStat)new Rate());
        this.addSensor(sensor, "pull-query-requests-error-total", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Total number of erroneous pull query requests", this.legacyCustomMetricsTags, (MeasurableStat)new CumulativeCount());
        this.addSensor(sensor, "pull-query-requests-error-rate", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Rate of erroneous pull query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.addSensor(sensor, "pull-query-requests-error-total", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Total number of erroneous pull query requests", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.sensors.add(sensor);
        return sensor;
    }

    private Map<MetricsKey, Sensor> configureErrorSensorMap() {
        return this.configureSensorMap("error", (sensor, tags, variantName) -> this.addSensor(sensor, "pull-query-requests-detailed-error-total", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Total number of erroneous pull query requests - " + variantName, tags, (MeasurableStat)new CumulativeCount()));
    }

    private Sensor configureStatusCodeSensor(String codeName) {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-" + codeName + "-total");
        this.addSensor(sensor, "pull-query-requests-" + codeName + "-total", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Total number of status code " + codeName + " responses", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureLatencySensor() {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-latency");
        this.addRequestMetricsToSensor(sensor, this.ksqlServiceIdLegacyPrefix, PULL_REQUESTS, this.legacyCustomMetricsTags, "");
        this.addRequestMetricsToSensor(sensor, this.ksqlServicePrefix, PULL_REQUESTS, this.customMetricsTags, "");
        this.sensors.add(sensor);
        return sensor;
    }

    private Map<MetricsKey, Sensor> configureLatencySensorMap() {
        return this.configureSensorMap("latency", (sensor, tags, variantName) -> this.addRequestMetricsToSensor(sensor, this.ksqlServicePrefix, "pull-query-requests-detailed", tags, " - " + variantName));
    }

    public void configureThreadPoolMetrics() {
        MetricName coordinatorThreadsAvailable = this.metrics.metricName("pull-query-requests-coordinator-thread-pool-free-size", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Number of available threads in the coordinator pool", this.customMetricsTags);
        this.metrics.addMetric(coordinatorThreadsAvailable, (MetricValueProvider)((Gauge)(config, now) -> this.coordinatorThreadPoolSupplier.get()));
        MetricName routerThreadsAvailable = this.metrics.metricName("pull-query-requests-router-thread-pool-free-size", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Number of available threads in the router pool", this.customMetricsTags);
        this.metrics.addMetric(routerThreadsAvailable, (MetricValueProvider)((Gauge)(config, now) -> this.routerThreadPoolSupplier.get()));
    }

    private void addRequestMetricsToSensor(Sensor sensor, String servicePrefix, String metricNamePrefix, Map<String, String> metricsTags, String descriptionSuffix) {
        this.addSensor(sensor, metricNamePrefix + "-latency-avg", servicePrefix + PULL_QUERY_METRIC_GROUP, "Average time for a pull query request" + descriptionSuffix, metricsTags, (MeasurableStat)new Avg());
        this.addSensor(sensor, metricNamePrefix + "-latency-max", servicePrefix + PULL_QUERY_METRIC_GROUP, "Max time for a pull query request" + descriptionSuffix, metricsTags, (MeasurableStat)new Max());
        this.addSensor(sensor, metricNamePrefix + "-latency-min", servicePrefix + PULL_QUERY_METRIC_GROUP, "Min time for a pull query request" + descriptionSuffix, metricsTags, (MeasurableStat)new Min());
        this.addSensor(sensor, metricNamePrefix + "-total", servicePrefix + PULL_QUERY_METRIC_GROUP, "Total number of pull query requests" + descriptionSuffix, metricsTags, (MeasurableStat)new CumulativeCount());
        sensor.add((CompoundStat)new Percentiles(4000, (double)MAX_LATENCY_BUCKET_VALUE_MICROS, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-50", servicePrefix + PULL_QUERY_METRIC_GROUP, "Latency distribution" + descriptionSuffix, metricsTags), 50.0), new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-75", servicePrefix + PULL_QUERY_METRIC_GROUP, "Latency distribution" + descriptionSuffix, metricsTags), 75.0), new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-90", servicePrefix + PULL_QUERY_METRIC_GROUP, "Latency distribution" + descriptionSuffix, metricsTags), 90.0), new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-99", servicePrefix + PULL_QUERY_METRIC_GROUP, "Latency distribution" + descriptionSuffix, metricsTags), 99.0)}));
    }

    private Sensor configureRequestSizeSensor() {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-request-size");
        this.addSensor(sensor, "pull-query-requests-request-size", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Size in bytes of pull query request", this.legacyCustomMetricsTags, (MeasurableStat)new CumulativeSum());
        this.addSensor(sensor, "pull-query-requests-request-size", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Size in bytes of pull query request", this.customMetricsTags, (MeasurableStat)new CumulativeSum());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureResponseSizeSensor() {
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-response-size");
        this.addSensor(sensor, "pull-query-requests-response-size", this.ksqlServiceIdLegacyPrefix + PULL_QUERY_METRIC_GROUP, "Size in bytes of pull query response", this.legacyCustomMetricsTags, (MeasurableStat)new CumulativeSum());
        this.addSensor(sensor, "pull-query-requests-response-size", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Size in bytes of pull query response", this.customMetricsTags, (MeasurableStat)new CumulativeSum());
        this.sensors.add(sensor);
        return sensor;
    }

    private Map<MetricsKey, Sensor> configureResponseSizeSensorMap() {
        return this.configureSensorMap("response-size", (sensor, tags, variantName) -> this.addSensor(sensor, "pull-query-requests-detailed-response-size", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Size in bytes of pull query response - " + variantName, tags, (MeasurableStat)new CumulativeSum()));
    }

    private Map<MetricsKey, Sensor> configureRowsReturnedSensorMap() {
        return this.configureSensorMap("rows-returned", (sensor, tags, variantName) -> this.addSensor(sensor, "pull-query-requests-rows-returned-total", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Number of rows returned - " + variantName, tags, (MeasurableStat)new CumulativeSum()));
    }

    private Map<MetricsKey, Sensor> configureRowsProcessedSensorMap() {
        return this.configureSensorMap("rows-processed", (sensor, tags, variantName) -> this.addSensor(sensor, "pull-query-requests-rows-processed-total", this.ksqlServicePrefix + PULL_QUERY_METRIC_GROUP, "Number of rows processed -" + variantName, tags, (MeasurableStat)new CumulativeSum()));
    }

    private void addSensor(Sensor sensor, String metricName, String groupName, String description, Map<String, String> metricsTags, MeasurableStat measurableStat) {
        sensor.add(this.metrics.metricName(metricName, groupName, description, metricsTags), measurableStat);
    }

    private Map<MetricsKey, Sensor> configureSensorMap(String sensorBaseName, MetricsAdder metricsAdder) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (KsqlConstants.QuerySourceType sourceType : KsqlConstants.QuerySourceType.values()) {
            for (PullPhysicalPlan.PullPhysicalPlanType planType : PullPhysicalPlan.PullPhysicalPlanType.values()) {
                for (KsqlConstants.RoutingNodeType routingNodeType : KsqlConstants.RoutingNodeType.values()) {
                    this.addSensorToMap(sensorBaseName, metricsAdder, (ImmutableMap.Builder<MetricsKey, Sensor>)builder, new MetricsKey(sourceType, planType, routingNodeType));
                }
            }
        }
        this.addSensorToMap(sensorBaseName, metricsAdder, (ImmutableMap.Builder<MetricsKey, Sensor>)builder, new MetricsKey());
        return builder.build();
    }

    private void addSensorToMap(String sensorBaseName, MetricsAdder metricsAdder, ImmutableMap.Builder<MetricsKey, Sensor> builder, MetricsKey metricsKey) {
        String variantName = metricsKey.variantName();
        Sensor sensor = this.metrics.sensor("pull-query-pull-query-requests-" + sensorBaseName + "-" + variantName);
        ImmutableMap tags = ImmutableMap.builder().putAll(this.customMetricsTags).put((Object)"query_source", (Object)metricsKey.sourceTypeName()).put((Object)"query_plan_type", (Object)metricsKey.planTypeName()).put((Object)"query_routing_type", (Object)metricsKey.routingNodeTypeName()).build();
        metricsAdder.addMetrics(sensor, (Map<String, String>)tags, variantName);
        builder.put((Object)metricsKey, (Object)sensor);
        this.sensors.add(sensor);
    }

    private static class MetricsKey {
        private final KsqlConstants.QuerySourceType sourceType;
        private final PullPhysicalPlan.PullPhysicalPlanType planType;
        private final KsqlConstants.RoutingNodeType routingNodeType;

        MetricsKey() {
            this.sourceType = null;
            this.planType = null;
            this.routingNodeType = null;
        }

        MetricsKey(KsqlConstants.QuerySourceType sourceType, PullPhysicalPlan.PullPhysicalPlanType planType, KsqlConstants.RoutingNodeType routingNodeType) {
            this.sourceType = Objects.requireNonNull(sourceType, "sourceType");
            this.planType = Objects.requireNonNull(planType, "planType");
            this.routingNodeType = Objects.requireNonNull(routingNodeType, "routingNodeType");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricsKey key = (MetricsKey)o;
            return Objects.equals(this.sourceType, key.sourceType) && Objects.equals((Object)this.planType, (Object)key.planType) && Objects.equals(this.routingNodeType, key.routingNodeType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sourceType, this.planType, this.routingNodeType});
        }

        public String toString() {
            return "MetricsKey{sourceType=" + String.valueOf(this.sourceType) + ", planType=" + String.valueOf((Object)this.planType) + ", routingNodeType=" + String.valueOf(this.routingNodeType) + "}";
        }

        public String variantName() {
            return this.sourceTypeName() + "-" + this.planTypeName() + "-" + this.routingNodeTypeName();
        }

        public String sourceTypeName() {
            return this.getName((Enum<?>)this.sourceType);
        }

        public String planTypeName() {
            return this.getName(this.planType);
        }

        public String routingNodeTypeName() {
            return this.getName((Enum<?>)this.routingNodeType);
        }

        private String getName(Enum<?> o) {
            if (o == null) {
                return "unknown";
            }
            return o.name().toLowerCase();
        }
    }

    private static interface MetricsAdder {
        public void addMetrics(Sensor var1, Map<String, String> var2, String var3);
    }
}

