/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.base.Ticker;
import io.confluent.ksql.engine.QueryEventListener;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.QueryMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.streams.KafkaStreams;

public class QueryStateMetricsReportingListener
implements QueryEventListener {
    public static final String QUERY_RESTART_METRIC_NAME = "query-restart-total";
    public static final String QUERY_RESTART_METRIC_DESCRIPTION = "The total number of times that a query thread has failed and then been restarted.";
    public static final Ticker CURRENT_TIME_MILLIS_TICKER = new Ticker(){

        public long read() {
            return System.currentTimeMillis();
        }
    };
    private final Metrics metrics;
    private final String metricsPrefix;
    private final Map<String, String> metricsTags;
    private final ConcurrentMap<QueryId, PerQueryListener> perQuery = new ConcurrentHashMap<QueryId, PerQueryListener>();
    private static final String NO_ERROR = "NO_ERROR";
    private static final int DEFAULT_VAL = -1;

    QueryStateMetricsReportingListener(Metrics metrics, String metricsPrefix, Map<String, String> metricsTags) {
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.metricsPrefix = Objects.requireNonNull(metricsPrefix, "metricGroupPrefix");
        this.metricsTags = Objects.requireNonNull(metricsTags);
    }

    @Override
    public void onCreate(ServiceContext serviceContext, MetaStore metaStore, QueryMetadata queryMetadata) {
        if (this.perQuery.containsKey(queryMetadata.getQueryId())) {
            return;
        }
        this.perQuery.put(queryMetadata.getQueryId(), new PerQueryListener(this.metrics, this.metricsPrefix, queryMetadata.getQueryId().toString(), this.metricsTags));
    }

    @Override
    public void onStateChange(QueryMetadata query, KafkaStreams.State before, KafkaStreams.State after) {
        PerQueryListener listener = (PerQueryListener)this.perQuery.get(query.getQueryId());
        if (listener != null) {
            listener.onChange(before, after);
            listener.setKsqlQueryState(query.getQueryStatus().toString());
        }
    }

    @Override
    public void onKsqlStateChange(QueryMetadata query) {
        PerQueryListener listener = (PerQueryListener)this.perQuery.get(query.getQueryId());
        if (listener != null) {
            listener.setKsqlQueryState(query.getQueryStatus().toString());
        }
    }

    @Override
    public void onError(QueryMetadata query, QueryError error) {
        PerQueryListener listener = (PerQueryListener)this.perQuery.get(query.getQueryId());
        if (listener != null) {
            listener.onError(error);
            listener.setKsqlQueryState(query.getQueryStatus().toString());
        }
    }

    @Override
    public void onDeregister(QueryMetadata query) {
        ((PerQueryListener)this.perQuery.get(query.getQueryId())).onDeregister();
        this.perQuery.remove(query.getQueryId());
    }

    private static class PerQueryListener {
        private final Metrics metrics;
        private final MetricName stateMetricName;
        private final MetricName errorMetricName;
        private final MetricName queryRestartMetricName;
        private final MetricName ksqlQueryStatusMetricName;
        private final MetricName stateNumMetricName;
        private final MetricName errorNumMetricName;
        private final MetricName ksqlQueryStatusNumMetricName;
        private final CumulativeSum queryRestartSum;
        private final Ticker ticker;
        private volatile String state = "-";
        private volatile String ksqlQueryState = "-";
        private volatile String error = "NO_ERROR";

        PerQueryListener(Metrics metrics, String groupPrefix, String queryId, Map<String, String> metricsTags) {
            this(metrics, groupPrefix, queryId, CURRENT_TIME_MILLIS_TICKER, metricsTags);
        }

        PerQueryListener(Metrics metrics, String groupPrefix, String queryId, Ticker ticker, Map<String, String> metricsTags) {
            Objects.requireNonNull(groupPrefix, "groupPrefix");
            Objects.requireNonNull(queryId, "queryId");
            this.metrics = Objects.requireNonNull(metrics, "metrics cannot be null.");
            this.ticker = Objects.requireNonNull(ticker, "ticker");
            String type = queryId.toLowerCase().contains("transient") ? "transient_" : "query_";
            String tag = "_confluent-ksql-" + groupPrefix + type + queryId;
            HashMap<String, String> tagsForStateAndError = new HashMap<String, String>(metricsTags);
            tagsForStateAndError.put("status", tag);
            this.stateMetricName = metrics.metricName("query-status", groupPrefix + "ksql-queries", "The current Kafka Streams status of the given query.", tagsForStateAndError);
            this.errorMetricName = metrics.metricName("error-status", groupPrefix + "ksql-queries", "The current error status of the given query, if the state is in ERROR state", tagsForStateAndError);
            HashMap<String, String> restartTags = new HashMap<String, String>(tagsForStateAndError);
            restartTags.put("query-id", queryId);
            this.queryRestartMetricName = metrics.metricName(QueryStateMetricsReportingListener.QUERY_RESTART_METRIC_NAME, groupPrefix + "ksql-queries", QueryStateMetricsReportingListener.QUERY_RESTART_METRIC_DESCRIPTION, restartTags);
            this.ksqlQueryStatusMetricName = metrics.metricName("ksql-query-status", groupPrefix + "ksql-queries", "The current ksqlDB status of the given query.", tagsForStateAndError);
            this.queryRestartSum = new CumulativeSum();
            this.metrics.addMetric(this.stateMetricName, (MetricValueProvider)((Gauge)(config, now) -> this.state));
            this.metrics.addMetric(this.errorMetricName, (MetricValueProvider)((Gauge)(config, now) -> this.error));
            this.metrics.addMetric(this.queryRestartMetricName, (Measurable)this.queryRestartSum);
            this.metrics.addMetric(this.ksqlQueryStatusMetricName, (MetricValueProvider)((Gauge)(config, now) -> this.ksqlQueryState));
            this.stateNumMetricName = metrics.metricName("query-status-num", groupPrefix + "ksql-queries", "The current Kafka Streams status number of the given query.", tagsForStateAndError);
            this.errorNumMetricName = metrics.metricName("error-status-num", groupPrefix + "ksql-queries", "The current error status number of the given query, if the state is in ERROR state", tagsForStateAndError);
            this.ksqlQueryStatusNumMetricName = metrics.metricName("ksql-query-status-num", groupPrefix + "ksql-queries", "The current ksqlDB status number of the given query.", tagsForStateAndError);
            this.metrics.addMetric(this.stateNumMetricName, (MetricValueProvider)((Gauge)(config, now) -> this.getValue(KafkaStreams.State.class, this.state)));
            this.metrics.addMetric(this.errorNumMetricName, (MetricValueProvider)((Gauge)(config, now) -> this.getValue(QueryError.Type.class, this.error)));
            this.metrics.addMetric(this.ksqlQueryStatusNumMetricName, (MetricValueProvider)((Gauge)(config, now) -> this.getValue(KsqlConstants.KsqlQueryStatus.class, this.ksqlQueryState)));
        }

        public void onChange(KafkaStreams.State newState, KafkaStreams.State oldState) {
            this.state = newState.toString();
            if (newState != KafkaStreams.State.ERROR) {
                this.error = QueryStateMetricsReportingListener.NO_ERROR;
            }
        }

        public void setKsqlQueryState(String ksqlQueryState) {
            this.ksqlQueryState = ksqlQueryState;
        }

        public void onError(QueryError observedError) {
            this.error = observedError.getType().name();
            this.queryRestartSum.record(new MetricConfig(), 1.0, System.currentTimeMillis());
        }

        public void onDeregister() {
            this.metrics.removeMetric(this.stateMetricName);
            this.metrics.removeMetric(this.errorMetricName);
            this.metrics.removeMetric(this.queryRestartMetricName);
            this.metrics.removeMetric(this.ksqlQueryStatusMetricName);
            this.metrics.removeMetric(this.stateNumMetricName);
            this.metrics.removeMetric(this.errorNumMetricName);
            this.metrics.removeMetric(this.ksqlQueryStatusNumMetricName);
        }

        private <T extends Enum<T>> int getValue(Class<T> enumClass, String str) {
            for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
                if (!enumConstant.name().equals(str.toUpperCase())) continue;
                return enumConstant.ordinal();
            }
            return -1;
        }
    }
}

