/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.KsqlConstants;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;

public class ScalablePushQueryMetrics
implements Closeable {
    private static final String SCALABLE_PUSH_QUERY_METRIC_GROUP = "scalable-push-query";
    private static final String SCALABLE_PUSH_REQUESTS = "scalable-push-query-requests";
    private static final long MAX_LATENCY_BUCKET_VALUE_MICROS = TimeUnit.SECONDS.toMicros(10L);
    private static final int NUM_LATENCY_BUCKETS = 1000;
    private final List<Sensor> sensors;
    private final Sensor localRequestsSensor;
    private final Sensor remoteRequestsSensor;
    private final Sensor connectionDurationSensor;
    private final Map<MetricsKey, Sensor> connectionDurationSensorMap;
    private final Sensor requestRateSensor;
    private final Sensor errorRateSensor;
    private final Map<MetricsKey, Sensor> errorRateSensorMap;
    private final Sensor requestSizeSensor;
    private final Sensor responseSizeSensor;
    private final Map<MetricsKey, Sensor> responseSizeSensorMap;
    private final Sensor responseCode2XX;
    private final Sensor responseCode3XX;
    private final Sensor responseCode4XX;
    private final Sensor responseCode5XX;
    private final Map<MetricsKey, Sensor> rowsReturnedSensorMap;
    private final Map<MetricsKey, Sensor> rowsProcessedSensorMap;
    private final Metrics metrics;
    private final Map<String, String> customMetricsTags;
    private final String ksqlServicePrefix;
    private final Time time;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="metrics")
    public ScalablePushQueryMetrics(String ksqlServiceId, Map<String, String> customMetricsTags, Time time, Metrics metrics) {
        this.ksqlServicePrefix = "_confluent-ksql-";
        HashMap<String, String> metricsTags = new HashMap<String, String>(customMetricsTags);
        metricsTags.put("ksql_service_id", ksqlServiceId);
        this.customMetricsTags = ImmutableMap.copyOf(metricsTags);
        this.time = Objects.requireNonNull(time, "time");
        this.metrics = metrics;
        this.sensors = new ArrayList<Sensor>();
        this.localRequestsSensor = this.configureLocalRequestsSensor();
        this.remoteRequestsSensor = this.configureRemoteRequestsSensor();
        this.connectionDurationSensor = this.configureConnectionDurationSensor();
        this.connectionDurationSensorMap = this.configureConnectionDurationSensorMap();
        this.requestRateSensor = this.configureRateSensor();
        this.errorRateSensor = this.configureErrorRateSensor();
        this.errorRateSensorMap = this.configureErrorSensorMap();
        this.requestSizeSensor = this.configureRequestSizeSensor();
        this.responseSizeSensor = this.configureResponseSizeSensor();
        this.responseSizeSensorMap = this.configureResponseSizeSensorMap();
        this.responseCode2XX = this.configureStatusCodeSensor("2XX");
        this.responseCode3XX = this.configureStatusCodeSensor("3XX");
        this.responseCode4XX = this.configureStatusCodeSensor("4XX");
        this.responseCode5XX = this.configureStatusCodeSensor("5XX");
        this.rowsReturnedSensorMap = this.configureRowsReturnedSensorMap();
        this.rowsProcessedSensorMap = this.configureRowsProcessedSensorMap();
    }

    @Override
    public void close() {
        this.sensors.forEach(sensor -> this.metrics.removeSensor(sensor.name()));
    }

    public void recordLocalRequests(double value) {
        this.localRequestsSensor.record(value);
    }

    public void recordRemoteRequests(double value) {
        this.remoteRequestsSensor.record(value);
    }

    public void recordConnectionDuration(long startTimeNanos, KsqlConstants.QuerySourceType sourceType, KsqlConstants.RoutingNodeType routingNodeType) {
        MetricsKey key = new MetricsKey(sourceType, routingNodeType);
        this.innerRecordConnectionDuration(startTimeNanos, key);
    }

    public void recordConnectionDurationForError(long startTimeNanos) {
        MetricsKey key = new MetricsKey();
        this.innerRecordConnectionDuration(startTimeNanos, key);
    }

    private void innerRecordConnectionDuration(long startTimeNanos, MetricsKey key) {
        long nowNanos = this.time.nanoseconds();
        double connectionDuration = TimeUnit.NANOSECONDS.toMicros(nowNanos - startTimeNanos);
        this.connectionDurationSensor.record(connectionDuration);
        this.requestRateSensor.record(1.0);
        if (!this.connectionDurationSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.connectionDurationSensorMap.get(key).record(connectionDuration);
    }

    public void recordErrorRate(double value, KsqlConstants.QuerySourceType sourceType, KsqlConstants.RoutingNodeType routingNodeType) {
        this.errorRateSensor.record(value);
        MetricsKey key = new MetricsKey(sourceType, routingNodeType);
        if (!this.errorRateSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.errorRateSensorMap.get(key).record(value);
    }

    public void recordErrorRateForNoResult(double value) {
        this.errorRateSensor.record(value);
        MetricsKey key = new MetricsKey();
        if (!this.errorRateSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.errorRateSensorMap.get(key).record(value);
    }

    public void recordRequestSize(double value) {
        this.requestSizeSensor.record(value);
    }

    public void recordResponseSize(double value, KsqlConstants.QuerySourceType sourceType, KsqlConstants.RoutingNodeType routingNodeType) {
        this.responseSizeSensor.record(value);
        MetricsKey key = new MetricsKey(sourceType, routingNodeType);
        if (!this.responseSizeSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.responseSizeSensorMap.get(key).record(value);
    }

    public void recordResponseSizeForError(long responseBytes) {
        this.responseSizeSensor.record((double)responseBytes);
        MetricsKey key = new MetricsKey();
        if (!this.responseSizeSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.responseSizeSensorMap.get(key).record((double)responseBytes);
    }

    public void recordStatusCode(int statusCode) {
        if (statusCode >= 200 && statusCode < 300) {
            this.responseCode2XX.record(1.0);
        } else if (statusCode >= 300 && statusCode < 400) {
            this.responseCode3XX.record(1.0);
        } else if (statusCode >= 400 && statusCode < 500) {
            this.responseCode4XX.record(1.0);
        } else if (statusCode >= 500) {
            this.responseCode5XX.record(1.0);
        }
    }

    public void recordRowsReturned(double value, KsqlConstants.QuerySourceType sourceType, KsqlConstants.RoutingNodeType routingNodeType) {
        MetricsKey key = new MetricsKey(sourceType, routingNodeType);
        if (!this.rowsReturnedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsReturnedSensorMap.get(key).record(value);
    }

    public void recordZeroRowsReturnedForError() {
        MetricsKey key = new MetricsKey();
        if (!this.rowsReturnedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsReturnedSensorMap.get(key).record(0.0);
    }

    public void recordRowsProcessed(double value, KsqlConstants.QuerySourceType sourceType, KsqlConstants.RoutingNodeType routingNodeType) {
        MetricsKey key = new MetricsKey(sourceType, routingNodeType);
        if (!this.rowsProcessedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsProcessedSensorMap.get(key).record(value);
    }

    public void recordZeroRowsProcessedForError() {
        MetricsKey key = new MetricsKey();
        if (!this.rowsProcessedSensorMap.containsKey(key)) {
            throw new IllegalStateException("Metrics not configured correctly, missing " + String.valueOf(key));
        }
        this.rowsProcessedSensorMap.get(key).record(0.0);
    }

    public List<Sensor> getSensors() {
        return Collections.unmodifiableList(this.sensors);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public Metrics getMetrics() {
        return this.metrics;
    }

    private Sensor configureLocalRequestsSensor() {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-local");
        this.addSensor(sensor, "scalable-push-query-requests-local-count", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Count of local scalable push query requests", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.addSensor(sensor, "scalable-push-query-requests-local-rate", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Rate of local scalable push query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureRemoteRequestsSensor() {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-remote");
        this.addSensor(sensor, "scalable-push-query-requests-remote-count", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Count of remote scalable push query requests", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.addSensor(sensor, "scalable-push-query-requests-remote-rate", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Rate of remote scalable push query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureRateSensor() {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-rate");
        this.addSensor(sensor, "scalable-push-query-requests-rate", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Rate of pull query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureErrorRateSensor() {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-error-rate");
        this.addSensor(sensor, "scalable-push-query-requests-error-rate", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Rate of erroneous scalable push query requests", this.customMetricsTags, (MeasurableStat)new Rate());
        this.addSensor(sensor, "scalable-push-query-requests-error-total", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Total number of erroneous scalable push query requests", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.sensors.add(sensor);
        return sensor;
    }

    private Map<MetricsKey, Sensor> configureErrorSensorMap() {
        return this.configureSensorMap("error", (sensor, tags, variantName) -> this.addSensor(sensor, "scalable-push-query-requests-detailed-error-total", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Total number of erroneous scalable push query requests - " + variantName, tags, (MeasurableStat)new CumulativeCount()));
    }

    private Sensor configureStatusCodeSensor(String codeName) {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-" + codeName + "-total");
        this.addSensor(sensor, "scalable-push-query-requests-" + codeName + "-total", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Total number of status code " + codeName + " responses", this.customMetricsTags, (MeasurableStat)new CumulativeCount());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureConnectionDurationSensor() {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-connection-duration");
        this.addRequestMetricsToSensor(sensor, this.ksqlServicePrefix, SCALABLE_PUSH_REQUESTS, this.customMetricsTags, "");
        this.sensors.add(sensor);
        return sensor;
    }

    private Map<MetricsKey, Sensor> configureConnectionDurationSensorMap() {
        return this.configureSensorMap("connection-duration", (sensor, tags, variantName) -> this.addRequestMetricsToSensor(sensor, this.ksqlServicePrefix, "scalable-push-query-requests-detailed", tags, " - " + variantName));
    }

    private void addRequestMetricsToSensor(Sensor sensor, String servicePrefix, String metricNamePrefix, Map<String, String> metricsTags, String descriptionSuffix) {
        this.addSensor(sensor, metricNamePrefix + "-connection-duration-avg", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Average time for a scalable push query request" + descriptionSuffix, metricsTags, (MeasurableStat)new Avg());
        this.addSensor(sensor, metricNamePrefix + "-connection-duration-max", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Max time for a scalable push query request" + descriptionSuffix, metricsTags, (MeasurableStat)new Max());
        this.addSensor(sensor, metricNamePrefix + "-connection-duration-min", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Min time for a scalable push query request" + descriptionSuffix, metricsTags, (MeasurableStat)new Min());
        this.addSensor(sensor, metricNamePrefix + "-total", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Total number of scalable push query requests" + descriptionSuffix, metricsTags, (MeasurableStat)new CumulativeCount());
        sensor.add((CompoundStat)new Percentiles(4000, (double)MAX_LATENCY_BUCKET_VALUE_MICROS, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-50", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Connection duration distribution" + descriptionSuffix, metricsTags), 50.0), new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-75", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Connection duration distribution" + descriptionSuffix, metricsTags), 75.0), new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-90", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Connection duration distribution" + descriptionSuffix, metricsTags), 90.0), new Percentile(this.metrics.metricName(metricNamePrefix + "-distribution-99", servicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Connection duration distribution" + descriptionSuffix, metricsTags), 99.0)}));
    }

    private Sensor configureRequestSizeSensor() {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-request-size");
        this.addSensor(sensor, "scalable-push-query-requests-request-size", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Size in bytes of scalable push query request", this.customMetricsTags, (MeasurableStat)new CumulativeSum());
        this.sensors.add(sensor);
        return sensor;
    }

    private Sensor configureResponseSizeSensor() {
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-response-size");
        this.addSensor(sensor, "scalable-push-query-requests-response-size", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Size in bytes of scalable push query response", this.customMetricsTags, (MeasurableStat)new CumulativeSum());
        this.sensors.add(sensor);
        return sensor;
    }

    private Map<MetricsKey, Sensor> configureResponseSizeSensorMap() {
        return this.configureSensorMap("response-size", (sensor, tags, variantName) -> this.addSensor(sensor, "scalable-push-query-requests-detailed-response-size", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Size in bytes of scalable push query response - " + variantName, tags, (MeasurableStat)new CumulativeSum()));
    }

    private Map<MetricsKey, Sensor> configureRowsReturnedSensorMap() {
        return this.configureSensorMap("rows-returned", (sensor, tags, variantName) -> this.addSensor(sensor, "scalable-push-query-requests-rows-returned-total", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Number of rows returned - " + variantName, tags, (MeasurableStat)new CumulativeSum()));
    }

    private Map<MetricsKey, Sensor> configureRowsProcessedSensorMap() {
        return this.configureSensorMap("rows-processed", (sensor, tags, variantName) -> this.addSensor(sensor, "scalable-push-query-requests-rows-processed-total", this.ksqlServicePrefix + SCALABLE_PUSH_QUERY_METRIC_GROUP, "Number of rows processed -" + variantName, tags, (MeasurableStat)new CumulativeSum()));
    }

    private void addSensor(Sensor sensor, String metricName, String groupName, String description, Map<String, String> metricsTags, MeasurableStat measurableStat) {
        sensor.add(this.metrics.metricName(metricName, groupName, description, metricsTags), measurableStat);
    }

    private Map<MetricsKey, Sensor> configureSensorMap(String sensorBaseName, MetricsAdder metricsAdder) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (KsqlConstants.QuerySourceType sourceType : KsqlConstants.QuerySourceType.values()) {
            for (KsqlConstants.RoutingNodeType routingNodeType : KsqlConstants.RoutingNodeType.values()) {
                this.addSensorToMap(sensorBaseName, metricsAdder, (ImmutableMap.Builder<MetricsKey, Sensor>)builder, new MetricsKey(sourceType, routingNodeType));
            }
        }
        this.addSensorToMap(sensorBaseName, metricsAdder, (ImmutableMap.Builder<MetricsKey, Sensor>)builder, new MetricsKey());
        return builder.build();
    }

    private void addSensorToMap(String sensorBaseName, MetricsAdder metricsAdder, ImmutableMap.Builder<MetricsKey, Sensor> builder, MetricsKey metricsKey) {
        String variantName = metricsKey.variantName();
        Sensor sensor = this.metrics.sensor("scalable-push-query-scalable-push-query-requests-" + sensorBaseName + "-" + variantName);
        ImmutableMap tags = ImmutableMap.builder().putAll(this.customMetricsTags).put((Object)"query_source", (Object)metricsKey.sourceTypeName()).put((Object)"query_routing_type", (Object)metricsKey.routingNodeTypeName()).build();
        metricsAdder.addMetrics(sensor, (Map<String, String>)tags, variantName);
        builder.put((Object)metricsKey, (Object)sensor);
        this.sensors.add(sensor);
    }

    private static class MetricsKey {
        private final KsqlConstants.QuerySourceType sourceType;
        private final KsqlConstants.RoutingNodeType routingNodeType;

        MetricsKey() {
            this.sourceType = null;
            this.routingNodeType = null;
        }

        MetricsKey(KsqlConstants.QuerySourceType sourceType, KsqlConstants.RoutingNodeType routingNodeType) {
            this.sourceType = Objects.requireNonNull(sourceType, "sourceType");
            this.routingNodeType = Objects.requireNonNull(routingNodeType, "routingNodeType");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricsKey key = (MetricsKey)o;
            return Objects.equals(this.sourceType, key.sourceType) && Objects.equals(this.routingNodeType, key.routingNodeType);
        }

        public int hashCode() {
            return Objects.hash(this.sourceType, this.routingNodeType);
        }

        public String toString() {
            return "MetricsKey{sourceType=" + String.valueOf(this.sourceType) + ", routingNodeType=" + String.valueOf(this.routingNodeType) + "}";
        }

        public String variantName() {
            return this.sourceTypeName() + "-" + this.routingNodeTypeName();
        }

        public String sourceTypeName() {
            return this.getName((Enum<?>)this.sourceType);
        }

        public String routingNodeTypeName() {
            return this.getName((Enum<?>)this.routingNodeType);
        }

        private String getName(Enum<?> o) {
            if (o == null) {
                return "unknown";
            }
            return o.name().toLowerCase();
        }
    }

    private static interface MetricsAdder {
        public void addMetrics(Sensor var1, Map<String, String> var2, String var3);
    }
}

