/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.query;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.rewrite.QueryAnonymizer;
import io.confluent.ksql.logging.query.QueryLoggerMessage;
import io.confluent.ksql.parser.SqlFormatter;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.QueryGuid;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.message.Message;

public final class QueryLogger {
    private static final Logger logger = LogManager.getLogger(QueryLogger.class);
    private static final QueryAnonymizer anonymizer = new QueryAnonymizer();
    private static String namespace = "";
    private static Boolean anonymizeQueries = true;

    private QueryLogger() {
    }

    @VisibleForTesting
    public static String getNamespace() {
        return namespace;
    }

    public static void addAppender(Appender appender) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        appender.start();
        config.addAppender(appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        loggerConfig.addAppender(appender, null, null);
        context.updateLoggers();
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static Logger getLogger() {
        return logger;
    }

    public static void configure(KsqlConfig config) {
        String clusterNamespace = config.getString("ksql.queryanonymizer.cluster_namespace");
        namespace = clusterNamespace == null || clusterNamespace.isEmpty() ? config.getString("ksql.service.id") : clusterNamespace;
        anonymizeQueries = config.getBoolean("ksql.queryanonymizer.logs_enabled");
    }

    private static void log(Level level, Object message, Statement query) {
        String queryString = SqlFormatter.formatSql((AstNode)query);
        QueryLogger.log(level, message, queryString);
    }

    private static void log(Level level, Object message, String query) {
        QueryLogger.log(level, message, query, null);
    }

    private static void log(Level level, Object message, String query, Throwable t) {
        try {
            String anonQuery = anonymizeQueries != false ? anonymizer.anonymize(query) : query;
            QueryGuid queryGuids = QueryLogger.buildGuids(query, anonQuery);
            QueryLoggerMessage payload = QueryLogger.buildPayload(message, anonQuery, queryGuids);
            QueryLogger.innerLog(level, payload, t);
        }
        catch (Exception e) {
            String unparsable = "<unparsable query>";
            QueryLoggerMessage payload = QueryLogger.buildPayload(message, "<unparsable query>", QueryLogger.buildGuids(query, "<unparsable query>"));
            QueryLogger.innerLog(level, payload, t);
        }
    }

    private static void innerLog(Level level, QueryLoggerMessage payload, Throwable t) {
        if (t == null) {
            logger.log(level, (Message)payload);
        } else {
            logger.log(level, (Message)payload, t);
        }
    }

    private static QueryGuid buildGuids(String query, String anonymizedQuery) {
        return new QueryGuid(namespace, query, anonymizedQuery);
    }

    private static QueryLoggerMessage buildPayload(Object message, String query, QueryGuid guid) {
        return new QueryLoggerMessage(message, query, guid);
    }

    public static void debug(Object message, String query) {
        QueryLogger.log(Level.DEBUG, message, query);
    }

    public static void debug(Object message, Statement query) {
        QueryLogger.log(Level.DEBUG, message, query);
    }

    public static void info(Object message, String query) {
        QueryLogger.log(Level.INFO, message, query);
    }

    public static void info(Object message, String query, Throwable t) {
        QueryLogger.log(Level.INFO, message, query, t);
    }

    public static void info(Object message, Statement query) {
        QueryLogger.log(Level.INFO, message, query);
    }

    public static void warn(Object message, String query) {
        QueryLogger.log(Level.WARN, message, query);
    }

    public static void warn(Object message, String query, Throwable t) {
        QueryLogger.log(Level.WARN, message, query, t);
    }

    public static void warn(Object message, Statement query) {
        QueryLogger.log(Level.WARN, message, query);
    }

    public static void error(Object message, String query) {
        QueryLogger.log(Level.ERROR, message, query);
    }

    public static void error(Object message, Statement query) {
        QueryLogger.log(Level.ERROR, message, query);
    }

    public static void error(String message, String query, Throwable t) {
        QueryLogger.log(Level.ERROR, message, query, t);
    }
}

