/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logicalplanner;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.logicalplanner.LogicalPlan;
import io.confluent.ksql.logicalplanner.nodes.SelectNode;
import io.confluent.ksql.logicalplanner.nodes.StreamSourceNode;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Select;
import java.util.Objects;

public final class LogicalPlanner {
    private LogicalPlanner() {
    }

    public static LogicalPlan buildPlan(MetaStore metaStore, Query query) {
        Objects.requireNonNull(metaStore, "metaStore");
        Objects.requireNonNull(query, "query");
        AliasedRelation inputStreamOrTable = (AliasedRelation)query.getFrom();
        SourceName sourceName = inputStreamOrTable.getAlias();
        DataSource sourceStreamOrTable = metaStore.getSource(sourceName);
        if (sourceStreamOrTable.getDataSourceType() != DataSource.DataSourceType.KSTREAM) {
            if (sourceStreamOrTable.getDataSourceType() == DataSource.DataSourceType.KTABLE) {
                throw new UnsupportedOperationException("Input TABLES are not supported by the new planner");
            }
            throw new IllegalArgumentException("Unknown data source type " + String.valueOf(sourceStreamOrTable.getDataSourceType()));
        }
        StreamSourceNode sourceNode = new StreamSourceNode(sourceName, sourceStreamOrTable.getSchema());
        Select selectClause = query.getSelect();
        SelectNode selectNode = new SelectNode(sourceNode, selectClause);
        return new LogicalPlan(selectNode, (ImmutableSet<SourceName>)ImmutableSet.of((Object)sourceName));
    }
}

