/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.physicalplanner.nodes;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.physicalplanner.nodes.Node;
import java.util.Objects;

public abstract class SingleInputNode<AcceptsT extends Node<?>>
implements Node<AcceptsT> {
    final Node<?> input;
    final ImmutableList<ColumnName> keyColumns;
    final ImmutableList<ColumnName> valueColumns;

    SingleInputNode(Node<?> input, ImmutableList<ColumnName> keyColumns, ImmutableList<ColumnName> valueColumns) {
        this.input = Objects.requireNonNull(input, "input");
        this.keyColumns = Objects.requireNonNull(keyColumns, "keyColumns");
        this.valueColumns = Objects.requireNonNull(valueColumns, "valueColumns");
    }

    @Override
    public ImmutableList<ColumnName> keyColumnNames() {
        return this.keyColumns;
    }

    @Override
    public ImmutableList<ColumnName> valueColumnNames() {
        return this.valueColumns;
    }

    public Node<?> getInputNode() {
        return this.input;
    }
}

