/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.physicalplanner.nodes;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.physicalplanner.nodes.Node;
import io.confluent.ksql.physicalplanner.nodes.NodeVisitor;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueFormat;
import java.util.List;
import java.util.Objects;

public final class StreamSourceNode
implements Node<StreamSourceNode> {
    private final SourceName sourceName;
    private final LogicalSchema simpleSchema;
    private final KeyFormat keyFormat;
    private final ValueFormat valueFormat;
    private final ImmutableList<ColumnName> keyColumns;
    private final ImmutableList<ColumnName> valueColumns;

    public StreamSourceNode(SourceName sourceName, LogicalSchema simpleSchema, KeyFormat keyFormat, ValueFormat valueFormat) {
        this.sourceName = Objects.requireNonNull(sourceName, "sourceName");
        this.simpleSchema = Objects.requireNonNull(simpleSchema, "simpleSchema");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        this.keyColumns = StreamSourceNode.toColumNames(simpleSchema.key());
        this.valueColumns = StreamSourceNode.toColumNames(simpleSchema.value());
    }

    private static ImmutableList<ColumnName> toColumNames(List<Column> columns) {
        return (ImmutableList)columns.stream().map(Column::name).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<ColumnName> keyColumnNames() {
        return this.keyColumns;
    }

    @Override
    public ImmutableList<ColumnName> valueColumnNames() {
        return this.valueColumns;
    }

    @Override
    public Formats getFormats() {
        return Formats.of((FormatInfo)this.keyFormat.getFormatInfo(), (FormatInfo)this.valueFormat.getFormatInfo(), (SerdeFeatures)this.keyFormat.getFeatures(), (SerdeFeatures)this.valueFormat.getFeatures());
    }

    @Override
    public <ReturnsT> ReturnsT accept(NodeVisitor<StreamSourceNode, ReturnsT> visitor) {
        return visitor.process(this);
    }

    public SourceName getSourceName() {
        return this.sourceName;
    }

    public LogicalSchema getSimpleSchema() {
        return this.simpleSchema;
    }
}

