/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner;

import com.google.common.collect.Iterables;
import io.confluent.ksql.analyzer.AggregateAnalysisResult;
import io.confluent.ksql.analyzer.AggregateAnalyzer;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.FilterTypeValidator;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.RewrittenAnalysis;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.streams.PartitionByParamsFactory;
import io.confluent.ksql.execution.streams.timestamp.TimestampExtractionPolicyFactory;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.udf.AsValue;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.planner.JoinTree;
import io.confluent.ksql.planner.Projection;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.AggregateNode;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.FilterNode;
import io.confluent.ksql.planner.plan.FinalProjectNode;
import io.confluent.ksql.planner.plan.FlatMapNode;
import io.confluent.ksql.planner.plan.JoinNode;
import io.confluent.ksql.planner.plan.KsqlBareOutputNode;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.PreJoinProjectNode;
import io.confluent.ksql.planner.plan.PreJoinRepartitionNode;
import io.confluent.ksql.planner.plan.ProjectNode;
import io.confluent.ksql.planner.plan.QueryFilterNode;
import io.confluent.ksql.planner.plan.QueryLimitNode;
import io.confluent.ksql.planner.plan.QueryProjectNode;
import io.confluent.ksql.planner.plan.SelectionUtil;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.planner.plan.UserRepartitionNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.util.GrammaticalJoiner;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LogicalPlanner {
    private final KsqlConfig ksqlConfig;
    private final RewrittenAnalysis analysis;
    private final MetaStore metaStore;
    private final AggregateAnalyzer aggregateAnalyzer;
    private final ColumnReferenceRewriter refRewriter;

    public LogicalPlanner(KsqlConfig ksqlConfig, ImmutableAnalysis analysis, MetaStore metaStore) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.refRewriter = new ColumnReferenceRewriter(analysis.getFromSourceSchemas(false).isJoin());
        this.analysis = new RewrittenAnalysis(analysis, (arg_0, arg_1) -> ((ColumnReferenceRewriter)this.refRewriter).process(arg_0, arg_1));
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
        this.aggregateAnalyzer = new AggregateAnalyzer((FunctionRegistry)metaStore);
    }

    public OutputNode buildPersistentLogicalPlan() {
        boolean isWindowed = this.analysis.getFrom().getDataSource().getKsqlTopic().getKeyFormat().isWindowed();
        PlanNode currentNode = this.buildSourceNode(isWindowed);
        if (this.analysis.getWhereExpression().isPresent()) {
            currentNode = this.buildFilterNode(currentNode, this.analysis.getWhereExpression().get());
        }
        if (this.analysis.original().getPartitionBy().isPresent()) {
            currentNode = this.buildUserRepartitionNode(currentNode, this.analysis.original().getPartitionBy().get());
        }
        if (!this.analysis.getTableFunctions().isEmpty()) {
            currentNode = this.buildFlatMapNode(currentNode);
        }
        if (this.analysis.getGroupBy().isPresent() || !this.analysis.getAggregateFunctions().isEmpty()) {
            currentNode = this.buildAggregateNode(currentNode);
        } else {
            if (this.analysis.getWindowExpression().isPresent()) {
                String loc = this.analysis.getWindowExpression().get().getLocation().map(NodeLocation::asPrefix).orElse("");
                throw new KsqlException(loc + "WINDOW clause requires a GROUP BY clause.");
            }
            if (this.analysis.getLimitClause().isPresent()) {
                currentNode = this.buildLimitNode(currentNode, this.analysis.getLimitClause().getAsInt());
            }
            currentNode = this.buildUserProjectNode(currentNode);
        }
        if (this.analysis.getRefinementInfo().isPresent() && this.analysis.getRefinementInfo().get().getOutputRefinement() == OutputRefinement.FINAL) {
            if (!this.ksqlConfig.getBoolean("ksql.suppress.enabled").booleanValue()) {
                throw new KsqlException("Suppression is currently disabled. You can enable it by setting ksql.suppress.enabled to true");
            }
            if (!this.analysis.getGroupBy().isPresent() || !this.analysis.getWindowExpression().isPresent()) {
                throw new KsqlException("EMIT FINAL is only supported for windowed aggregations.");
            }
        }
        return this.buildOutputNode(currentNode);
    }

    public OutputNode buildQueryLogicalPlan(QueryPlannerOptions queryPlannerOptions, boolean isScalablePush) {
        boolean isWindowed = this.analysis.getFrom().getDataSource().getKsqlTopic().getKeyFormat().isWindowed();
        PlanNode currentNode = this.buildSourceNode(isWindowed);
        if (this.analysis.getWhereExpression().isPresent()) {
            Expression whereExpression = this.analysis.getWhereExpression().get();
            FilterTypeValidator validator = new FilterTypeValidator(currentNode.getSchema(), (FunctionRegistry)this.metaStore, FilterTypeValidator.FilterType.WHERE);
            validator.validateFilterExpression(whereExpression);
            currentNode = new QueryFilterNode(new PlanNodeId("WhereFilter"), currentNode, whereExpression, this.metaStore, this.ksqlConfig, isWindowed, queryPlannerOptions);
        } else if (!queryPlannerOptions.getTableScansEnabled()) {
            throw QueryFilterNode.invalidWhereClauseException("Missing WHERE clause", isWindowed);
        }
        if (!isScalablePush && this.analysis.getLimitClause().isPresent()) {
            currentNode = this.buildLimitNode(currentNode, this.analysis.getLimitClause().getAsInt());
        }
        currentNode = new QueryProjectNode(new PlanNodeId("Project"), currentNode, this.analysis.getSelectItems(), this.metaStore, this.ksqlConfig, this.analysis, isWindowed, queryPlannerOptions, isScalablePush);
        return this.buildOutputNode(currentNode);
    }

    private OutputNode buildOutputNode(PlanNode sourcePlanNode) {
        LogicalSchema inputSchema = sourcePlanNode.getSchema();
        Optional<TimestampColumn> timestampColumn = this.getTimestampColumn(inputSchema, this.analysis);
        if (!this.analysis.getInto().isPresent()) {
            return new KsqlBareOutputNode(new PlanNodeId("KSQL_STDOUT_NAME"), sourcePlanNode, inputSchema, this.analysis.getLimitClause(), timestampColumn, this.getWindowInfo());
        }
        Analysis.Into into = this.analysis.getInto().get();
        KsqlTopic existingTopic = this.getSinkTopic(into, sourcePlanNode.getSchema());
        return new KsqlStructuredDataOutputNode(new PlanNodeId(into.getName().text()), sourcePlanNode, inputSchema, timestampColumn, existingTopic, this.analysis.getLimitClause(), into.isCreate(), into.getName(), this.analysis.getOrReplace());
    }

    private Optional<WindowInfo> getWindowInfo() {
        KsqlTopic srcTopic = this.analysis.getFrom().getDataSource().getKsqlTopic();
        Optional explicitWindowInfo = this.analysis.getWindowExpression().map(WindowExpression::getKsqlWindowExpression).map(KsqlWindowExpression::getWindowInfo);
        return explicitWindowInfo.isPresent() ? explicitWindowInfo : srcTopic.getKeyFormat().getWindowInfo();
    }

    private KsqlTopic getSinkTopic(Analysis.Into into, LogicalSchema schema) {
        if (into.getExistingTopic().isPresent()) {
            return into.getExistingTopic().get();
        }
        Analysis.Into.NewTopic newTopic = into.getNewTopic().orElseThrow(IllegalStateException::new);
        FormatInfo keyFormat = this.getSinkKeyFormat(schema, newTopic);
        SerdeFeatures keyFeatures = SerdeFeaturesFactory.buildKeyFeatures(schema, FormatFactory.of((FormatInfo)keyFormat));
        SerdeFeatures valFeatures = SerdeFeaturesFactory.buildValueFeatures(schema, FormatFactory.of((FormatInfo)newTopic.getValueFormat()), this.analysis.getProperties().getValueSerdeFeatures(), this.ksqlConfig);
        return new KsqlTopic(newTopic.getTopicName(), KeyFormat.of((FormatInfo)keyFormat, (SerdeFeatures)keyFeatures, newTopic.getWindowInfo()), ValueFormat.of((FormatInfo)newTopic.getValueFormat(), (SerdeFeatures)valFeatures));
    }

    private FormatInfo getSinkKeyFormat(LogicalSchema schema, Analysis.Into.NewTopic newTopic) {
        boolean inheritedNone;
        boolean resultHasKeyColumns = !schema.key().isEmpty();
        boolean bl = inheritedNone = !this.analysis.getProperties().getKeyFormat().isPresent() && newTopic.getKeyFormat().getFormat().equals("NONE");
        if (!inheritedNone || !resultHasKeyColumns) {
            return newTopic.getKeyFormat();
        }
        String defaultKeyFormat = this.ksqlConfig.getString("ksql.persistence.default.format.key");
        return FormatInfo.of((String)defaultKeyFormat);
    }

    private Optional<TimestampColumn> getTimestampColumn(LogicalSchema inputSchema, ImmutableAnalysis analysis) {
        Optional timestampColumnName = analysis.getProperties().getTimestampColumnName();
        Optional<TimestampColumn> timestampColumn = timestampColumnName.map(n -> new TimestampColumn(n, analysis.getProperties().getTimestampFormat()));
        TimestampExtractionPolicyFactory.validateTimestampColumn((KsqlConfig)this.ksqlConfig, (LogicalSchema)inputSchema, timestampColumn);
        return timestampColumn;
    }

    private Optional<LogicalSchema> getTargetSchema() {
        return this.analysis.getInto().filter(i -> !i.isCreate()).map(i -> this.metaStore.getSource(i.getName())).map(DataSource::getSchema);
    }

    private AggregateNode buildAggregateNode(PlanNode sourcePlanNode) {
        GroupBy groupBy = this.analysis.getGroupBy().orElseThrow(IllegalStateException::new);
        List<SelectExpression> projectionExpressions = SelectionUtil.buildSelectExpressions(sourcePlanNode, this.analysis.getSelectItems(), this.getTargetSchema());
        RewrittenAggregateAnalysis aggregateAnalysis = new RewrittenAggregateAnalysis(this.aggregateAnalyzer.analyze(this.analysis, projectionExpressions), (arg_0, arg_1) -> ((ColumnReferenceRewriter)this.refRewriter).process(arg_0, arg_1));
        LogicalSchema schema = this.buildAggregateSchema(sourcePlanNode, groupBy, projectionExpressions);
        if (this.analysis.getHavingExpression().isPresent()) {
            FilterTypeValidator validator = new FilterTypeValidator(sourcePlanNode.getSchema(), (FunctionRegistry)this.metaStore, FilterTypeValidator.FilterType.HAVING);
            validator.validateFilterExpression(this.analysis.getHavingExpression().get());
        }
        return new AggregateNode(new PlanNodeId("Aggregate"), sourcePlanNode, schema, groupBy, (FunctionRegistry)this.metaStore, this.analysis, aggregateAnalysis, projectionExpressions, this.analysis.getInto().isPresent(), this.ksqlConfig, sourcePlanNode.getSchema());
    }

    private ProjectNode buildUserProjectNode(PlanNode parentNode) {
        return new FinalProjectNode(new PlanNodeId("Project"), parentNode, this.analysis.getSelectItems(), this.analysis.getInto(), this.metaStore);
    }

    private static ProjectNode buildInternalProjectNode(PlanNode parent, String id, SourceName sourceAlias) {
        return new PreJoinProjectNode(new PlanNodeId(id), parent, sourceAlias);
    }

    private FilterNode buildFilterNode(PlanNode sourcePlanNode, Expression filterExpression) {
        FilterTypeValidator validator = new FilterTypeValidator(sourcePlanNode.getSchema(), (FunctionRegistry)this.metaStore, FilterTypeValidator.FilterType.WHERE);
        validator.validateFilterExpression(filterExpression);
        return new FilterNode(new PlanNodeId("WhereFilter"), sourcePlanNode, filterExpression);
    }

    private QueryLimitNode buildLimitNode(PlanNode sourcePlanNode, int limit) {
        return new QueryLimitNode(new PlanNodeId("LimitClause"), sourcePlanNode, limit);
    }

    private UserRepartitionNode buildUserRepartitionNode(PlanNode currentNode, PartitionBy partitionBy) {
        List<Expression> rewrittenPartitionBys = partitionBy.getExpressions().stream().map(exp -> ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((ColumnReferenceRewriter)this.refRewriter).process(arg_0, arg_1), exp)).collect(Collectors.toList());
        LogicalSchema schema = this.buildRepartitionedSchema(currentNode, rewrittenPartitionBys);
        return new UserRepartitionNode(new PlanNodeId("PartitionBy"), currentNode, schema, partitionBy.getExpressions(), rewrittenPartitionBys);
    }

    private PreJoinRepartitionNode buildInternalRepartitionNode(PlanNode source, String prefix, Expression joinExpression, BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> plugin) {
        Expression rewrittenPartitionBy = ExpressionTreeRewriter.rewriteWith(plugin, joinExpression);
        LogicalSchema schema = this.buildRepartitionedSchema(source, Collections.singletonList(rewrittenPartitionBy));
        return new PreJoinRepartitionNode(new PlanNodeId(prefix + "SourceKeyed"), source, schema, rewrittenPartitionBy);
    }

    private FlatMapNode buildFlatMapNode(PlanNode sourcePlanNode) {
        return new FlatMapNode(new PlanNodeId("FlatMap"), sourcePlanNode, (FunctionRegistry)this.metaStore, this.analysis);
    }

    private PlanNode prepareSourceForJoin(JoinTree.Node node, PlanNode joinSource, String prefix, JoinSide side, Expression joinExpression, boolean isForeignKeyJoin) {
        if (node instanceof JoinTree.Join) {
            return this.prepareSourceForJoin((JoinTree.Join)node, joinSource, prefix, side, joinExpression, isForeignKeyJoin);
        }
        return this.prepareSourceForJoin((DataSourceNode)joinSource, prefix, side, joinExpression, isForeignKeyJoin);
    }

    private PlanNode prepareSourceForJoin(DataSourceNode sourceNode, String prefix, JoinSide side, Expression joinExpression, boolean isForeignKeyJoin) {
        PlanNode preProjectNode;
        if (isForeignKeyJoin && !this.shouldRepartitionFKJoin(sourceNode, side)) {
            preProjectNode = sourceNode;
        } else {
            VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> rewriter = new VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>>(Optional.empty()){

                public Optional<Expression> visitQualifiedColumnReference(QualifiedColumnReferenceExp node, ExpressionTreeRewriter.Context<Void> ctx) {
                    return Optional.of(new UnqualifiedColumnReferenceExp(node.getColumnName()));
                }
            };
            preProjectNode = this.buildInternalRepartitionNode(sourceNode, prefix, joinExpression, (arg_0, arg_1) -> ((VisitParentExpressionVisitor)rewriter).process(arg_0, arg_1));
        }
        return LogicalPlanner.buildInternalProjectNode(preProjectNode, "PrependAlias" + prefix, sourceNode.getAlias());
    }

    private PlanNode prepareSourceForJoin(JoinTree.Join join, PlanNode joinedSource, String prefix, JoinSide side, Expression joinExpression, boolean isForeignKeyJoin) {
        if (isForeignKeyJoin && !this.shouldRepartitionFKJoin(joinedSource, side)) {
            return joinedSource;
        }
        if (join.joinEquivalenceSet().contains(joinExpression)) {
            return joinedSource;
        }
        return this.buildInternalRepartitionNode(joinedSource, prefix, joinExpression, (arg_0, arg_1) -> ((ColumnReferenceRewriter)this.refRewriter).process(arg_0, arg_1));
    }

    private PlanNode buildSourceNode(boolean isWindowed) {
        if (!this.analysis.isJoin()) {
            return LogicalPlanner.buildNonJoinNode(this.analysis.getFrom(), isWindowed, this.ksqlConfig);
        }
        List<Analysis.JoinInfo> joinInfo = this.analysis.getJoin();
        JoinTree.Node tree = JoinTree.build(joinInfo);
        if (tree instanceof JoinTree.Leaf) {
            throw new IllegalStateException("Expected more than one source:" + String.valueOf(this.analysis.getAllDataSources()));
        }
        JoinNode joinNode = this.buildJoin((JoinTree.Join)tree, "", isWindowed);
        joinNode.resolveKeyFormats();
        return joinNode;
    }

    private JoinNode buildJoin(JoinTree.Join root, String prefix, boolean isWindowed) {
        PlanNode preRepartitionRight;
        PlanNode preRepartitionLeft;
        if (root.getLeft() instanceof JoinTree.Join) {
            preRepartitionLeft = this.buildJoin((JoinTree.Join)root.getLeft(), prefix + "L_", isWindowed);
        } else {
            JoinTree.Leaf leaf = (JoinTree.Leaf)root.getLeft();
            preRepartitionLeft = new DataSourceNode(new PlanNodeId("KafkaTopic_" + prefix + String.valueOf((Object)JoinSide.LEFT)), leaf.getSource().getDataSource(), leaf.getSource().getAlias(), isWindowed);
        }
        if (root.getRight() instanceof JoinTree.Join) {
            preRepartitionRight = this.buildJoin((JoinTree.Join)root.getRight(), prefix + "R_", isWindowed);
        } else {
            JoinTree.Leaf leaf = (JoinTree.Leaf)root.getRight();
            preRepartitionRight = new DataSourceNode(new PlanNodeId("KafkaTopic_" + prefix + String.valueOf((Object)JoinSide.RIGHT)), leaf.getSource().getDataSource(), leaf.getSource().getAlias(), isWindowed);
        }
        Optional<Expression> fkExpression = this.verifyJoin(root.getInfo(), preRepartitionLeft, preRepartitionRight);
        JoinNode.JoinKey joinKey = fkExpression.map(columnReferenceExp -> this.buildForeignJoinKey(root, (Expression)fkExpression.get())).orElseGet(() -> this.buildJoinKey(root));
        PlanNode left = this.prepareSourceForJoin(root.getLeft(), preRepartitionLeft, prefix + String.valueOf((Object)JoinSide.LEFT), JoinSide.LEFT, root.getInfo().getLeftJoinExpression(), fkExpression.isPresent());
        PlanNode right = this.prepareSourceForJoin(root.getRight(), preRepartitionRight, prefix + String.valueOf((Object)JoinSide.RIGHT), JoinSide.RIGHT, root.getInfo().getRightJoinExpression(), fkExpression.isPresent());
        return new JoinNode(new PlanNodeId(prefix + "Join"), root.getInfo().getType(), joinKey.rewriteWith((arg_0, arg_1) -> ((ColumnReferenceRewriter)this.refRewriter).process(arg_0, arg_1)), prefix.isEmpty(), left, right, root.getInfo().getWithinExpression(), this.ksqlConfig.getString("ksql.persistence.default.format.key"));
    }

    private Optional<Expression> verifyJoin(Analysis.JoinInfo joinInfo, PlanNode leftNode, PlanNode rightNode) {
        JoinNode.JoinType joinType = joinInfo.getType();
        Expression leftExpression = joinInfo.getLeftJoinExpression();
        Expression rightExpression = joinInfo.getRightJoinExpression();
        if (leftNode.getNodeOutputType() == DataSource.DataSourceType.KSTREAM) {
            if (rightNode.getNodeOutputType() == DataSource.DataSourceType.KTABLE) {
                LogicalPlanner.verifyStreamTableJoin(joinInfo, rightNode);
            }
        } else {
            if (rightNode.getNodeOutputType() == DataSource.DataSourceType.KSTREAM) {
                throw new KsqlException(String.format("Invalid join order: table-stream joins are not supported; only stream-table joins. Got %s %s %s.", new Object[]{joinInfo.getLeftSource().getDataSource().getName().text(), joinType, joinInfo.getRightSource().getDataSource().getName().text()}));
            }
            if (LogicalPlanner.joinOnNonKeyAttribute(rightExpression, rightNode, joinInfo.getRightSource())) {
                throw new KsqlException(String.format("Invalid join condition: table-table joins require to join on the primary key of the right input table. Got %s = %s.", joinInfo.getFlippedLeftJoinExpression(), joinInfo.getFlippedRightJoinExpression()));
            }
            if (LogicalPlanner.joinOnNonKeyAttribute(leftExpression, leftNode, joinInfo.getLeftSource())) {
                return this.verifyForeignKeyJoin(joinInfo, leftNode, rightNode);
            }
            SqlType leftKeyType = ((Column)Iterables.getOnlyElement((Iterable)leftNode.getSchema().key())).type();
            SqlType rightKeyType = ((Column)Iterables.getOnlyElement((Iterable)rightNode.getSchema().key())).type();
            LogicalPlanner.verifyJoinConditionTypes(leftKeyType, rightKeyType, leftExpression, rightExpression, joinInfo.hasFlippedJoinCondition());
        }
        return Optional.empty();
    }

    private static void verifyStreamTableJoin(Analysis.JoinInfo joinInfo, PlanNode rightNode) {
        JoinNode.JoinType joinType = joinInfo.getType();
        Expression rightExpression = joinInfo.getRightJoinExpression();
        if (joinType.equals((Object)JoinNode.JoinType.OUTER)) {
            throw new KsqlException(String.format("Invalid join type: full-outer join not supported for stream-table join. Got %s %s %s.", new Object[]{joinInfo.getLeftSource().getDataSource().getName().text(), joinType, joinInfo.getRightSource().getDataSource().getName().text()}));
        }
        if (LogicalPlanner.joinOnNonKeyAttribute(rightExpression, rightNode, joinInfo.getRightSource())) {
            throw new KsqlException(String.format("Invalid join condition: stream-table joins require to join on the table's primary key. Got %s = %s.", joinInfo.getFlippedLeftJoinExpression(), joinInfo.getFlippedRightJoinExpression()));
        }
    }

    private Optional<Expression> verifyForeignKeyJoin(Analysis.JoinInfo joinInfo, PlanNode leftNode, PlanNode rightNode) {
        JoinNode.JoinType joinType = joinInfo.getType();
        Expression leftExpression = joinInfo.getLeftJoinExpression();
        Expression rightExpression = joinInfo.getRightJoinExpression();
        if (joinInfo.getType().equals((Object)JoinNode.JoinType.OUTER)) {
            throw new KsqlException(String.format("Invalid join type: full-outer join not supported for foreign-key table-table join. Got %s %s %s.", new Object[]{joinInfo.getLeftSource().getDataSource().getName().text(), joinType, joinInfo.getRightSource().getDataSource().getName().text()}));
        }
        if (!(leftNode instanceof DataSourceNode) || !(rightNode instanceof DataSourceNode)) {
            throw new KsqlException(String.format("Invalid join condition: foreign-key table-table joins are not supported as part of n-way joins. Got %s = %s.", joinInfo.getFlippedLeftJoinExpression(), joinInfo.getFlippedRightJoinExpression()));
        }
        CodeGenRunner codeGenRunner = new CodeGenRunner(leftNode.getSchema(), this.ksqlConfig, (FunctionRegistry)this.metaStore);
        VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> unqualifiedRewritter = new VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>>(Optional.empty()){

            public Optional<Expression> visitQualifiedColumnReference(QualifiedColumnReferenceExp node, ExpressionTreeRewriter.Context<Void> ctx) {
                return Optional.of(new UnqualifiedColumnReferenceExp(node.getColumnName()));
            }
        };
        Expression leftExpressionUnqualified = ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((VisitParentExpressionVisitor)unqualifiedRewritter).process(arg_0, arg_1), leftExpression);
        CompiledExpression expressionEvaluator = codeGenRunner.buildCodeGenFromParseTree(leftExpressionUnqualified, "Left Join Expression");
        SqlType fkType = expressionEvaluator.getExpressionType();
        SqlType rightKeyType = ((Column)Iterables.getOnlyElement((Iterable)rightNode.getSchema().key())).type();
        LogicalPlanner.verifyJoinConditionTypes(fkType, rightKeyType, leftExpression, rightExpression, joinInfo.hasFlippedJoinCondition());
        if (((DataSourceNode)rightNode).isWindowed()) {
            throw new KsqlException("Foreign-key table-table joins are not supported on windowed tables.");
        }
        return Optional.of(leftExpression);
    }

    private static boolean joinOnNonKeyAttribute(Expression joinExpression, PlanNode node, Analysis.AliasedDataSource aliasedDataSource) {
        List keyColumns;
        if (!(joinExpression instanceof ColumnReferenceExp)) {
            return true;
        }
        ColumnReferenceExp simpleJoinExpression = (ColumnReferenceExp)joinExpression;
        ColumnName joinAttributeName = simpleJoinExpression.getColumnName();
        List dataSourceNodes = node.getSourceNodes().collect(Collectors.toList());
        if (LogicalPlanner.isInnerNode(node)) {
            DataSourceNode qualifiedNode;
            if (simpleJoinExpression.maybeQualifier().isPresent()) {
                SourceName qualifierOrAlias = (SourceName)simpleJoinExpression.maybeQualifier().get();
                SourceName qualifier = aliasedDataSource.getAlias().equals((Object)qualifierOrAlias) ? aliasedDataSource.getDataSource().getName() : qualifierOrAlias;
                List allNodes = dataSourceNodes.stream().filter(n -> n.getDataSource().getName().equals((Object)qualifier)).collect(Collectors.toList());
                if (allNodes.size() != 1) {
                    throw new KsqlException(String.format("Join qualifier '%s' could not be resolved (either not found or not unique).", qualifier));
                }
                qualifiedNode = (DataSourceNode)Iterables.getOnlyElement(allNodes);
            } else {
                List allNodes = dataSourceNodes.stream().filter(n -> n.getSchema().findColumn(simpleJoinExpression.getColumnName()).isPresent()).collect(Collectors.toList());
                if (allNodes.size() != 1) {
                    throw new KsqlException(String.format("Join identifier '%s' could not be resolved (either not found or not unique).", joinAttributeName));
                }
                qualifiedNode = (DataSourceNode)Iterables.getOnlyElement(allNodes);
            }
            keyColumns = qualifiedNode.getSchema().key();
        } else {
            keyColumns = ((DataSourceNode)Iterables.getOnlyElement(dataSourceNodes)).getSchema().key();
        }
        if (keyColumns.size() > 1) {
            return true;
        }
        return !joinAttributeName.equals((Object)((Column)Iterables.getOnlyElement((Iterable)keyColumns)).name());
    }

    private static boolean isInnerNode(PlanNode node) {
        if (node instanceof JoinNode) {
            return true;
        }
        if (node instanceof DataSourceNode) {
            return false;
        }
        if (node instanceof SingleSourcePlanNode) {
            return LogicalPlanner.isInnerNode(((SingleSourcePlanNode)node).getSource());
        }
        throw new IllegalStateException("Unknown node type: " + node.getClass().getName());
    }

    private JoinNode.JoinKey buildForeignJoinKey(JoinTree.Join join, Expression foreignKeyExpression) {
        Analysis.AliasedDataSource leftSource = join.getInfo().getLeftSource();
        SourceName alias = leftSource.getAlias();
        List<QualifiedColumnReferenceExp> leftSourceKeys = leftSource.getDataSource().getSchema().key().stream().map(c -> new QualifiedColumnReferenceExp(alias, c.name())).collect(Collectors.toList());
        VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> aliasRewritter = new VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>>(Optional.empty()){

            public Optional<Expression> visitQualifiedColumnReference(QualifiedColumnReferenceExp node, ExpressionTreeRewriter.Context<Void> ctx) {
                return Optional.of(new UnqualifiedColumnReferenceExp(ColumnNames.generatedJoinColumnAlias((SourceName)node.getQualifier(), (ColumnName)node.getColumnName())));
            }
        };
        Expression aliasedForeignKeyExpression = ExpressionTreeRewriter.rewriteWith((arg_0, arg_1) -> ((VisitParentExpressionVisitor)aliasRewritter).process(arg_0, arg_1), foreignKeyExpression);
        return JoinNode.JoinKey.foreignKey(aliasedForeignKeyExpression, leftSourceKeys);
    }

    private static void verifyJoinConditionTypes(SqlType leftType, SqlType rightType, Expression leftExpression, Expression rightExpression, boolean flipped) {
        if (!leftType.equals(rightType)) {
            throw new KsqlException(String.format("Invalid join condition: types don't match. Got %s{%s} = %s{%s}.", flipped ? rightExpression : leftExpression, flipped ? rightType : leftType, flipped ? leftExpression : rightExpression, flipped ? leftType : rightType));
        }
    }

    private JoinNode.JoinKey buildJoinKey(JoinTree.Join join) {
        List<QualifiedColumnReferenceExp> viableKeyColumns = join.viableKeyColumns();
        if (viableKeyColumns.isEmpty()) {
            return JoinNode.JoinKey.syntheticColumn();
        }
        Projection projection = Projection.of(this.analysis.original().getSelectItems());
        List availableKeyColumns = viableKeyColumns.stream().filter(projection::containsExpression).collect(Collectors.toList());
        QualifiedColumnReferenceExp keyColumn = availableKeyColumns.isEmpty() ? viableKeyColumns.get(0) : (QualifiedColumnReferenceExp)availableKeyColumns.get(0);
        ColumnName keyColumnName = ColumnNames.generatedJoinColumnAlias((SourceName)keyColumn.getQualifier(), (ColumnName)keyColumn.getColumnName());
        return JoinNode.JoinKey.sourceColumn(keyColumnName, viableKeyColumns);
    }

    private static DataSourceNode buildNonJoinNode(Analysis.AliasedDataSource dataSource, boolean isWindowed, KsqlConfig ksqlConfig) {
        return new DataSourceNode(new PlanNodeId("KsqlTopic"), dataSource.getDataSource(), dataSource.getAlias(), isWindowed);
    }

    private LogicalSchema buildAggregateSchema(PlanNode sourcePlanNode, GroupBy groupBy, List<SelectExpression> projectionExpressions) {
        List valueColumns;
        LogicalSchema sourceSchema = sourcePlanNode.getSchema();
        LogicalSchema projectionSchema = SelectionUtil.buildProjectionSchema(sourceSchema.withPseudoAndKeyColsInValue(this.analysis.getWindowExpression().isPresent()), projectionExpressions, (FunctionRegistry)this.metaStore);
        List groupByExps = groupBy.getGroupingExpressions();
        Function<Expression, Optional> selectResolver = expression -> {
            List foundInProjection = projectionExpressions.stream().filter(e -> e.getExpression().equals(expression)).map(SelectExpression::getAlias).collect(Collectors.toList());
            switch (foundInProjection.size()) {
                case 0: {
                    return Optional.empty();
                }
                case 1: {
                    return Optional.of((ColumnName)foundInProjection.get(0));
                }
            }
            String keys = GrammaticalJoiner.and().join(foundInProjection);
            throw new KsqlException("The projection contains a key column more than once: " + keys + "." + System.lineSeparator() + "Each key column must only be in the projection once. If you intended to copy the key into the value, then consider using the " + String.valueOf(AsValue.NAME) + " function to indicate which key reference should be copied.");
        };
        if (this.analysis.getInto().isPresent()) {
            Set keyColumnNames = groupBy.getGroupingExpressions().stream().map(selectResolver).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            valueColumns = projectionSchema.value().stream().filter(col -> !keyColumnNames.contains(col.name())).collect(Collectors.toList());
            if (valueColumns.isEmpty()) {
                throw new KsqlException("The projection contains no value columns.");
            }
        } else {
            valueColumns = projectionSchema.columns();
        }
        LogicalSchema.Builder builder = LogicalSchema.builder();
        ExpressionTypeManager typeManager = new ExpressionTypeManager(sourceSchema, (FunctionRegistry)this.metaStore);
        for (Expression expression2 : groupByExps) {
            SqlType keyType = typeManager.getExpressionSqlType(expression2);
            ColumnName keyName = selectResolver.apply(expression2).orElseGet(() -> expression2 instanceof ColumnReferenceExp ? ((ColumnReferenceExp)expression2).getColumnName() : ColumnNames.uniqueAliasFor((Expression)expression2, (LogicalSchema[])new LogicalSchema[]{sourceSchema}));
            builder.keyColumn(keyName, keyType);
        }
        return builder.valueColumns((Iterable)valueColumns).build();
    }

    private LogicalSchema buildRepartitionedSchema(PlanNode sourceNode, List<Expression> partitionBys) {
        LogicalSchema sourceSchema = sourceNode.getSchema();
        return PartitionByParamsFactory.buildSchema((LogicalSchema)sourceSchema, partitionBys, (FunctionRegistry)this.metaStore);
    }

    private boolean shouldRepartitionFKJoin(PlanNode sourceNode, JoinSide side) {
        if (!(sourceNode instanceof DataSourceNode)) {
            return false;
        }
        DataSourceNode dataSourceNode = (DataSourceNode)sourceNode;
        String dataSourceKeyFormat = dataSourceNode.getDataSource().getKsqlTopic().getKeyFormat().getFormat();
        boolean isAvro = dataSourceKeyFormat.equals("AVRO");
        boolean isProtobuf = dataSourceKeyFormat.equals("PROTOBUF");
        boolean isJsonSR = dataSourceKeyFormat.equals("JSON_SR");
        boolean isSREnabledFormat = isAvro || isProtobuf || isJsonSR;
        boolean hasStructInPrimaryKey = dataSourceNode.getSchema().key().stream().anyMatch(col -> col.type() instanceof SqlStruct);
        return side == JoinSide.RIGHT && isSREnabledFormat && hasStructInPrimaryKey;
    }

    private static final class ColumnReferenceRewriter
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
        private final boolean isJoin;

        ColumnReferenceRewriter(boolean isJoin) {
            super(Optional.empty());
            this.isJoin = isJoin;
        }

        public Optional<Expression> visitQualifiedColumnReference(QualifiedColumnReferenceExp node, ExpressionTreeRewriter.Context<Void> ctx) {
            if (this.isJoin) {
                return Optional.of(new UnqualifiedColumnReferenceExp(node.getLocation(), ColumnNames.generatedJoinColumnAlias((SourceName)node.getQualifier(), (ColumnName)node.getColumnName())));
            }
            return Optional.of(new UnqualifiedColumnReferenceExp(node.getLocation(), node.getColumnName()));
        }
    }

    private static final class RewrittenAggregateAnalysis
    implements AggregateAnalysisResult {
        private final AggregateAnalysisResult original;
        private final BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> rewriter;

        private RewrittenAggregateAnalysis(AggregateAnalysisResult original, BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> rewriter) {
            this.original = Objects.requireNonNull(original, "original");
            this.rewriter = Objects.requireNonNull(rewriter, "rewriter");
        }

        @Override
        public List<Expression> getAggregateFunctionArguments() {
            return this.rewriteList(this.original.getAggregateFunctionArguments());
        }

        @Override
        public List<ColumnReferenceExp> getRequiredColumns() {
            return this.rewriteList(this.original.getRequiredColumns());
        }

        @Override
        public List<FunctionCall> getAggregateFunctions() {
            return this.rewriteList(this.original.getAggregateFunctions());
        }

        @Override
        public List<Expression> getFinalSelectExpressions() {
            return this.original.getFinalSelectExpressions().stream().map(this::rewriteFinalSelectExpression).collect(Collectors.toList());
        }

        @Override
        public Optional<Expression> getHavingExpression() {
            return this.rewriteOptional(this.original.getHavingExpression());
        }

        private Expression rewriteFinalSelectExpression(Expression expression) {
            ColumnName columnName;
            if (expression instanceof UnqualifiedColumnReferenceExp && ColumnNames.isAggregate((ColumnName)(columnName = ((UnqualifiedColumnReferenceExp)expression).getColumnName()))) {
                return expression;
            }
            return ExpressionTreeRewriter.rewriteWith(this.rewriter, expression);
        }

        private <T extends Expression> Optional<T> rewriteOptional(Optional<T> expression) {
            return expression.map(e -> ExpressionTreeRewriter.rewriteWith(this.rewriter, e));
        }

        private <T extends Expression> List<T> rewriteList(List<T> expressions) {
            return expressions.stream().map(e -> ExpressionTreeRewriter.rewriteWith(this.rewriter, e)).collect(Collectors.toList());
        }
    }

    static enum JoinSide {
        LEFT,
        RIGHT;


        public String toString() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

