/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.JoinNode;
import io.confluent.ksql.planner.plan.JoiningNode;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.util.Repartitioning;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PreJoinRepartitionNode
extends SingleSourcePlanNode
implements JoiningNode {
    private final Expression partitionBy;
    private final LogicalSchema schema;
    private final Optional<JoinNode> joiningNode;
    private final ValueFormat valueFormat;
    private Optional<KeyFormat> forcedInternalKeyFormat = Optional.empty();
    private boolean forceRepartition = false;
    private boolean keyFormatSet = false;

    public PreJoinRepartitionNode(PlanNodeId id, PlanNode source, LogicalSchema schema, Expression partitionBy) {
        super(id, source.getNodeOutputType(), source.getSourceName(), source);
        this.schema = Objects.requireNonNull(schema, "schema");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy");
        if (source instanceof JoiningNode) {
            if (!(source instanceof JoinNode)) {
                throw new IllegalStateException("PreJoinRepartitionNode preceded by non-JoinNode JoiningNode: " + String.valueOf(source.getClass()));
            }
            this.joiningNode = Optional.of((JoinNode)source);
        } else {
            this.joiningNode = Optional.empty();
        }
        this.valueFormat = JoiningNode.getValueFormatForSource(this);
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    public Optional<KeyFormat> getPreferredKeyFormat() {
        if (this.requiresRepartition()) {
            return Optional.empty();
        }
        if (this.joiningNode.isPresent()) {
            return this.joiningNode.get().getPreferredKeyFormat();
        }
        return Optional.of(this.getSourceKeyFormat());
    }

    @Override
    public void setKeyFormat(KeyFormat format) {
        Optional<KeyFormat> requiredParentJoinFormat = this.maybeForceInternalKeyFormat(format);
        if (this.joiningNode.isPresent()) {
            if (requiredParentJoinFormat.isPresent()) {
                this.joiningNode.get().setKeyFormat(requiredParentJoinFormat.get());
            } else {
                this.joiningNode.get().resolveKeyFormats();
            }
        }
        this.keyFormatSet = true;
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        if (!this.keyFormatSet) {
            throw new IllegalStateException("PreJoinRepartitionNode must set key format");
        }
        return this.getSource().buildStream(buildContext).selectKey(this.valueFormat.getFormatInfo(), (List<Expression>)ImmutableList.of((Object)this.partitionBy), this.forcedInternalKeyFormat, buildContext.buildNodeContext(this.getId().toString()), this.forceRepartition);
    }

    private boolean requiresRepartition() {
        return Repartitioning.repartitionNeeded(this.getSource().getSchema(), (List<Expression>)ImmutableList.of((Object)this.partitionBy));
    }

    private KeyFormat getSourceKeyFormat() {
        return ((DataSourceNode)Iterators.getOnlyElement(this.getSourceNodes().iterator())).getDataSource().getKsqlTopic().getKeyFormat();
    }

    private Optional<KeyFormat> maybeForceInternalKeyFormat(KeyFormat format) {
        if (FormatFactory.of((FormatInfo)format.getFormatInfo()).supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
            this.forceRepartition = true;
        }
        if (this.requiresRepartition() || this.forceRepartition) {
            this.forcedInternalKeyFormat = Optional.of(format);
            return Optional.empty();
        }
        if (this.joiningNode.isPresent()) {
            Optional<KeyFormat> preferred = this.joiningNode.get().getPreferredKeyFormat();
            if (!preferred.isPresent() || preferred.get().equals((Object)format)) {
                return Optional.of(format);
            }
            this.forcedInternalKeyFormat = Optional.of(format);
            return Optional.empty();
        }
        if (!format.equals((Object)this.getSourceKeyFormat())) {
            this.forcedInternalKeyFormat = Optional.of(format);
        }
        return Optional.empty();
    }
}

