/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.planner.plan.VerifiableNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.structured.SchemaKTable;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;

public class SuppressNode
extends SingleSourcePlanNode
implements VerifiableNode {
    private final RefinementInfo refinementInfo;
    private final ValueFormat valueFormat;

    public SuppressNode(PlanNodeId id, PlanNode source, RefinementInfo refinementInfo) {
        super(id, source.getNodeOutputType(), source.getSourceName(), source);
        this.refinementInfo = Objects.requireNonNull(refinementInfo, "refinementInfo");
        this.valueFormat = source.getLeftmostSourceNode().getDataSource().getKsqlTopic().getValueFormat();
    }

    public RefinementInfo getRefinementInfo() {
        return this.refinementInfo;
    }

    @Override
    public LogicalSchema getSchema() {
        return this.getSource().getSchema();
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        QueryContext.Stacker contextStacker = buildContext.buildNodeContext(this.getId().toString());
        SchemaKStream<?> schemaKStream = this.getSource().buildStream(buildContext);
        if (!(schemaKStream instanceof SchemaKTable)) {
            throw new KsqlException("Failed in suppress node. Expected to find a Table, but found a stream instead.");
        }
        return ((SchemaKTable)schemaKStream).suppress(this.refinementInfo, this.valueFormat.getFormatInfo(), contextStacker);
    }

    @Override
    public void validateKeyPresent(SourceName sinkName) {
        if (!(this.getSource() instanceof VerifiableNode)) {
            throw new IllegalStateException("VerifiableNode required");
        }
        ((VerifiableNode)((Object)this.getSource())).validateKeyPresent(sinkName);
    }
}

