/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.execution.ExecutionPlan;
import io.confluent.ksql.query.QueryValidator;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaStreamsQueryValidator
implements QueryValidator {
    private static final Logger LOG = LogManager.getLogger(KafkaStreamsQueryValidator.class);

    @Override
    public void validateQuery(SessionConfig config, ExecutionPlan executionPlan, Collection<QueryMetadata> runningQueries) {
        this.validateCacheBytesUsage(runningQueries.stream().filter(q -> q instanceof PersistentQueryMetadata).collect(Collectors.toList()), config, config.getConfig(false).getLong("ksql.query.persistent.max.bytes.buffering.total"));
    }

    @Override
    public void validateTransientQuery(SessionConfig config, ExecutionPlan executionPlan, Collection<QueryMetadata> runningQueries) {
        this.validateCacheBytesUsage(runningQueries.stream().filter(q -> q instanceof TransientQueryMetadata).collect(Collectors.toList()), config, config.getConfig(false).getLong("ksql.query.transient.max.bytes.buffering.total"));
    }

    private void validateCacheBytesUsage(Collection<QueryMetadata> running, SessionConfig config, long limit) {
        long usedByRunning;
        if (limit < 0L) {
            return;
        }
        long configured = this.getCacheMaxBytesBuffering(config);
        if (!config.getConfig(true).getBoolean("ksql.runtime.feature.shared.enabled").booleanValue()) {
            usedByRunning = running.stream().mapToLong(r -> new StreamsConfig(r.getStreamsProperties()).getLong("cache.max.bytes.buffering")).sum();
        } else {
            usedByRunning = running.stream().filter(t -> !(t instanceof BinPackedPersistentQueryMetadataImpl)).mapToLong(r -> new StreamsConfig(r.getStreamsProperties()).getLong("cache.max.bytes.buffering")).sum();
            HashSet<String> runtimes = new HashSet<String>();
            long cacheSizeBytesPerRuntime = -1L;
            for (QueryMetadata queryMetadata : running) {
                if (!(queryMetadata instanceof BinPackedPersistentQueryMetadataImpl)) continue;
                if (cacheSizeBytesPerRuntime == -1L) {
                    cacheSizeBytesPerRuntime = (Long)queryMetadata.getStreamsProperties().get("cache.max.bytes.buffering");
                }
                if (!runtimes.contains(queryMetadata.getQueryApplicationId())) {
                    runtimes.add(queryMetadata.getQueryApplicationId());
                    usedByRunning += ((Long)queryMetadata.getStreamsProperties().get("cache.max.bytes.buffering")).longValue();
                    continue;
                }
                if (cacheSizeBytesPerRuntime != (Long)queryMetadata.getStreamsProperties().get("cache.max.bytes.buffering")) continue;
                LOG.warn("Inconsistent cache.max.bytes.buffering in shared runtimes {} and {}", (Object)cacheSizeBytesPerRuntime, queryMetadata.getStreamsProperties().get("cache.max.bytes.buffering"));
            }
        }
        if (configured + usedByRunning > limit) {
            throw new KsqlException(String.format("Configured cache usage (cache.max.bytes.buffering=%d) would put usage over the configured limit (%d). Current usage is %d", configured, limit, usedByRunning));
        }
    }

    private long getCacheMaxBytesBuffering(SessionConfig config) {
        return this.getDummyStreamsConfig(config).getLong("cache.max.bytes.buffering");
    }

    private StreamsConfig getDummyStreamsConfig(SessionConfig config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("application.id", "dummy.app.id");
        properties.put("bootstrap.servers", "dummy.bootstrap");
        properties.putAll(config.getConfig(true).getKsqlStreamConfigProps());
        return new StreamsConfig(properties);
    }
}

