/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Monitor;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.pull.PullQueryRow;
import io.confluent.ksql.execution.pull.StreamedRowTranslator;
import io.confluent.ksql.query.BlockingRowQueue;
import io.confluent.ksql.query.CompletionHandler;
import io.confluent.ksql.query.LimitHandler;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.KeyValueMetadata;
import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.RowMetadata;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.streams.WriteStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public class PullQueryWriteStream
implements WriteStream<List<StreamedRow>>,
BlockingRowQueue {
    private static final int DEFAULT_SOFT_CAPACITY = 50;
    private final OptionalInt queryLimit;
    private final StreamedRowTranslator translator;
    private final Monitor monitor = new Monitor();
    @GuardedBy(value="monitor")
    private final Queue<HandledRow> queue = new ArrayDeque<HandledRow>();
    @GuardedBy(value="monitor")
    private int totalRowsQueued = 0;
    @GuardedBy(value="monitor")
    private boolean closed = false;
    @GuardedBy(value="monitor")
    private int queueCapacity = 50;
    private final Monitor.Guard hasData = this.monitor.newGuard(() -> !this.isEmpty());
    private final Monitor.Guard atHalfCapacity = this.monitor.newGuard(() -> this.isDone() || this.size() <= this.queueCapacity / 2);
    private final ConcurrentHashSet<Handler<Void>> drainHandler = new ConcurrentHashSet();
    private CompletionHandler endHandler = () -> {};
    private Handler<AsyncResult<Void>> limitHandler = ar -> {};
    private Runnable queueCallback = () -> {};

    public PullQueryWriteStream(OptionalInt queryLimit, StreamedRowTranslator translator) {
        this.queryLimit = queryLimit;
        this.translator = translator;
    }

    @Override
    public void drainTo(Collection<? super KeyValueMetadata<List<?>, GenericRow>> collection) {
        this.monitor.enter();
        try {
            while (!this.queue.isEmpty()) {
                collection.add(this.poll());
            }
        }
        finally {
            this.monitor.leave();
        }
    }

    public void drainRowsTo(Collection<PullQueryRow> collection) {
        this.monitor.enter();
        try {
            while (!this.queue.isEmpty()) {
                collection.add(this.pollRow());
            }
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueMetadata<List<?>, GenericRow> poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.monitor.enterWhen(this.hasData, timeout, unit)) {
            try {
                KeyValueMetadata<List<?>, GenericRow> keyValueMetadata = this.poll();
                return keyValueMetadata;
            }
            finally {
                this.monitor.leave();
            }
        }
        return null;
    }

    @Override
    public KeyValueMetadata<List<?>, GenericRow> poll() {
        PullQueryRow row = this.pollRow();
        if (row == null) {
            return null;
        }
        if (row.getConsistencyOffsetVector().isPresent()) {
            return new KeyValueMetadata(RowMetadata.of((ConsistencyOffsetVector)row.getConsistencyOffsetVector().get()));
        }
        return new KeyValueMetadata(KeyValue.keyValue(null, (Object)row.getGenericRow()), row.getSourceNode().map(sn -> new KsqlHostInfo(sn.getHost(), sn.getPort())).map(RowMetadata::of));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PullQueryRow pollRow(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.monitor.enterWhen(this.hasData, timeout, unit)) {
            try {
                PullQueryRow pullQueryRow = this.pollRow();
                return pullQueryRow;
            }
            finally {
                this.monitor.leave();
            }
        }
        return null;
    }

    private PullQueryRow pollRow() {
        HandledRow polled;
        this.monitor.enter();
        try {
            polled = this.queue.poll();
        }
        finally {
            this.monitor.leave();
        }
        if (polled == null) {
            return null;
        }
        polled.handler.handle((Object)new SucceededFuture(null, null));
        if (this.monitor.enterIf(this.atHalfCapacity)) {
            try {
                this.drainHandler.forEach(h -> h.handle(null));
                this.drainHandler.clear();
            }
            finally {
                this.monitor.leave();
            }
        }
        return polled.row;
    }

    public int getTotalRowsQueued() {
        this.monitor.enter();
        try {
            int n = this.totalRowsQueued;
            return n;
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    public int size() {
        this.monitor.enter();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isDone() {
        this.monitor.enter();
        try {
            boolean bl = this.closed || this.hardLimitHit();
            return bl;
        }
        finally {
            this.monitor.leave();
        }
    }

    private boolean hardLimitHit() {
        this.monitor.enter();
        try {
            boolean bl = this.queryLimit.isPresent() && this.totalRowsQueued >= this.queryLimit.getAsInt();
            return bl;
        }
        finally {
            this.monitor.leave();
        }
    }

    public PullQueryWriteStream exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    public PullQueryWriteStream drainHandler(Handler<Void> handler) {
        Context context = Vertx.currentContext();
        this.drainHandler.add(v -> context.runOnContext(handler));
        return this;
    }

    @Override
    public void setCompletionHandler(CompletionHandler handler) {
        this.endHandler = handler;
    }

    @Override
    public void setLimitHandler(LimitHandler handler) {
        this.limitHandler = ar -> handler.limitReached();
    }

    @Override
    public void setQueuedCallback(Runnable callback) {
        Runnable parent = this.queueCallback;
        this.queueCallback = () -> {
            parent.run();
            callback.run();
        };
    }

    public void putConsistencyVector(ConsistencyOffsetVector offsetVector) {
        this.write((List<StreamedRow>)ImmutableList.of((Object)StreamedRow.consistencyToken((ConsistencyToken)new ConsistencyToken(offsetVector.serialize()))));
    }

    public Future<Void> write(List<StreamedRow> data) {
        Promise promise = Promise.promise();
        this.write(data, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<StreamedRow> data, Handler<AsyncResult<Void>> handler) {
        this.monitor.enter();
        try {
            if (this.isDone()) {
                return;
            }
            for (PullQueryRow row : this.translator.apply(data)) {
                if (!this.queue.offer(new HandledRow(row, handler))) continue;
                ++this.totalRowsQueued;
                this.queueCallback.run();
                if (!this.hardLimitHit()) continue;
                this.end(this.limitHandler);
                break;
            }
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    public void close() {
        this.end();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.monitor.enter();
        try {
            this.closed = true;
        }
        finally {
            this.monitor.leave();
        }
        this.endHandler.complete();
        handler.handle((Object)new SucceededFuture(null, null));
    }

    public PullQueryWriteStream setWriteQueueMaxSize(int maxSize) {
        this.monitor.enter();
        try {
            this.queueCapacity = maxSize;
        }
        finally {
            this.monitor.leave();
        }
        return this;
    }

    public boolean writeQueueFull() {
        this.monitor.enter();
        try {
            boolean bl = this.isDone() || this.queue.size() >= this.queueCapacity;
            return bl;
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitCapacity(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.writeQueueFull()) {
            return true;
        }
        if (this.monitor.enterWhen(this.atHalfCapacity, timeout, timeUnit)) {
            try {
                boolean bl = !this.writeQueueFull();
                return bl;
            }
            finally {
                this.monitor.leave();
            }
        }
        return false;
    }

    private static final class HandledRow {
        private final PullQueryRow row;
        private final Handler<AsyncResult<Void>> handler;

        private HandledRow(PullQueryRow row, Handler<AsyncResult<Void>> handler) {
            this.row = row;
            this.handler = handler;
        }
    }
}

