/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.inference;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.ksql.schema.ksql.inference.TopicSchemaSupplier;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SchemaTranslationPolicies;
import io.confluent.ksql.serde.SchemaTranslationPolicy;
import io.confluent.ksql.serde.SchemaTranslator;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class SchemaRegistryTopicSchemaSupplier
implements TopicSchemaSupplier {
    private final SchemaRegistryClient srClient;
    private final Function<FormatInfo, Format> formatFactory;

    public SchemaRegistryTopicSchemaSupplier(SchemaRegistryClient srClient) {
        this(srClient, FormatFactory::of);
    }

    @VisibleForTesting
    SchemaRegistryTopicSchemaSupplier(SchemaRegistryClient srClient, Function<FormatInfo, Format> formatFactory) {
        this.srClient = Objects.requireNonNull(srClient, "srClient");
        this.formatFactory = Objects.requireNonNull(formatFactory, "formatFactory");
    }

    @Override
    public TopicSchemaSupplier.SchemaResult getKeySchema(Optional<String> topicName, Optional<Integer> schemaId, FormatInfo expectedFormat, SerdeFeatures serdeFeatures) {
        return this.getSchema(topicName, schemaId, expectedFormat, serdeFeatures, true);
    }

    @Override
    public TopicSchemaSupplier.SchemaResult getValueSchema(Optional<String> topicName, Optional<Integer> schemaId, FormatInfo expectedFormat, SerdeFeatures serdeFeatures) {
        return this.getSchema(topicName, schemaId, expectedFormat, serdeFeatures, false);
    }

    public TopicSchemaSupplier.SchemaResult getSchema(Optional<String> topicName, Optional<Integer> schemaId, FormatInfo expectedFormat, SerdeFeatures serdeFeatures, boolean isKey) {
        if (!topicName.isPresent() && !schemaId.isPresent()) {
            throw new IllegalArgumentException("One of topicName and schemaId should be provided");
        }
        try {
            int id;
            String subject;
            if (schemaId.isPresent()) {
                subject = topicName.map(s -> KsqlConstants.getSRSubject((String)s, (boolean)isKey)).orElse(null);
                id = schemaId.get();
            } else {
                subject = KsqlConstants.getSRSubject((String)topicName.get(), (boolean)isKey);
                id = this.srClient.getLatestSchemaMetadata(subject).getId();
            }
            ParsedSchema schema = this.srClient.getSchemaBySubjectAndId(subject, id);
            return this.fromParsedSchema(topicName, id, schemaId, schema, expectedFormat, serdeFeatures, isKey);
        }
        catch (RestClientException e) {
            switch (e.getStatus()) {
                case 401: 
                case 403: 
                case 404: {
                    return SchemaRegistryTopicSchemaSupplier.notFound(topicName, schemaId, isKey);
                }
            }
            throw new KsqlException(SchemaRegistryTopicSchemaSupplier.fetchExceptionMessage(topicName, schemaId, isKey), (Throwable)e);
        }
        catch (Exception e) {
            throw new KsqlException(SchemaRegistryTopicSchemaSupplier.fetchExceptionMessage(topicName, schemaId, isKey), (Throwable)e);
        }
    }

    private TopicSchemaSupplier.SchemaResult fromParsedSchema(Optional<String> topic, int id, Optional<Integer> schemaId, ParsedSchema parsedSchema, FormatInfo expectedFormat, SerdeFeatures serdeFeatures, boolean isKey) {
        List columns;
        SchemaTranslator translator;
        Format format = this.formatFactory.apply(expectedFormat);
        SchemaTranslator schemaTranslator = translator = schemaId.isPresent() ? format.getSchemaTranslator(expectedFormat.getProperties(), SchemaTranslationPolicies.of((SchemaTranslationPolicy[])new SchemaTranslationPolicy[]{SchemaTranslationPolicy.ORIGINAL_FIELD_NAME})) : format.getSchemaTranslator(expectedFormat.getProperties());
        if (!parsedSchema.schemaType().equals(translator.name())) {
            return SchemaRegistryTopicSchemaSupplier.incorrectFormat(topic, schemaId, translator.name(), parsedSchema.schemaType(), isKey);
        }
        try {
            columns = translator.toColumns(parsedSchema, serdeFeatures, isKey);
        }
        catch (Exception e) {
            return SchemaRegistryTopicSchemaSupplier.notCompatible(topic, schemaId, parsedSchema.canonicalString(), e, isKey);
        }
        if (isKey && columns.size() > 1) {
            return SchemaRegistryTopicSchemaSupplier.multiColumnKeysNotSupported(topic, schemaId, parsedSchema.canonicalString());
        }
        return TopicSchemaSupplier.SchemaResult.success(TopicSchemaSupplier.SchemaAndId.schemaAndId(columns, parsedSchema, id));
    }

    private static TopicSchemaSupplier.SchemaResult incorrectFormat(Optional<String> topic, Optional<Integer> schemaId, String expectedFormat, String actualFormat, boolean isKey) {
        String config = isKey ? "KEY_FORMAT" : "VALUE_FORMAT";
        return TopicSchemaSupplier.SchemaResult.failure((Exception)((Object)new KsqlException((isKey ? "Key" : "Value") + " schema is not in the expected format. You may want to set " + config + " to '" + actualFormat + "'." + System.lineSeparator() + SchemaRegistryTopicSchemaSupplier.sourceMsg(topic, schemaId) + System.lineSeparator() + "expected format: " + expectedFormat + System.lineSeparator() + "actual format from Schema Registry: " + actualFormat)));
    }

    private static TopicSchemaSupplier.SchemaResult notFound(Optional<String> topicName, Optional<Integer> schemaId, boolean isKey) {
        String suffixMsg = "- Messages on the topic have not been serialized using a Confluent Schema Registry supported serializer" + System.lineSeparator() + "\t-> See https://docs.confluent.io/current/schema-registry/docs/serializer-formatter.html" + System.lineSeparator() + "- The schema is registered on a different instance of the Schema Registry" + System.lineSeparator() + "\t-> Use the REST API to list available subjects\thttps://docs.confluent.io/current/schema-registry/docs/api.html#get--subjects" + System.lineSeparator() + "- You do not have permissions to access the Schema Registry." + System.lineSeparator() + "\t-> See https://docs.confluent.io/current/schema-registry/docs/security.html";
        String schemaIdMsg = schemaId.map(integer -> "Schema Id: " + integer + System.lineSeparator()).orElse("");
        if (topicName.isPresent()) {
            String subject = KsqlConstants.getSRSubject((String)topicName.get(), (boolean)isKey);
            return TopicSchemaSupplier.SchemaResult.failure((Exception)((Object)new KsqlException("Schema for message " + (isKey ? "keys" : "values") + " on topic '" + topicName.get() + "' does not exist in the Schema Registry." + System.lineSeparator() + "Subject: " + subject + System.lineSeparator() + schemaIdMsg + "Possible causes include:" + System.lineSeparator() + "- The topic itself does not exist" + System.lineSeparator() + "\t-> Use SHOW TOPICS; to check" + System.lineSeparator() + "- Messages on the topic are not serialized using a format Schema Registry supports" + System.lineSeparator() + "\t-> Use PRINT '" + topicName.get() + "' FROM BEGINNING; to verify" + System.lineSeparator() + suffixMsg)));
        }
        return TopicSchemaSupplier.SchemaResult.failure((Exception)((Object)new KsqlException("Schema for message " + (isKey ? "keys" : "values") + " on schema id'" + String.valueOf(schemaId.get()) + " does not exist in the Schema Registry." + System.lineSeparator() + schemaIdMsg + "Possible causes include:" + System.lineSeparator() + "- Schema Id " + String.valueOf(schemaId) + System.lineSeparator() + suffixMsg)));
    }

    private static TopicSchemaSupplier.SchemaResult notCompatible(Optional<String> topicName, Optional<Integer> schemaId, String schema, Exception cause, boolean isKey) {
        return TopicSchemaSupplier.SchemaResult.failure((Exception)((Object)new KsqlException("Unable to verify if the " + (isKey ? "key" : "value") + " schema for " + SchemaRegistryTopicSchemaSupplier.sourceMsg(topicName, schemaId) + " is compatible with ksqlDB." + System.lineSeparator() + "Reason: " + cause.getMessage() + System.lineSeparator() + System.lineSeparator() + "Please see https://github.com/confluentinc/ksql/issues/ to see if this particular reason is already known." + System.lineSeparator() + "If not, please log a new issue, including this full error message." + System.lineSeparator() + "Schema:" + schema, (Throwable)cause)));
    }

    private static TopicSchemaSupplier.SchemaResult multiColumnKeysNotSupported(Optional<String> topic, Optional<Integer> schemaId, String schema) {
        return TopicSchemaSupplier.SchemaResult.failure((Exception)((Object)new KsqlException("The key schema for " + SchemaRegistryTopicSchemaSupplier.sourceMsg(topic, schemaId) + " contains multiple columns, which is not supported by ksqlDB at this time." + System.lineSeparator() + "Schema:" + schema)));
    }

    private static String fetchExceptionMessage(Optional<String> topicName, Optional<Integer> schemaId, boolean isKey) {
        return "Schema registry fetch for topic " + (isKey ? "key" : "value") + " request failed for " + SchemaRegistryTopicSchemaSupplier.sourceMsg(topicName, schemaId);
    }

    private static String sourceMsg(Optional<String> topicName, Optional<Integer> schemaId) {
        Object msg = "";
        if (topicName.isPresent()) {
            msg = (String)msg + "topic: " + topicName.get();
        }
        if (schemaId.isPresent()) {
            msg = (String)msg + (((String)msg).isEmpty() ? "schema id: " + String.valueOf(schemaId.get()) : ", schema id: " + String.valueOf(schemaId.get()));
        }
        return msg;
    }
}

