/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.ksql.exception.KsqlTopicAuthorizationException;
import io.confluent.ksql.security.KsqlAccessValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.acl.AclOperation;

public class KsqlBackendAccessValidator
implements KsqlAccessValidator {
    @Override
    public void checkTopicAccess(KsqlSecurityContext securityContext, String topicName, AclOperation operation) {
        Set authorizedOperations = securityContext.getServiceContext().getTopicClient().describeTopic(topicName).authorizedOperations();
        if (authorizedOperations != null && !authorizedOperations.contains(operation)) {
            throw new KsqlTopicAuthorizationException(operation, Collections.singleton(topicName));
        }
    }

    @Override
    public void checkSubjectAccess(KsqlSecurityContext securityContext, String subjectName, AclOperation operation) {
    }
}

