/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.streams.KafkaClientSupplier;

public class ConfiguredKafkaClientSupplier
implements KafkaClientSupplier {
    private final KafkaClientSupplier defaultSupplier;
    private final ImmutableMap<String, Object> supplierProperties;

    public ConfiguredKafkaClientSupplier(KafkaClientSupplier defaultSupplier, Map<String, Object> supplierProperties) {
        this.defaultSupplier = Objects.requireNonNull(defaultSupplier, "defaultSupplier");
        this.supplierProperties = ImmutableMap.copyOf(Objects.requireNonNull(supplierProperties, "supplierProperties"));
    }

    public Map<String, Object> injectSupplierProperties(Map<String, Object> config) {
        HashMap<String, Object> newConfig = new HashMap<String, Object>(config);
        newConfig.putAll((Map<String, Object>)this.supplierProperties);
        return newConfig;
    }

    public Admin getAdmin(Map<String, Object> config) {
        return this.defaultSupplier.getAdmin(this.injectSupplierProperties(config));
    }

    public Producer<byte[], byte[]> getProducer(Map<String, Object> config) {
        return this.defaultSupplier.getProducer(this.injectSupplierProperties(config));
    }

    public Consumer<byte[], byte[]> getConsumer(Map<String, Object> config) {
        return this.defaultSupplier.getConsumer(this.injectSupplierProperties(config));
    }

    public Consumer<byte[], byte[]> getRestoreConsumer(Map<String, Object> config) {
        return this.defaultSupplier.getRestoreConsumer(this.injectSupplierProperties(config));
    }

    public Consumer<byte[], byte[]> getGlobalConsumer(Map<String, Object> config) {
        return this.defaultSupplier.getGlobalConsumer(this.injectSupplierProperties(config));
    }
}

