/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.rest.entity.ConfigInfos;
import io.confluent.ksql.rest.entity.ConnectorInfo;
import io.confluent.ksql.rest.entity.ConnectorStateInfo;
import io.confluent.ksql.rest.entity.SimpleConnectorPluginInfo;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.ConnectJsonMapper;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.QueryMask;
import io.vertx.core.http.HttpHeaders;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultConnectClient
implements ConnectClient {
    private static final Logger LOG = LogManager.getLogger(DefaultConnectClient.class);
    private static final ObjectMapper MAPPER = ConnectJsonMapper.INSTANCE.get();
    private static final String CONNECTOR_PLUGINS = "/connector-plugins";
    private static final String CONNECTORS = "/connectors";
    private static final String STATUS = "/status";
    private static final String TOPICS = "/topics";
    private static final String VALIDATE_CONNECTOR = "/connector-plugins/%s/config/validate";
    private static final int MAX_ATTEMPTS = 3;
    private final URI connectUri;
    private final Header[] requestHeaders;
    private final CloseableHttpClient httpClient;
    private final long requestTimeoutMs;

    public DefaultConnectClient(String connectUri, Optional<String> authHeader, Map<String, String> additionalRequestHeaders, Optional<SSLContext> sslContext, boolean verifySslHostname, long requestTimeoutMs) {
        Objects.requireNonNull(connectUri, "connectUri");
        Objects.requireNonNull(authHeader, "authHeader");
        Objects.requireNonNull(additionalRequestHeaders, "additionalRequestHeaders");
        Objects.requireNonNull(sslContext, "sslContext");
        try {
            this.connectUri = new URI(connectUri);
        }
        catch (URISyntaxException e) {
            throw new KsqlException("Could not initialize connect client due to invalid URI: " + connectUri, (Throwable)e);
        }
        this.requestHeaders = DefaultConnectClient.buildHeaders(authHeader, additionalRequestHeaders);
        this.httpClient = DefaultConnectClient.buildHttpClient(sslContext, verifySslHostname);
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public ConnectClient.ConnectResponse<ConnectorInfo> create(String connector, Map<String, String> config) {
        try {
            Map maskedConfig = QueryMask.getMaskedConnectConfig(config);
            LOG.debug("Issuing create request to Kafka Connect at URI {} with name {} and config {}", (Object)this.connectUri, (Object)connector, (Object)maskedConfig);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.post((String)this.resolveUri(CONNECTORS)).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).bodyString(MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)"name", (Object)connector, (Object)"config", (Object)config)), ContentType.APPLICATION_JSON).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler(201, new TypeReference<ConnectorInfo>(){}, Function.identity())));
            connectResponse.error().ifPresent(error -> LOG.warn("Did not CREATE connector {}: {}", (Object)connector, error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    public ConnectClient.ConnectResponse<ConfigInfos> validate(String plugin, Map<String, String> config) {
        try {
            Map maskedConfig = QueryMask.getMaskedConnectConfig(config);
            LOG.debug("Issuing validate request to Kafka Connect at URI {} for plugin {} and config {}", (Object)this.connectUri, (Object)plugin, (Object)maskedConfig);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.put((String)this.resolveUri(String.format(VALIDATE_CONNECTOR, plugin))).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).bodyString(MAPPER.writeValueAsString((Object)config), ContentType.APPLICATION_JSON).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler(200, new TypeReference<ConfigInfos>(){}, Function.identity())));
            connectResponse.error().ifPresent(error -> LOG.warn("Did not VALIDATE connector configuration for plugin {} and config {}: {}", (Object)plugin, (Object)maskedConfig, error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    public ConnectClient.ConnectResponse<List<String>> connectors() {
        try {
            LOG.debug("Issuing request to Kafka Connect at URI {} to list connectors", (Object)this.connectUri);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.get((String)this.resolveUri(CONNECTORS)).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler(200, new TypeReference<List<String>>(){}, Function.identity())));
            connectResponse.error().ifPresent(error -> LOG.warn("Could not list connectors: {}.", error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    public ConnectClient.ConnectResponse<List<SimpleConnectorPluginInfo>> connectorPlugins() {
        try {
            LOG.debug("Issuing request to Kafka Connect at URI {} to list connector plugins", (Object)this.connectUri);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.get((String)this.resolveUri(CONNECTOR_PLUGINS)).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler(200, new TypeReference<List<SimpleConnectorPluginInfo>>(){}, Function.identity())));
            connectResponse.error().ifPresent(error -> LOG.warn("Could not list connector plugins: {}.", error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    public ConnectClient.ConnectResponse<ConnectorStateInfo> status(String connector) {
        try {
            LOG.debug("Issuing status request to Kafka Connect at URI {} with name {}", (Object)this.connectUri, (Object)connector);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.get((String)this.resolveUri("/connectors/" + connector + STATUS)).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler(200, new TypeReference<ConnectorStateInfo>(){}, Function.identity())));
            connectResponse.error().ifPresent(error -> LOG.warn("Could not query status of connector {}: {}", (Object)connector, error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    public ConnectClient.ConnectResponse<ConnectorInfo> describe(String connector) {
        try {
            LOG.debug("Issuing request to Kafka Connect at URI {} to get config for {}", (Object)this.connectUri, (Object)connector);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.get((String)this.resolveUri(String.format("%s/%s", CONNECTORS, connector))).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler(200, new TypeReference<ConnectorInfo>(){}, Function.identity())));
            connectResponse.error().ifPresent(error -> LOG.warn("Could not list connectors: {}.", error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    public ConnectClient.ConnectResponse<String> delete(String connector) {
        try {
            LOG.debug("Issuing request to Kafka Connect at URI {} to delete {}", (Object)this.connectUri, (Object)connector);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.delete((String)this.resolveUri(String.format("%s/%s", CONNECTORS, connector))).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler((List<Integer>)ImmutableList.of((Object)204, (Object)200), new TypeReference<Object>(){}, (C foo) -> connector)));
            connectResponse.error().ifPresent(error -> LOG.warn("Could not delete connector: {}.", error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    public ConnectClient.ConnectResponse<Map<String, Map<String, List<String>>>> topics(String connector) {
        try {
            LOG.debug("Issuing request to Kafka Connect at URI {} to get active topics for {}", (Object)this.connectUri, (Object)connector);
            ConnectClient.ConnectResponse connectResponse = DefaultConnectClient.withRetries(() -> (ConnectClient.ConnectResponse)Request.get((String)this.resolveUri("/connectors/" + connector + TOPICS)).setHeaders(this.requestHeaders).responseTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).connectTimeout(Timeout.ofMilliseconds((long)this.requestTimeoutMs)).execute(this.httpClient).handleResponse(DefaultConnectClient.createHandler(200, new TypeReference<Map<String, Map<String, List<String>>>>(){}, Function.identity())));
            connectResponse.error().ifPresent(error -> LOG.warn("Could not query topics of connector {}: {}", (Object)connector, error));
            return connectResponse;
        }
        catch (Exception e) {
            throw new KsqlServerException((Throwable)e);
        }
    }

    @VisibleForTesting
    public Header[] getRequestHeaders() {
        return (Header[])this.requestHeaders.clone();
    }

    private String resolveUri(String relativePath) {
        try {
            return new URI(this.connectUri.getScheme(), this.connectUri.getUserInfo(), this.connectUri.getHost(), this.connectUri.getPort(), Paths.get(this.connectUri.getPath(), relativePath).toString(), this.connectUri.getQuery(), this.connectUri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw new KsqlServerException("Failed to resolve URI", (Throwable)e);
        }
    }

    private static Header[] buildHeaders(Optional<String> authHeader, Map<String, String> additionalRequestHeaders) {
        ArrayList headers = new ArrayList();
        authHeader.ifPresent(header -> headers.add(new BasicHeader(HttpHeaders.AUTHORIZATION.toString(), authHeader.get())));
        if (!additionalRequestHeaders.isEmpty()) {
            List additionalHeaders = additionalRequestHeaders.entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), e.getValue())).collect(Collectors.toList());
            headers.addAll(additionalHeaders);
        }
        return headers.toArray(new Header[0]);
    }

    private static CloseableHttpClient buildHttpClient(Optional<SSLContext> sslContext, boolean verifySslHostname) {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        sslContext.ifPresent(ctx -> {
            SSLConnectionSocketFactory socketFactory = verifySslHostname ? new SSLConnectionSocketFactory(ctx) : new SSLConnectionSocketFactory(ctx, (hostname, session) -> true);
            connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        });
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.setMaxConnPerRoute(100).setMaxConnTotal(200).setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).build()).useSystemProperties().evictExpiredConnections().evictIdleConnections(TimeValue.ofMinutes((long)1L)).build();
    }

    private static <T> ConnectClient.ConnectResponse<T> withRetries(Callable<ConnectClient.ConnectResponse<T>> action) {
        try {
            return (ConnectClient.ConnectResponse)RetryerBuilder.newBuilder().withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).withWaitStrategy(WaitStrategies.exponentialWait()).retryIfResult(result -> result == null || result.httpCode() >= 500 || result.httpCode() == 409).retryIfException().build().call(action);
        }
        catch (ExecutionException e) {
            throw new KsqlServerException("Unexpected exception!", (Throwable)e);
        }
        catch (RetryException e) {
            LOG.warn("Failed to query connect cluster after {} attempts.", (Object)e.getNumberOfFailedAttempts());
            if (e.getLastFailedAttempt().hasResult()) {
                return (ConnectClient.ConnectResponse)e.getLastFailedAttempt().getResult();
            }
            throw new KsqlServerException(e.getCause());
        }
    }

    private static <T, C> HttpClientResponseHandler<ConnectClient.ConnectResponse<T>> createHandler(int expectedStatus, TypeReference<C> entityTypeRef, Function<C, T> cast) {
        return DefaultConnectClient.createHandler(Collections.singletonList(expectedStatus), entityTypeRef, cast);
    }

    private static <T, C> HttpClientResponseHandler<ConnectClient.ConnectResponse<T>> createHandler(List<Integer> expectedStatuses, TypeReference<C> entityTypeRef, Function<C, T> cast) {
        return httpResponse -> {
            int code = httpResponse.getCode();
            if (!expectedStatuses.contains(httpResponse.getCode())) {
                String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                return ConnectClient.ConnectResponse.failure((String)entity, (int)code);
            }
            HttpEntity entity = httpResponse.getEntity();
            Object data = cast.apply(entity == null ? null : MAPPER.readValue(entity.getContent(), entityTypeRef));
            return ConnectClient.ConnectResponse.success(data, (int)code);
        };
    }
}

