/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.KafkaConsumerGroupClient;
import io.confluent.ksql.services.KafkaConsumerGroupClientImpl;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.KafkaTopicClientImpl;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.SimpleKsqlClient;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.streams.KafkaClientSupplier;

public class DefaultServiceContext
implements ServiceContext {
    private final KafkaClientSupplier kafkaClientSupplier;
    private final MemoizedSupplier<Admin> adminClientSupplier;
    private final MemoizedSupplier<Admin> topicAdminClientSupplier;
    private final MemoizedSupplier<KafkaTopicClient> topicClientSupplier;
    private final Supplier<SchemaRegistryClient> srClientFactorySupplier;
    private final MemoizedSupplier<SchemaRegistryClient> srClient;
    private final MemoizedSupplier<ConnectClient> connectClientSupplier;
    private final MemoizedSupplier<SimpleKsqlClient> ksqlClientSupplier;
    private final MemoizedSupplier<KafkaConsumerGroupClient> consumerGroupClientSupplier;

    public DefaultServiceContext(KafkaClientSupplier kafkaClientSupplier, Supplier<Admin> adminClientSupplier, Supplier<Admin> topicAdminClientSupplier, Supplier<SchemaRegistryClient> srClientSupplier, Supplier<ConnectClient> connectClientSupplier, Supplier<SimpleKsqlClient> ksqlClientSupplier) {
        this(kafkaClientSupplier, adminClientSupplier, topicAdminClientSupplier, KafkaTopicClientImpl::new, srClientSupplier, connectClientSupplier, ksqlClientSupplier, KafkaConsumerGroupClientImpl::new);
    }

    @VisibleForTesting
    public DefaultServiceContext(KafkaClientSupplier kafkaClientSupplier, Supplier<Admin> adminClientSupplier, Supplier<Admin> topicAdminClientSupplier, KafkaTopicClient topicClient, Supplier<SchemaRegistryClient> srClientSupplier, Supplier<ConnectClient> connectClientSupplier, Supplier<SimpleKsqlClient> ksqlClientSupplier, KafkaConsumerGroupClient consumerGroupClient) {
        this(kafkaClientSupplier, adminClientSupplier, topicAdminClientSupplier, (Supplier<Admin> adminSupplier) -> topicClient, srClientSupplier, connectClientSupplier, ksqlClientSupplier, (Supplier<Admin> adminSupplier) -> consumerGroupClient);
    }

    private DefaultServiceContext(KafkaClientSupplier kafkaClientSupplier, Supplier<Admin> adminClientSupplier, Supplier<Admin> topicAdminClientSupplier, Function<Supplier<Admin>, KafkaTopicClient> topicClientProvider, Supplier<SchemaRegistryClient> srClientSupplier, Supplier<ConnectClient> connectClientSupplier, Supplier<SimpleKsqlClient> ksqlClientSupplier, Function<Supplier<Admin>, KafkaConsumerGroupClient> consumerGroupClientProvider) {
        Objects.requireNonNull(adminClientSupplier, "adminClientSupplier");
        this.adminClientSupplier = new MemoizedSupplier<Admin>(adminClientSupplier);
        this.topicAdminClientSupplier = new MemoizedSupplier<Admin>(topicAdminClientSupplier);
        this.srClientFactorySupplier = Objects.requireNonNull(srClientSupplier, "srClientSupplier");
        Objects.requireNonNull(connectClientSupplier, "connectClientSupplier");
        this.connectClientSupplier = new MemoizedSupplier<ConnectClient>(connectClientSupplier);
        Objects.requireNonNull(ksqlClientSupplier, "ksqlClientSupplier");
        this.ksqlClientSupplier = new MemoizedSupplier<SimpleKsqlClient>(ksqlClientSupplier);
        this.srClient = new MemoizedSupplier<SchemaRegistryClient>(srClientSupplier);
        this.kafkaClientSupplier = Objects.requireNonNull(kafkaClientSupplier, "kafkaClientSupplier");
        this.topicClientSupplier = new MemoizedSupplier<KafkaTopicClient>(() -> (KafkaTopicClient)topicClientProvider.apply(this.topicAdminClientSupplier));
        this.consumerGroupClientSupplier = new MemoizedSupplier<KafkaConsumerGroupClient>(() -> (KafkaConsumerGroupClient)consumerGroupClientProvider.apply(this.adminClientSupplier));
    }

    public Admin getAdminClient() {
        return this.adminClientSupplier.get();
    }

    public KafkaTopicClient getTopicClient() {
        return this.topicClientSupplier.get();
    }

    public KafkaClientSupplier getKafkaClientSupplier() {
        return this.kafkaClientSupplier;
    }

    public SchemaRegistryClient getSchemaRegistryClient() {
        return this.srClient.get();
    }

    public Supplier<SchemaRegistryClient> getSchemaRegistryClientFactory() {
        return this.srClientFactorySupplier;
    }

    public ConnectClient getConnectClient() {
        return this.connectClientSupplier.get();
    }

    public SimpleKsqlClient getKsqlClient() {
        return this.ksqlClientSupplier.get();
    }

    public KafkaConsumerGroupClient getConsumerGroupClient() {
        return this.consumerGroupClientSupplier.get();
    }

    public void close() {
        if (this.adminClientSupplier.isInitialized()) {
            this.adminClientSupplier.get().close();
        }
        if (this.topicAdminClientSupplier.isInitialized()) {
            this.topicAdminClientSupplier.get().close();
        }
        if (this.ksqlClientSupplier.isInitialized()) {
            this.ksqlClientSupplier.get().close();
        }
    }

    static final class MemoizedSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier = Suppliers.memoize(supplier::get);
        private volatile boolean initialized = false;

        MemoizedSupplier(Supplier<T> supplier) {
        }

        @Override
        public T get() {
            this.initialized = true;
            return this.supplier.get();
        }

        boolean isInitialized() {
            return this.initialized;
        }
    }
}

