/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.collect.Iterables;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.ExecutorUtil;
import io.confluent.ksql.util.KsqlServerException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KafkaClusterUtil {
    private static final Logger LOG = LogManager.getLogger(KafkaClusterUtil.class);
    private static final long DESCRIBE_CLUSTER_TIMEOUT_SECONDS = 30L;

    private KafkaClusterUtil() {
    }

    public static boolean isAuthorizedOperationsSupported(Admin adminClient) {
        try {
            DescribeClusterResult authorizedOperations = adminClient.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
            return authorizedOperations.authorizedOperations().get() != null;
        }
        catch (Exception e) {
            if (ExceptionUtils.indexOfType((Throwable)e, UnsupportedVersionException.class) != -1) {
                LOG.info("Received nested unsupported version error testing authorized operations api", (Throwable)e);
                return false;
            }
            throw new KsqlServerException("Could not get Kafka authorized operations!", (Throwable)e);
        }
    }

    public static Config getConfig(Admin adminClient) {
        try {
            Collection brokers = (Collection)adminClient.describeCluster().nodes().get();
            Node broker = (Node)Iterables.getFirst((Iterable)brokers, null);
            if (broker == null) {
                LOG.warn("No available broker found to fetch config info.");
                throw new KsqlServerException("AdminClient discovered an empty Kafka Cluster. Check that Kafka is deployed and KSQL is properly configured.");
            }
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, broker.idString());
            Map brokerConfig = ExecutorUtil.executeWithRetries(() -> (Map)adminClient.describeConfigs(Collections.singleton(configResource)).all().get(), ExecutorUtil.RetryBehaviour.ON_RETRYABLE);
            return (Config)brokerConfig.get(configResource);
        }
        catch (KsqlServerException e) {
            throw e;
        }
        catch (ClusterAuthorizationException e) {
            throw new KsqlServerException("Could not get Kafka cluster configuration. Please ensure the ksql principal has " + String.valueOf(AclOperation.DESCRIBE_CONFIGS) + " rights on the Kafka cluster." + System.lineSeparator() + "See https://docs.ksqldb.io/en/latest/operate-and-deploy/installation/server-config/security/#required-acls for more info.", (Throwable)e);
        }
        catch (Exception e) {
            throw new KsqlServerException("Could not get Kafka cluster configuration!", (Throwable)e);
        }
    }

    public static String getKafkaClusterId(ServiceContext serviceContext) {
        try {
            return (String)serviceContext.getAdminClient().describeCluster().clusterId().get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Kafka cluster information", e);
        }
    }
}

