/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.registry.KsqlSchemaRegistryClientFactory;
import io.confluent.ksql.security.KsqlPrincipal;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.DefaultConnectClientFactory;
import io.confluent.ksql.services.DefaultServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;

public final class ServiceContextFactory {
    private ServiceContextFactory() {
    }

    public static ServiceContext create(KsqlConfig ksqlConfig, Supplier<SimpleKsqlClient> ksqlClientSupplier) {
        return ServiceContextFactory.create(ksqlConfig, (KafkaClientSupplier)new DefaultKafkaClientSupplier(), new KsqlSchemaRegistryClientFactory(ksqlConfig, Collections.emptyMap())::get, () -> new DefaultConnectClientFactory(ksqlConfig).get(Optional.empty(), Collections.emptyList(), Optional.empty()), ksqlClientSupplier, Optional.empty());
    }

    public static ServiceContext create(KsqlConfig ksqlConfig, KafkaClientSupplier kafkaClientSupplier, Supplier<SchemaRegistryClient> srClientFactory, Supplier<ConnectClient> connectClientSupplier, Supplier<SimpleKsqlClient> ksqlClientSupplier, Optional<KsqlPrincipal> userPrincipal) {
        KafkaClientSupplier finalKafkaClientSupplier = ksqlConfig.getBoolean("ksql.client.ip_port.configuration.enabled") != false && userPrincipal.isPresent() ? new KafkaClientSupplierWithProxyConfigs(userPrincipal, kafkaClientSupplier, ProxyProtocolCommand.PROXY) : (ksqlConfig.getBoolean("ksql.proxy.protocol.local.mode.enabled") != false ? new KafkaClientSupplierWithProxyConfigs(userPrincipal, kafkaClientSupplier, ProxyProtocolCommand.LOCAL) : kafkaClientSupplier);
        Supplier<Admin> adminClientSupplier = () -> finalKafkaClientSupplier.getAdmin(ksqlConfig.getKsqlAdminClientConfigProps());
        return new DefaultServiceContext(finalKafkaClientSupplier, adminClientSupplier, adminClientSupplier, srClientFactory, connectClientSupplier, ksqlClientSupplier);
    }

    private static class KafkaClientSupplierWithProxyConfigs
    implements KafkaClientSupplier {
        private final KsqlPrincipal userPrincipal;
        private final KafkaClientSupplier kafkaClientSupplier;
        private final ProxyProtocolCommand proxyProtocolCommand;

        KafkaClientSupplierWithProxyConfigs(Optional<KsqlPrincipal> userPrincipal, KafkaClientSupplier kafkaClientSupplier, ProxyProtocolCommand proxyProtocolCommand) {
            this.kafkaClientSupplier = kafkaClientSupplier;
            this.proxyProtocolCommand = proxyProtocolCommand;
            if (ProxyProtocolCommand.PROXY == proxyProtocolCommand && !userPrincipal.isPresent()) {
                throw new IllegalArgumentException("User principal is mandatory for PROXY mode.");
            }
            this.userPrincipal = userPrincipal.orElse(null);
        }

        public Admin getAdmin(Map<String, Object> config) {
            Map<String, Object> configsWithProxyProtocol = this.applyAdminProxyProtocolConfigs(config, this.proxyProtocolCommand);
            return this.kafkaClientSupplier.getAdmin(configsWithProxyProtocol);
        }

        public Producer<byte[], byte[]> getProducer(Map<String, Object> config) {
            Map<String, Object> configsWithProxyProtocol = this.applyProducerProxyProtocolConfigs(config, this.proxyProtocolCommand);
            return this.kafkaClientSupplier.getProducer(configsWithProxyProtocol);
        }

        public Consumer<byte[], byte[]> getConsumer(Map<String, Object> config) {
            Map<String, Object> configsWithProxyProtocol = this.applyConsumerProxyProtocolConfigs(config, this.proxyProtocolCommand);
            return this.kafkaClientSupplier.getConsumer(configsWithProxyProtocol);
        }

        public Consumer<byte[], byte[]> getRestoreConsumer(Map<String, Object> config) {
            Map<String, Object> configsWithProxyProtocol = this.applyConsumerProxyProtocolConfigs(config, this.proxyProtocolCommand);
            return this.kafkaClientSupplier.getRestoreConsumer(configsWithProxyProtocol);
        }

        public Consumer<byte[], byte[]> getGlobalConsumer(Map<String, Object> config) {
            Map<String, Object> configsWithProxyProtocol = this.applyConsumerProxyProtocolConfigs(config, this.proxyProtocolCommand);
            return this.kafkaClientSupplier.getGlobalConsumer(configsWithProxyProtocol);
        }

        private Map<String, Object> applyProducerProxyProtocolConfigs(Map<String, Object> config, ProxyProtocolCommand proxyProtocolCommand) {
            HashMap<String, Object> configsWithProxyProtocol = new HashMap<String, Object>(config);
            if (ProxyProtocolCommand.PROXY == proxyProtocolCommand) {
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.PROXY.name());
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.address", this.userPrincipal.getIpAddress());
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.port", this.userPrincipal.getPort());
            } else {
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.LOCAL.name());
            }
            configsWithProxyProtocol.put("confluent.proxy.protocol.client.version", ProxyProtocol.V2.name);
            return configsWithProxyProtocol;
        }

        private Map<String, Object> applyConsumerProxyProtocolConfigs(Map<String, Object> config, ProxyProtocolCommand proxyProtocolCommand) {
            HashMap<String, Object> configsWithProxyProtocol = new HashMap<String, Object>(config);
            if (ProxyProtocolCommand.PROXY == proxyProtocolCommand) {
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.PROXY.name());
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.address", this.userPrincipal.getIpAddress());
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.port", this.userPrincipal.getPort());
            } else {
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.LOCAL.name());
            }
            configsWithProxyProtocol.put("confluent.proxy.protocol.client.version", ProxyProtocol.V2.name);
            return configsWithProxyProtocol;
        }

        private Map<String, Object> applyAdminProxyProtocolConfigs(Map<String, Object> config, ProxyProtocolCommand proxyProtocolCommand) {
            HashMap<String, Object> configsWithProxyProtocol = new HashMap<String, Object>(config);
            if (ProxyProtocolCommand.PROXY == proxyProtocolCommand) {
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.PROXY.name());
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.address", this.userPrincipal.getIpAddress());
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.port", this.userPrincipal.getPort());
            } else {
                configsWithProxyProtocol.put("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.LOCAL.name());
            }
            configsWithProxyProtocol.put("confluent.proxy.protocol.client.version", ProxyProtocol.V2.name);
            return configsWithProxyProtocol;
        }
    }
}

