/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.statement;

import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface InjectorWithSideEffects
extends Injector {
    public <T extends Statement> ConfiguredStatementWithSideEffects<T> injectWithSideEffects(ConfiguredStatement<T> var1);

    public <T extends Statement> void revertSideEffects(ConfiguredStatementWithSideEffects<T> var1);

    public static InjectorWithSideEffects wrap(final Injector injector) {
        if (injector instanceof InjectorWithSideEffects) {
            return (InjectorWithSideEffects)injector;
        }
        return new InjectorWithSideEffects(){

            @Override
            public <T extends Statement> ConfiguredStatementWithSideEffects<T> injectWithSideEffects(ConfiguredStatement<T> statement) {
                return ConfiguredStatementWithSideEffects.withNoEffects(this.inject(statement));
            }

            @Override
            public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
                return injector.inject(statement);
            }

            @Override
            public <T extends Statement> void revertSideEffects(ConfiguredStatementWithSideEffects<T> statement) {
            }
        };
    }

    public static class ConfiguredStatementWithSideEffects<T extends Statement> {
        private final ConfiguredStatement<T> statement;
        private final List<Object> sideEffects;

        public ConfiguredStatementWithSideEffects(ConfiguredStatement<T> statement, List<Object> sideEffects) {
            this.statement = statement;
            this.sideEffects = new ArrayList<Object>(sideEffects);
        }

        public ConfiguredStatement<T> getStatement() {
            return this.statement;
        }

        public List<Object> getSideEffects() {
            return Collections.unmodifiableList(this.sideEffects);
        }

        public static <T extends Statement> ConfiguredStatementWithSideEffects<T> withNoEffects(ConfiguredStatement<T> statement) {
            return new ConfiguredStatementWithSideEffects<T>(statement, Collections.emptyList());
        }
    }
}

