/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.structured;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.TableSourceV1;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;
import io.confluent.ksql.execution.streams.ExecutionStepFactory;
import io.confluent.ksql.execution.streams.StepSchemaResolver;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.InternalFormats;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.structured.SchemaKTable;
import java.util.Optional;
import java.util.Set;

public final class SchemaKSourceFactory {
    private SchemaKSourceFactory() {
    }

    public static SchemaKStream<?> buildSource(PlanBuildContext buildContext, DataSource dataSource, QueryContext.Stacker contextStacker) {
        boolean windowed = dataSource.getKsqlTopic().getKeyFormat().isWindowed();
        switch (dataSource.getDataSourceType()) {
            case KSTREAM: {
                return windowed ? SchemaKSourceFactory.buildWindowedStream(buildContext, dataSource, contextStacker) : SchemaKSourceFactory.buildStream(buildContext, dataSource, contextStacker);
            }
            case KTABLE: {
                return windowed ? SchemaKSourceFactory.buildWindowedTable(buildContext, dataSource, contextStacker) : SchemaKSourceFactory.buildTable(buildContext, dataSource, contextStacker);
            }
        }
        throw new UnsupportedOperationException("Source type:" + String.valueOf(dataSource.getDataSourceType()));
    }

    private static SchemaKStream<?> buildWindowedStream(PlanBuildContext buildContext, DataSource dataSource, QueryContext.Stacker contextStacker) {
        WindowInfo windowInfo = (WindowInfo)dataSource.getKsqlTopic().getKeyFormat().getWindowInfo().orElseThrow(IllegalArgumentException::new);
        int pseudoColumnVersionToUse = SchemaKSourceFactory.determinePseudoColumnVersionToUse(buildContext);
        WindowedStreamSource step = ExecutionStepFactory.streamSourceWindowed((QueryContext.Stacker)contextStacker, (LogicalSchema)dataSource.getSchema(), (String)dataSource.getKafkaTopicName(), (Formats)Formats.from((KsqlTopic)dataSource.getKsqlTopic()), (WindowInfo)windowInfo, (Optional)dataSource.getTimestampColumn(), (int)pseudoColumnVersionToUse);
        return SchemaKSourceFactory.schemaKStream(buildContext, SchemaKSourceFactory.resolveSchema(buildContext, step, dataSource), dataSource.getKsqlTopic().getKeyFormat(), step);
    }

    private static SchemaKStream<?> buildStream(PlanBuildContext buildContext, DataSource dataSource, QueryContext.Stacker contextStacker) {
        if (dataSource.getKsqlTopic().getKeyFormat().getWindowInfo().isPresent()) {
            throw new IllegalArgumentException("windowed");
        }
        int pseudoColumnVersionToUse = SchemaKSourceFactory.determinePseudoColumnVersionToUse(buildContext);
        StreamSource step = ExecutionStepFactory.streamSource((QueryContext.Stacker)contextStacker, (LogicalSchema)dataSource.getSchema(), (String)dataSource.getKafkaTopicName(), (Formats)Formats.from((KsqlTopic)dataSource.getKsqlTopic()), (Optional)dataSource.getTimestampColumn(), (int)pseudoColumnVersionToUse);
        return SchemaKSourceFactory.schemaKStream(buildContext, SchemaKSourceFactory.resolveSchema(buildContext, step, dataSource), dataSource.getKsqlTopic().getKeyFormat(), step);
    }

    private static SchemaKTable<?> buildWindowedTable(PlanBuildContext buildContext, DataSource dataSource, QueryContext.Stacker contextStacker) {
        WindowInfo windowInfo = (WindowInfo)dataSource.getKsqlTopic().getKeyFormat().getWindowInfo().orElseThrow(IllegalArgumentException::new);
        int pseudoColumnVersionToUse = SchemaKSourceFactory.determinePseudoColumnVersionToUse(buildContext);
        WindowedTableSource step = ExecutionStepFactory.tableSourceWindowed((QueryContext.Stacker)contextStacker, (LogicalSchema)dataSource.getSchema(), (String)dataSource.getKafkaTopicName(), (Formats)Formats.from((KsqlTopic)dataSource.getKsqlTopic()), (WindowInfo)windowInfo, (Optional)dataSource.getTimestampColumn(), (int)pseudoColumnVersionToUse);
        return SchemaKSourceFactory.schemaKTable(buildContext, SchemaKSourceFactory.resolveSchema(buildContext, step, dataSource), dataSource.getKsqlTopic().getKeyFormat(), step);
    }

    private static SchemaKTable<?> buildTable(PlanBuildContext buildContext, DataSource dataSource, QueryContext.Stacker contextStacker) {
        TableSourceV1 step;
        KeyFormat keyFormat = dataSource.getKsqlTopic().getKeyFormat();
        if (keyFormat.isWindowed()) {
            throw new IllegalArgumentException("windowed");
        }
        int pseudoColumnVersionToUse = SchemaKSourceFactory.determinePseudoColumnVersionToUse(buildContext);
        boolean useOldExecutionStepVersion = false;
        if (buildContext.getPlanInfo().isPresent()) {
            Set sourceSteps = buildContext.getPlanInfo().get().getSources();
            useOldExecutionStepVersion = sourceSteps.stream().anyMatch(executionStep -> executionStep instanceof TableSourceV1);
        }
        if (!useOldExecutionStepVersion) {
            step = ExecutionStepFactory.tableSource((QueryContext.Stacker)contextStacker, (LogicalSchema)dataSource.getSchema(), (String)dataSource.getKafkaTopicName(), (Formats)Formats.from((KsqlTopic)dataSource.getKsqlTopic()), (Optional)dataSource.getTimestampColumn(), (Formats)InternalFormats.of(keyFormat, Formats.from((KsqlTopic)dataSource.getKsqlTopic()).getValueFormat()), (int)pseudoColumnVersionToUse);
        } else {
            if (pseudoColumnVersionToUse != 0) {
                throw new IllegalStateException("TableSourceV2 was released in conjunction with pseudocolumn version 1. Something has gone very wrong");
            }
            step = ExecutionStepFactory.tableSourceV1((QueryContext.Stacker)contextStacker, (LogicalSchema)dataSource.getSchema(), (String)dataSource.getKafkaTopicName(), (Formats)Formats.from((KsqlTopic)dataSource.getKsqlTopic()), (Optional)dataSource.getTimestampColumn(), (int)pseudoColumnVersionToUse);
        }
        return SchemaKSourceFactory.schemaKTable(buildContext, SchemaKSourceFactory.resolveSchema(buildContext, step, dataSource), dataSource.getKsqlTopic().getKeyFormat(), step);
    }

    private static int determinePseudoColumnVersionToUse(PlanBuildContext buildContext) {
        if (buildContext.getPlanInfo().isPresent()) {
            Set sourceSteps = buildContext.getPlanInfo().get().getSources();
            return sourceSteps.stream().map(SourceStep.class::cast).mapToInt(SourceStep::getPseudoColumnVersion).findAny().getAsInt();
        }
        return 1;
    }

    private static <K> SchemaKStream<K> schemaKStream(PlanBuildContext buildContext, LogicalSchema schema, KeyFormat keyFormat, SourceStep<KStreamHolder<K>> streamSource) {
        return new SchemaKStream<K>(streamSource, schema, keyFormat, buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
    }

    private static <K> SchemaKTable<K> schemaKTable(PlanBuildContext buildContext, LogicalSchema schema, KeyFormat keyFormat, SourceStep<KTableHolder<K>> tableSource) {
        return new SchemaKTable<K>(tableSource, schema, keyFormat, buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
    }

    private static LogicalSchema resolveSchema(PlanBuildContext buildContext, ExecutionStep<?> step, DataSource dataSource) {
        return new StepSchemaResolver(buildContext.getKsqlConfig(), buildContext.getFunctionRegistry()).resolve(step, dataSource.getSchema());
    }
}

