/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLoggerFactory;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.MaterializationProviderBuilderFactory;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.StreamsTaskMetadata;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.QueryMetadataImpl;
import io.confluent.ksql.util.SharedKafkaStreamsRuntime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.LagInfo;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopology;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinPackedPersistentQueryMetadataImpl
implements PersistentQueryMetadata {
    private static final Logger LOG = LogManager.getLogger(BinPackedPersistentQueryMetadataImpl.class);
    private final KsqlConstants.PersistentQueryType persistentQueryType;
    private final String statementString;
    private final String executionPlan;
    private final String applicationId;
    private final Optional<MaterializationInfo> materializationInfo;
    private final KeyFormat keyFormat;
    private NamedTopology topology;
    private final SharedKafkaStreamsRuntime sharedKafkaStreamsRuntime;
    private final QuerySchemas schemas;
    private final ImmutableMap<String, Object> overriddenProperties;
    private final Set<DataSource> sources;
    private final QueryId queryId;
    private final Optional<DataSource> sinkDataSource;
    private final ProcessingLogger processingLogger;
    private final ExecutionStep<?> physicalPlan;
    private final PhysicalSchema resultSchema;
    private final QueryMetadata.Listener listener;
    private final Function<SharedKafkaStreamsRuntime, NamedTopology> namedTopologyBuilder;
    private final QueryMetadataImpl.TimeBoundedQueue queryErrors;
    private final MaterializationProviderBuilderFactory materializationProviderBuilderFactory;
    private final Optional<ScalablePushRegistry> scalablePushRegistry;
    private final ProcessingLoggerFactory loggerFactory;
    public boolean everStarted = false;
    private boolean isPaused = false;
    private boolean corruptionCommandTopic = false;

    @VisibleForTesting
    public BinPackedPersistentQueryMetadataImpl(KsqlConstants.PersistentQueryType persistentQueryType, String statementString, PhysicalSchema schema, Set<DataSource> sources, String executionPlan, String applicationId, NamedTopology topology, SharedKafkaStreamsRuntime sharedKafkaStreamsRuntime, QuerySchemas schemas, Map<String, Object> overriddenProperties, QueryId queryId, Optional<MaterializationInfo> materializationInfo, MaterializationProviderBuilderFactory materializationProviderBuilderFactory, ExecutionStep<?> physicalPlan, ProcessingLogger processingLogger, Optional<DataSource> sinkDataSource, QueryMetadata.Listener listener, Optional<ScalablePushRegistry> scalablePushRegistry, Function<SharedKafkaStreamsRuntime, NamedTopology> namedTopologyBuilder, KeyFormat keyFormat, ProcessingLoggerFactory loggerFactory) {
        this.persistentQueryType = Objects.requireNonNull(persistentQueryType, "persistentQueryType");
        this.statementString = Objects.requireNonNull(statementString, "statementString");
        this.executionPlan = Objects.requireNonNull(executionPlan, "executionPlan");
        this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
        this.topology = Objects.requireNonNull(topology, "namedTopology");
        this.sharedKafkaStreamsRuntime = Objects.requireNonNull(sharedKafkaStreamsRuntime, "sharedKafkaStreamsRuntime");
        this.sinkDataSource = Objects.requireNonNull(sinkDataSource, "sinkDataSource");
        this.schemas = Objects.requireNonNull(schemas, "schemas");
        this.overriddenProperties = ImmutableMap.copyOf(Objects.requireNonNull(overriddenProperties, "overriddenProperties"));
        this.sources = Objects.requireNonNull(sources, "sourceNames");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
        this.physicalPlan = Objects.requireNonNull(physicalPlan, "physicalPlan");
        this.resultSchema = Objects.requireNonNull(schema, "schema");
        this.materializationProviderBuilderFactory = Objects.requireNonNull(materializationProviderBuilderFactory, "materializationProviderBuilderFactory");
        this.materializationInfo = Objects.requireNonNull(materializationInfo, "materializationInfo");
        this.listener = new PersistentQueryMetadata.QueryListenerWrapper(listener, scalablePushRegistry);
        this.namedTopologyBuilder = Objects.requireNonNull(namedTopologyBuilder, "namedTopologyBuilder");
        this.queryErrors = sharedKafkaStreamsRuntime.getNewQueryErrorQueue();
        this.scalablePushRegistry = Objects.requireNonNull(scalablePushRegistry, "scalablePushRegistry");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.loggerFactory = Objects.requireNonNull(loggerFactory, "loggerFactory");
    }

    public BinPackedPersistentQueryMetadataImpl(BinPackedPersistentQueryMetadataImpl original, QueryMetadata.Listener listener) {
        this.persistentQueryType = original.getPersistentQueryType();
        this.statementString = original.statementString;
        this.executionPlan = original.executionPlan;
        this.applicationId = original.applicationId;
        this.topology = original.topology;
        this.sharedKafkaStreamsRuntime = original.sharedKafkaStreamsRuntime;
        this.sinkDataSource = original.getSink();
        this.schemas = original.schemas;
        this.overriddenProperties = ImmutableMap.copyOf(original.getOverriddenProperties());
        this.sources = original.getSources();
        this.queryId = original.getQueryId();
        this.processingLogger = original.processingLogger;
        this.physicalPlan = original.getPhysicalPlan();
        this.resultSchema = original.resultSchema;
        this.materializationProviderBuilderFactory = original.materializationProviderBuilderFactory;
        this.materializationInfo = original.materializationInfo;
        this.listener = Objects.requireNonNull(listener, "listener");
        this.queryErrors = this.sharedKafkaStreamsRuntime.getNewQueryErrorQueue();
        this.scalablePushRegistry = original.scalablePushRegistry;
        this.namedTopologyBuilder = original.namedTopologyBuilder;
        this.keyFormat = original.keyFormat;
        this.loggerFactory = original.loggerFactory;
    }

    @Override
    public Optional<DataSource.DataSourceType> getDataSourceType() {
        return this.sinkDataSource.map(DataSource::getDataSourceType);
    }

    @Override
    public Optional<KsqlTopic> getResultTopic() {
        return this.sinkDataSource.map(DataSource::getKsqlTopic);
    }

    @Override
    public Optional<SourceName> getSinkName() {
        return this.sinkDataSource.map(DataSource::getName);
    }

    @Override
    public QuerySchemas getQuerySchemas() {
        return this.schemas;
    }

    @Override
    public PhysicalSchema getPhysicalSchema() {
        return this.resultSchema;
    }

    @Override
    public ExecutionStep<?> getPhysicalPlan() {
        return this.physicalPlan;
    }

    @Override
    public Optional<DataSource> getSink() {
        return this.sinkDataSource;
    }

    @Override
    public KsqlConstants.PersistentQueryType getPersistentQueryType() {
        return this.persistentQueryType;
    }

    @Override
    public ProcessingLogger getProcessingLogger() {
        return this.processingLogger;
    }

    @Override
    public Optional<Materialization> getMaterialization(QueryId queryId, QueryContext.Stacker contextStacker) {
        return this.materializationInfo.map(info -> this.materializationProviderBuilderFactory.materializationProviderBuilder((MaterializationInfo)info, this.resultSchema, this.keyFormat, this.getStreamsProperties(), this.applicationId, this.queryId.toString())).flatMap(builder -> (Optional)builder.apply(this.sharedKafkaStreamsRuntime.getKafkaStreams(), this.topology)).map(builder -> builder.build(queryId, contextStacker));
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    @Override
    public void stop(boolean resetOffsets) {
        this.sharedKafkaStreamsRuntime.stop(this.queryId, resetOffsets);
        this.scalablePushRegistry.ifPresent(ScalablePushRegistry::close);
    }

    @Override
    public StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse uncaughtHandler(Throwable error) {
        throw new UnsupportedOperationException("Should not get uncaught exception handler for individual queries in shared runtime");
    }

    @Override
    public Optional<ScalablePushRegistry> getScalablePushRegistry() {
        return this.scalablePushRegistry;
    }

    @Override
    public void initialize() {
    }

    @Override
    public Set<StreamsTaskMetadata> getTaskMetadata() {
        return this.sharedKafkaStreamsRuntime.getAllTaskMetadataForQuery(this.queryId);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="overriddenProperties is immutable")
    public Map<String, Object> getOverriddenProperties() {
        return this.overriddenProperties;
    }

    @Override
    public String getStatementString() {
        return this.statementString;
    }

    @Override
    public void setUncaughtExceptionHandler(StreamsUncaughtExceptionHandler handler) {
        throw new UnsupportedOperationException("Should not set uncaught exception handler for individual queries in shared runtime");
    }

    @Override
    public KafkaStreams.State getState() {
        if (this.corruptionCommandTopic) {
            return KafkaStreams.State.ERROR;
        }
        return this.sharedKafkaStreamsRuntime.state();
    }

    @Override
    public String getExecutionPlan() {
        return this.executionPlan;
    }

    @Override
    public String getQueryApplicationId() {
        return this.applicationId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="topology is for reference")
    public NamedTopology getTopology() {
        return this.topology;
    }

    public NamedTopology getTopologyCopy(SharedKafkaStreamsRuntime builder) {
        return this.namedTopologyBuilder.apply(builder);
    }

    public void updateTopology(NamedTopology topology) {
        this.topology = topology;
    }

    @Override
    public Map<String, Map<Integer, LagInfo>> getAllLocalStorePartitionLags() {
        return this.sharedKafkaStreamsRuntime.getAllLocalStorePartitionLagsForQuery(this.queryId);
    }

    @Override
    public Collection<StreamsMetadata> getAllStreamsHostMetadata() {
        try {
            return ImmutableList.copyOf(this.sharedKafkaStreamsRuntime.getAllStreamsClientsMetadataForQuery(this.queryId));
        }
        catch (IllegalStateException e) {
            LOG.error(e.getMessage());
            return ImmutableList.of();
        }
    }

    @Override
    public Map<String, Object> getStreamsProperties() {
        return this.sharedKafkaStreamsRuntime.getStreamProperties();
    }

    @Override
    public LogicalSchema getLogicalSchema() {
        return this.resultSchema.logicalSchema();
    }

    @Override
    public Set<SourceName> getSourceNames() {
        return ImmutableSet.copyOf((Collection)this.sources.stream().map(DataSource::getName).collect(Collectors.toSet()));
    }

    @Override
    public boolean hasEverBeenStarted() {
        return this.everStarted;
    }

    @Override
    public QueryId getQueryId() {
        return this.queryId;
    }

    @Override
    public KsqlConstants.KsqlQueryType getQueryType() {
        return KsqlConstants.KsqlQueryType.PERSISTENT;
    }

    @Override
    public String getTopologyDescription() {
        return this.topology.describe().toString();
    }

    @Override
    public List<QueryError> getQueryErrors() {
        return this.queryErrors.toImmutableList();
    }

    @Override
    public void setCorruptionQueryError() {
        QueryError corruptionQueryError = new QueryError(System.currentTimeMillis(), "Query not started due to corruption in the command topic.", QueryError.Type.USER);
        this.setQueryError(corruptionQueryError);
        this.corruptionCommandTopic = true;
    }

    public void setQueryError(QueryError error) {
        this.listener.onError(this, error);
        this.queryErrors.add(error);
    }

    @Override
    public KafkaStreams getKafkaStreams() {
        return this.sharedKafkaStreamsRuntime.getKafkaStreams();
    }

    public void onStateChange(KafkaStreams.State newState, KafkaStreams.State oldState) {
        this.listener.onStateChange(this, newState, oldState);
    }

    @Override
    public void close() {
        this.loggerFactory.getLoggersWithPrefix(this.queryId.toString()).forEach(ProcessingLogger::close);
        this.sharedKafkaStreamsRuntime.stop(this.queryId, true);
        this.scalablePushRegistry.ifPresent(ScalablePushRegistry::close);
        this.listener.onClose(this);
    }

    @Override
    public void start() {
        if (!this.everStarted) {
            this.sharedKafkaStreamsRuntime.start(this.queryId);
        }
        this.everStarted = true;
    }

    @Override
    public KsqlConstants.KsqlQueryStatus getQueryStatus() {
        if (this.isPaused) {
            return KsqlConstants.KsqlQueryStatus.PAUSED;
        }
        return KsqlConstants.fromStreamsState((KafkaStreams.State)this.getState());
    }

    @Override
    public void pause() {
        this.sharedKafkaStreamsRuntime.getKafkaStreams().pauseNamedTopology(this.topology.name());
        this.isPaused = true;
        this.listener.onPause(this);
    }

    @Override
    public void resume() {
        this.sharedKafkaStreamsRuntime.getKafkaStreams().resumeNamedTopology(this.topology.name());
        this.isPaused = false;
        this.listener.onPause(this);
    }

    @Override
    public void register() {
        this.sharedKafkaStreamsRuntime.register(this);
    }

    QueryMetadata.Listener getListener() {
        return this.listener;
    }

    @Override
    public Collection<String> getSourceTopicNames() {
        return this.sources.stream().map(s -> s.getKsqlTopic().getKafkaTopicName()).collect(Collectors.toSet());
    }

    private Set<DataSource> getSources() {
        return this.sources;
    }
}

