/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExecutorUtil {
    private static final int NUM_RETRIES = 5;
    private static final Duration RETRY_BACKOFF_MS = Duration.ofMillis(500L);
    private static final Logger log = LogManager.getLogger(ExecutorUtil.class);

    private ExecutorUtil() {
    }

    public static void executeWithRetries(Function function, RetryBehaviour retryBehaviour) throws Exception {
        ExecutorUtil.executeWithRetries(() -> {
            function.call();
            return null;
        }, retryBehaviour);
    }

    public static <T> T executeWithRetries(Callable<T> executable, RetryBehaviour retryBehaviour) throws Exception {
        return ExecutorUtil.executeWithRetries(executable, retryBehaviour, () -> RETRY_BACKOFF_MS);
    }

    public static <T> T executeWithRetries(Callable<T> executable, Predicate<Throwable> shouldRetry) throws Exception {
        return ExecutorUtil.executeWithRetries(executable, shouldRetry, () -> RETRY_BACKOFF_MS);
    }

    public static <T> T executeWithRetries(Callable<T> executable, Predicate<Throwable> shouldRetry, Supplier<Duration> retryBackOff) throws Exception {
        return ExecutorUtil.executeWithRetries(executable, shouldRetry, retry -> (Duration)retryBackOff.get(), 5);
    }

    public static <T> T executeWithRetries(Callable<T> executable, Predicate<Throwable> shouldRetry, java.util.function.Function<Integer, Duration> retryBackOff, int numRetries) throws Exception {
        Exception lastException = null;
        for (int retries = 0; retries < numRetries; ++retries) {
            try {
                if (retries != 0) {
                    Thread.sleep(retryBackOff.apply(retries).toMillis());
                }
                return executable.call();
            }
            catch (Exception e) {
                Throwable cause;
                Throwable throwable = cause = e instanceof ExecutionException ? e.getCause() : e;
                if (!shouldRetry.test(cause)) {
                    if (cause instanceof Exception) {
                        throw cause;
                    }
                    throw new RuntimeException(e.getMessage());
                }
                log.info("Retrying request. Retry no: {} Cause: '{}'", (Object)retries, (Object)e.getMessage());
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }

    @FunctionalInterface
    public static interface Function {
        public void call() throws Exception;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RetryBehaviour implements Predicate<Throwable>
    {
        ALWAYS{

            @Override
            public boolean test(Throwable throwable) {
                return throwable instanceof Exception;
            }
        }
        ,
        ON_RETRYABLE{

            @Override
            public boolean test(Throwable throwable) {
                return throwable instanceof RetriableException;
            }
        };

    }
}

