/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileWatcher
extends Thread {
    private static final Logger log = LogManager.getLogger(FileWatcher.class);
    private volatile boolean shutdown;
    private final WatchService watchService;
    private final Path file;
    private final Path dir;
    private final Callback callback;
    private final WatchKey key;

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Null check on file.getParent() is present")
    public FileWatcher(Path file, Callback callback) throws IOException {
        this.file = Objects.requireNonNull(file);
        this.dir = Objects.requireNonNull(file.getParent(), "Watch location must have parent");
        this.watchService = FileSystems.getDefault().newWatchService();
        this.callback = Objects.requireNonNull(callback);
        this.key = this.dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public void shutdown() {
        log.info("Stopping file watcher from watching for changes: " + String.valueOf(this.file));
        this.shutdown = true;
    }

    @Override
    public void run() {
        log.info("Starting file watcher to watch for changes: " + String.valueOf(this.file));
        try {
            while (!this.shutdown && this.key.isValid()) {
                try {
                    this.handleNextWatchNotification();
                }
                catch (Exception e) {
                    log.error("Watch service caught exception, will continue:" + String.valueOf(e));
                }
            }
        }
        finally {
            log.info("Stopped watching for TLS cert changes");
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                log.info("Error closing watch service", (Throwable)e);
            }
        }
    }

    private void handleNextWatchNotification() throws InterruptedException {
        WatchKey key = this.watchService.poll(1L, TimeUnit.SECONDS);
        if (key == null) {
            return;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                log.info("Watch event is OVERFLOW - may have missed cert change");
                continue;
            }
            WatchEvent<?> ev = event;
            Path changed = this.dir.resolve((Path)ev.context());
            log.debug("Watch file change: " + String.valueOf(changed));
            if (!Files.exists(changed, new LinkOption[0]) || !changed.equals(this.file)) continue;
            log.info("Change event for watched file: " + String.valueOf(this.file));
            try {
                this.callback.run();
            }
            catch (Exception e) {
                log.error("Hit error callback on file change", (Throwable)e);
            }
            break;
        }
        if (!key.reset()) {
            log.error("Watch reset failed. No longer watching directory. This is likely because the directory was deleted or renamed. Path: " + String.valueOf(this.dir));
        }
    }

    public static interface Callback {
        public void run() throws Exception;
    }
}

