/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.KafkaStreamsBuilder;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.StreamsTaskMetadata;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.QueryMetadataImpl;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.LagInfo;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.namedtopology.KafkaStreamsNamedTopologyWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SharedKafkaStreamsRuntime {
    private final Logger log = LogManager.getLogger(SharedKafkaStreamsRuntime.class);
    protected final KafkaStreamsBuilder kafkaStreamsBuilder;
    protected KafkaStreamsNamedTopologyWrapper kafkaStreams;
    protected ImmutableMap<String, Object> streamsProperties;
    protected final Map<QueryId, BinPackedPersistentQueryMetadataImpl> collocatedQueries;

    protected SharedKafkaStreamsRuntime(KafkaStreamsBuilder kafkaStreamsBuilder, Map<String, Object> streamsProperties) {
        this.kafkaStreamsBuilder = kafkaStreamsBuilder;
        this.kafkaStreams = kafkaStreamsBuilder.buildNamedTopologyWrapper(streamsProperties);
        this.streamsProperties = ImmutableMap.copyOf(streamsProperties);
        this.collocatedQueries = new ConcurrentHashMap<QueryId, BinPackedPersistentQueryMetadataImpl>();
    }

    public abstract void register(BinPackedPersistentQueryMetadataImpl var1);

    public boolean isError(QueryId queryId) {
        return !this.collocatedQueries.get(queryId).getQueryErrors().isEmpty();
    }

    public abstract QueryMetadataImpl.TimeBoundedQueue getNewQueryErrorQueue();

    public abstract void close();

    public abstract void stop(QueryId var1, boolean var2);

    public abstract void start(QueryId var1);

    public abstract void restartStreamsRuntime();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="streams must be exposed")
    public KafkaStreamsNamedTopologyWrapper getKafkaStreams() {
        return this.kafkaStreams;
    }

    public KafkaStreams.State state() {
        return this.kafkaStreams.state();
    }

    public Collection<StreamsMetadata> getAllStreamsClientsMetadataForQuery(QueryId queryId) {
        return this.kafkaStreams.allStreamsClientsMetadataForTopology(queryId.toString());
    }

    public Set<StreamsTaskMetadata> getAllTaskMetadataForQuery(QueryId queryId) {
        return this.kafkaStreams.metadataForLocalThreads().stream().flatMap(t -> t.activeTasks().stream()).filter(m -> queryId.toString().equals(m.taskId().topologyName())).map(StreamsTaskMetadata::fromStreamsTaskMetadata).collect(Collectors.toSet());
    }

    public Map<String, Map<Integer, LagInfo>> getAllLocalStorePartitionLagsForQuery(QueryId queryId) {
        try {
            return this.kafkaStreams.allLocalStorePartitionLagsForTopology(queryId.toString());
        }
        catch (IllegalStateException | StreamsException e) {
            this.log.error(e.getMessage());
            return ImmutableMap.of();
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="streamsProperties is immutable")
    public Map<String, Object> getStreamProperties() {
        return this.streamsProperties;
    }

    public Set<SourceName> getSources() {
        return this.collocatedQueries.values().stream().flatMap(t -> t.getSourceNames().stream()).collect(Collectors.toSet());
    }

    public Set<QueryId> getQueries() {
        return ImmutableSet.copyOf(this.collocatedQueries.keySet());
    }

    public KafkaStreamsBuilder getKafkaStreamsBuilder() {
        return this.kafkaStreamsBuilder;
    }

    public Map<QueryId, BinPackedPersistentQueryMetadataImpl> getCollocatedQueries() {
        return ImmutableMap.copyOf(this.collocatedQueries);
    }

    public String getApplicationId() {
        return this.getStreamProperties().get("application.id").toString();
    }

    public abstract void overrideStreamsProperties(Map<String, Object> var1);
}

