/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Optional;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PemKey {
    private static final Logger log = LoggerFactory.getLogger(PemKey.class);
    private static final JcaPEMKeyConverter PEM_KEY_CONVERTER = new JcaPEMKeyConverter();

    public static Optional<PublicKey> readPublicKey(Path path) {
        return PemKey.readPublicKey(path.toString());
    }

    public static Optional<PublicKey> readPublicKey(String path) {
        Optional<PublicKey> optional;
        FileReader fileReader = new FileReader(path);
        try {
            optional = PemKey.readPublicKey(fileReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Unable to read PEM", (Throwable)e);
                return Optional.empty();
            }
        }
        fileReader.close();
        return optional;
    }

    public static Optional<PublicKey> readPublicKey(Reader reader) throws IOException {
        Object pemObject = new PEMParser(reader).readObject();
        if (pemObject instanceof SubjectPublicKeyInfo) {
            return Optional.of(PEM_KEY_CONVERTER.getPublicKey((SubjectPublicKeyInfo)pemObject));
        }
        throw new IllegalArgumentException("PEM Object was not a public key");
    }

    public static Optional<PrivateKey> readPrivateKey(Path path) {
        return PemKey.readPrivateKey(path.toString());
    }

    public static Optional<PrivateKey> readPrivateKey(String path) {
        Optional<PrivateKey> optional;
        FileReader fileReader = new FileReader(path);
        try {
            optional = PemKey.readPrivateKey(fileReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Unable to read PEM", (Throwable)e);
                return Optional.empty();
            }
        }
        fileReader.close();
        return optional;
    }

    public static Optional<PrivateKey> readPrivateKey(Reader reader) {
        try {
            Object pemObject = new PEMParser(reader).readObject();
            if (pemObject instanceof PrivateKeyInfo) {
                return Optional.of(PEM_KEY_CONVERTER.getPrivateKey((PrivateKeyInfo)pemObject));
            }
            throw new IllegalArgumentException("PEM Object was not a private key");
        }
        catch (IOException e) {
            log.error("Failed to load private key: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static Optional<KeyPair> readKeyPair(Path path) {
        return PemKey.readKeyPair(path.toString());
    }

    public static Optional<KeyPair> readKeyPair(String path) {
        Optional<KeyPair> optional;
        FileReader fileReader = new FileReader(path);
        try {
            optional = PemKey.readKeyPair(fileReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Unable to read PEM", (Throwable)e);
                return Optional.empty();
            }
        }
        fileReader.close();
        return optional;
    }

    public static Optional<KeyPair> readKeyPair(Reader reader) {
        try {
            Object pemObject = new PEMParser(reader).readObject();
            if (pemObject instanceof PEMKeyPair) {
                return Optional.of(PEM_KEY_CONVERTER.getKeyPair((PEMKeyPair)pemObject));
            }
        }
        catch (IOException e) {
            log.error("Failed to load key pair: {}", (Object)e.getMessage());
        }
        return Optional.empty();
    }
}

