/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.MediaTypes;
import io.confluent.resourcemanager.api.client.Request;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.openapi.Adapter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public final class CreateRequest<T extends HasMetadata>
extends Request<T> {
    private final T object;

    CreateRequest(String baseUrl, OkHttpClient httpClient, Adapter<?> object) {
        super(baseUrl, httpClient, object.getJavaType(), object.getGroupVersionResource(), Location.from(object.getMetadata().getLocation()), object.getScoping(), object.getMetadata().getScopeList());
        this.object = object;
        this.kind = object.getKind();
    }

    CreateRequest(String baseUrl, OkHttpClient httpClient, T object) {
        super(baseUrl, httpClient, ClientImpl.OBJECT_MAPPER.getTypeFactory().constructType(((HasMetadata)Objects.requireNonNull(object)).getClass()), HasMetadata.getGVR(object.getClass()).orElseThrow(), Location.from(object.getMetadata().getLocation()), HasMetadata.getScoping(object.getClass()).orElseThrow(), object.getMetadata().getScopeList());
        this.object = object;
        this.kind = object.getKind();
    }

    @Override
    public CompletableFuture<T> execute() {
        return this.exec(builder -> {
            RequestBody requestBody = RequestBody.create((byte[])CreateRequest.serializeObject(this.object), (MediaType)MediaTypes.MEDIA_TYPE_JSON);
            return builder.post(requestBody);
        });
    }
}

