/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.Injector;
import com.netflix.governator.DefaultLifecycleShutdownSignal;
import com.netflix.governator.DelegatingInjector;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.LifecycleShutdownSignal;
import com.netflix.governator.spi.LifecycleListener;

public final class LifecycleInjector
extends DelegatingInjector
implements AutoCloseable {
    private final LifecycleManager manager;
    private final LifecycleShutdownSignal signal;

    public static LifecycleInjector createFailedInjector(LifecycleManager manager) {
        return new LifecycleInjector(null, manager);
    }

    public static LifecycleInjector wrapInjector(Injector injector, LifecycleManager manager) {
        return new LifecycleInjector(injector, manager);
    }

    private LifecycleInjector(Injector injector, LifecycleManager manager) {
        super(injector);
        this.manager = manager;
        this.signal = injector != null ? (LifecycleShutdownSignal)injector.getInstance(LifecycleShutdownSignal.class) : new DefaultLifecycleShutdownSignal(manager);
    }

    public void awaitTermination() throws InterruptedException {
        this.signal.await();
    }

    @Deprecated
    public void shutdown() {
        this.signal.signal();
    }

    public void addListener(LifecycleListener listener) {
        this.manager.addListener(listener);
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

