/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import com.netflix.governator.ProvisionMetrics;
import com.netflix.governator.spi.LifecycleListener;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProvisionMetricsModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisionMetricsModule.class);
    private MetricsProvisionListener listener = new MetricsProvisionListener();

    protected void configure() {
        this.bindListener(Matchers.any(), new ProvisionListener[]{this.listener});
        this.requestStaticInjection(new Class[]{MetricsProvisionListener.class});
    }

    @Provides
    @Singleton
    MetricsProvisionListener getMetricsProvisionListener() {
        return this.listener;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public String toString() {
        return "ProvisionMetricsModule[]";
    }

    @Singleton
    private static class MetricsProvisionListener
    implements ProvisionListener,
    LifecycleListener {
        private ProvisionMetrics metrics;
        private boolean doneLoading = false;

        private MetricsProvisionListener() {
        }

        @Inject
        public static void initialize(MetricsProvisionListener listener, ProvisionMetrics metrics) {
            listener.metrics = metrics;
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            Key key = provision.getBinding().getKey();
            if (this.metrics == null) {
                LOG.debug("LifecycleProvisionListener not initialized yet : {} source={}", (Object)key, provision.getBinding().getSource());
                return;
            }
            if (this.doneLoading) {
                return;
            }
            this.metrics.push(key);
            try {
                provision.provision();
            }
            finally {
                this.metrics.pop();
            }
        }

        public void onStarted() {
            this.doneLoading = true;
        }

        public void onStopped(Throwable error) {
            this.doneLoading = true;
        }
    }
}

