/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.AlterCellMigrationResponseData;
import org.apache.kafka.common.message.AlterCellResponseData;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.AlterMirrorTopicsResponseData;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.AssignBrokersToCellResponseData;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.common.message.AssignReplicasToDirsResponseData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.CreateCellResponseData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteCellResponseData;
import org.apache.kafka.common.message.DeleteClusterLinksRequestData;
import org.apache.kafka.common.message.DeleteClusterLinksResponseData;
import org.apache.kafka.common.message.DeleteTenantsResponseData;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.message.DescribeCellMigrationResponseData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.UnAssignBrokersFromCellResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AlterCellMigrationRequest;
import org.apache.kafka.common.requests.AlterCellRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.AssignBrokersToCellRequest;
import org.apache.kafka.common.requests.AssignTenantsToCellRequest;
import org.apache.kafka.common.requests.CreateCellRequest;
import org.apache.kafka.common.requests.DeleteCellRequest;
import org.apache.kafka.common.requests.DeleteTenantsRequest;
import org.apache.kafka.common.requests.DescribeCellMigrationRequest;
import org.apache.kafka.common.requests.DescribeCellsRequest;
import org.apache.kafka.common.requests.DescribeTenantsRequest;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.InternalTopicType;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.common.AlterReplicaExclusionsReply;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.junit.jupiter.api.Assertions;

public class MockController
implements Controller {
    private static final NotControllerException NOT_CONTROLLER_EXCEPTION = new NotControllerException("This is not the correct controller for this cluster.");
    private final AtomicLong nextTopicId = new AtomicLong(1L);
    private final Iterator<KafkaPrincipal> expectedAlterConfigsPrincipals;
    private Boolean expectedAlterBrokerReplicaExclusionSuccess;
    private volatile boolean active = true;
    private final Map<String, Uuid> topicNameToId = new HashMap<String, Uuid>();
    private final Map<Uuid, MockTopic> topics = new HashMap<Uuid, MockTopic>();
    private final Map<ConfigResource, Map<String, String>> configs = new HashMap<ConfigResource, Map<String, String>>();

    public CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings, AclState aclState) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters, AclState aclState) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> addConfluentKeyValueStreamChangeRecord(OptionalLong deadlineNs, InternalTopicType recordType, String key, String value, short partitionId, long offset) {
        throw new UnsupportedOperationException();
    }

    private MockController(Collection<MockTopic> initialTopics, Iterator<KafkaPrincipal> expectedAlterConfigsPrincipals, Boolean expectedAlterBrokerReplicaExclusionSuccess) {
        for (MockTopic topic : initialTopics) {
            this.topics.put(topic.id, topic);
            this.topicNameToId.put(topic.name, topic.id);
        }
        this.expectedAlterConfigsPrincipals = expectedAlterConfigsPrincipals;
        this.expectedAlterBrokerReplicaExclusionSuccess = expectedAlterBrokerReplicaExclusionSuccess;
    }

    public CompletableFuture<MetadataResponseData.MetadataResponseBrokerCollection> unfencedBrokerEndpoints(ControllerRequestContext context, ListenerName listenerName) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AlterPartitionResponseData> alterPartition(ControllerRequestContext context, AlterPartitionRequestData request) {
        throw new UnsupportedOperationException();
    }

    private void maybeCheckAlterConfigsPrincipals(CompletableFuture<?> future, KafkaPrincipal principal) {
        if (this.expectedAlterConfigsPrincipals != null) {
            try {
                Assertions.assertEquals((Object)this.expectedAlterConfigsPrincipals.next(), (Object)principal);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        }
    }

    public CompletableFuture<AlterUserScramCredentialsResponseData> alterUserScramCredentials(ControllerRequestContext context, AlterUserScramCredentialsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CreateDelegationTokenResponseData> createDelegationToken(ControllerRequestContext context, CreateDelegationTokenRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<RenewDelegationTokenResponseData> renewDelegationToken(ControllerRequestContext context, RenewDelegationTokenRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ExpireDelegationTokenResponseData> expireDelegationToken(ControllerRequestContext context, ExpireDelegationTokenRequestData request) {
        throw new UnsupportedOperationException();
    }

    public synchronized CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext context, CreateTopicsRequestData request, Set<String> describable) {
        CreateTopicsResponseData response = new CreateTopicsResponseData();
        for (CreateTopicsRequestData.CreatableTopic topic : request.topics()) {
            if (this.topicNameToId.containsKey(topic.name())) {
                response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(Errors.TOPIC_ALREADY_EXISTS.code()));
                continue;
            }
            long topicId = this.nextTopicId.getAndIncrement();
            Uuid topicUuid = new Uuid(0L, topicId);
            MockTopic mockTopic = new MockTopic(topic.name(), topicUuid);
            CreateTopicsResponseData.CreatableTopicResult creatableTopicResult = new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(Errors.NONE.code());
            try {
                context.applyPartitionChangeQuota(mockTopic.numPartitions);
                creatableTopicResult.setTopicId(topicUuid);
                this.topicNameToId.put(topic.name(), topicUuid);
                this.topics.put(topicUuid, mockTopic);
                if (describable.contains(topic.name())) {
                    if (topic.assignments() != null && !topic.assignments().isEmpty()) {
                        creatableTopicResult.setTopicConfigErrorCode(Errors.NONE.code()).setReplicationFactor((short)((CreateTopicsRequestData.CreatableReplicaAssignment)topic.assignments().iterator().next()).brokerIds().size()).setNumPartitions(topic.assignments().size());
                    } else {
                        creatableTopicResult.setTopicConfigErrorCode(Errors.NONE.code()).setReplicationFactor(topic.replicationFactor()).setNumPartitions(topic.numPartitions());
                    }
                } else {
                    creatableTopicResult.setTopicConfigErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code());
                }
            }
            catch (ThrottlingQuotaExceededException e) {
                ApiError apiError = new ApiError(Errors.THROTTLING_QUOTA_EXCEEDED);
                creatableTopicResult.setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
            }
            response.topics().add((ImplicitLinkedHashCollection.Element)creatableTopicResult);
        }
        CompletableFuture<CreateTopicsResponseData> future = new CompletableFuture<CreateTopicsResponseData>();
        this.maybeCheckAlterConfigsPrincipals(future, context.principal());
        future.complete(response);
        return future;
    }

    public CompletableFuture<Void> unregisterBroker(ControllerRequestContext context, int brokerId) {
        throw new UnsupportedOperationException();
    }

    public synchronized CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(ControllerRequestContext context, Collection<String> topicNames) {
        HashMap<String, ResultOrError> results = new HashMap<String, ResultOrError>();
        for (String topicName : topicNames) {
            if (!this.topicNameToId.containsKey(topicName)) {
                results.put(topicName, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION)));
                continue;
            }
            results.put(topicName, new ResultOrError((Object)this.topicNameToId.get(topicName)));
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<String, Uuid>> findAllTopicIds(ControllerRequestContext context) {
        HashMap<String, Uuid> results = new HashMap<String, Uuid>();
        for (Map.Entry<Uuid, MockTopic> entry : this.topics.entrySet()) {
            results.put(entry.getValue().name, entry.getKey());
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(ControllerRequestContext context, Collection<Uuid> topicIds) {
        HashMap<Uuid, ResultOrError> results = new HashMap<Uuid, ResultOrError>();
        for (Uuid topicId : topicIds) {
            MockTopic topic = this.topics.get(topicId);
            if (topic == null) {
                results.put(topicId, new ResultOrError(new ApiError(Errors.UNKNOWN_TOPIC_ID)));
                continue;
            }
            results.put(topicId, new ResultOrError((Object)topic.name));
        }
        return CompletableFuture.completedFuture(results);
    }

    public synchronized CompletableFuture<Map<Uuid, ApiError>> deleteTopics(ControllerRequestContext context, Collection<Uuid> topicIds) {
        if (!this.active) {
            CompletableFuture<Map<Uuid, ApiError>> future = new CompletableFuture<Map<Uuid, ApiError>>();
            future.completeExceptionally((Throwable)NOT_CONTROLLER_EXCEPTION);
            return future;
        }
        HashMap<Uuid, ApiError> results = new HashMap<Uuid, ApiError>();
        for (Uuid topicId : topicIds) {
            MockTopic topic = this.topics.get(topicId);
            if (topic == null) {
                results.put(topicId, new ApiError(Errors.UNKNOWN_TOPIC_ID));
                continue;
            }
            try {
                context.applyPartitionChangeQuota(topic.numPartitions);
                this.topics.remove(topicId);
                this.topicNameToId.remove(topic.name);
                results.put(topicId, ApiError.NONE);
            }
            catch (ThrottlingQuotaExceededException e) {
                results.put(topicId, new ApiError(Errors.THROTTLING_QUOTA_EXCEEDED));
            }
        }
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(ControllerRequestContext context, Map<ConfigResource, Collection<String>> resources) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ElectLeadersResponseData> electLeaders(ControllerRequestContext context, ElectLeadersRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<FinalizedControllerFeatures> finalizedFeatures(ControllerRequestContext context) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CreateClusterLinksResponseData> createClusterLinks(ControllerRequestContext context, CreateClusterLinksRequestData request, KafkaPrincipal kafkaPrincipal) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DeleteClusterLinksResponseData> deleteClusterLinks(ControllerRequestContext context, DeleteClusterLinksRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AlterMirrorTopicsResponseData> alterMirrorTopic(ControllerRequestContext context, AlterMirrorTopicsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<AlterMirrorsResponseData.AlterMirrorResult>> alterMirrors(ControllerRequestContext context, List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DescribeCellsResponseData> describeCells(ControllerRequestContext context, DescribeCellsRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CreateCellResponseData> createCell(ControllerRequestContext context, CreateCellRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DeleteCellResponseData> deleteCell(ControllerRequestContext context, DeleteCellRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AlterCellResponseData> alterCell(ControllerRequestContext context, AlterCellRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AssignBrokersToCellResponseData> assignBrokersToCell(ControllerRequestContext context, AssignBrokersToCellRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<UnAssignBrokersFromCellResponseData> unassignBrokersFromCell(ControllerRequestContext context, UnAssignBrokersFromCellRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AssignTenantsToCellResponseData> assignTenantsToCells(ControllerRequestContext context, AssignTenantsToCellRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DescribeTenantsResponseData> describeTenants(ControllerRequestContext context, DescribeTenantsRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DeleteTenantsResponseData> deleteTenants(ControllerRequestContext context, DeleteTenantsRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AlterCellMigrationResponseData> alterCellMigration(ControllerRequestContext context, AlterCellMigrationRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DescribeCellMigrationResponseData> describeCellMigration(ControllerRequestContext context, DescribeCellMigrationRequest request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(ControllerRequestContext context, Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> configChanges, boolean validateOnly) {
        HashMap<ConfigResource, ApiError> results = new HashMap<ConfigResource, ApiError>();
        for (Map.Entry<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> entry : configChanges.entrySet()) {
            ConfigResource resource = entry.getKey();
            results.put(resource, this.incrementalAlterResource(resource, entry.getValue(), validateOnly));
        }
        CompletableFuture<Map<ConfigResource, ApiError>> future = new CompletableFuture<Map<ConfigResource, ApiError>>();
        this.maybeCheckAlterConfigsPrincipals(future, context.principal());
        future.complete(results);
        return future;
    }

    private ApiError incrementalAlterResource(ConfigResource resource, Map<String, Map.Entry<AlterConfigOp.OpType, String>> ops, boolean validateOnly) {
        for (Map.Entry<String, Map.Entry<AlterConfigOp.OpType, String>> entry : ops.entrySet()) {
            AlterConfigOp.OpType opType = entry.getValue().getKey();
            if (opType == AlterConfigOp.OpType.SET || opType == AlterConfigOp.OpType.DELETE) continue;
            return new ApiError(Errors.INVALID_REQUEST, "This mock does not support the " + String.valueOf(opType) + " config operation.");
        }
        if (!validateOnly) {
            for (Map.Entry<String, Map.Entry<AlterConfigOp.OpType, String>> entry : ops.entrySet()) {
                String key = entry.getKey();
                AlterConfigOp.OpType op = entry.getValue().getKey();
                String value = entry.getValue().getValue();
                switch (op) {
                    case SET: {
                        this.configs.computeIfAbsent(resource, __ -> new HashMap()).put(key, value);
                        break;
                    }
                    case DELETE: {
                        this.configs.getOrDefault(resource, Collections.emptyMap()).remove(key);
                        break;
                    }
                }
            }
        }
        return ApiError.NONE;
    }

    public CompletableFuture<AlterPartitionReassignmentsResponseData> alterPartitionReassignments(ControllerRequestContext context, AlterPartitionReassignmentsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ListPartitionReassignmentsResponseData> listPartitionReassignments(ControllerRequestContext context, ListPartitionReassignmentsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(ControllerRequestContext context, Map<ConfigResource, Map<String, String>> newConfigs, boolean validateOnly) {
        HashMap results = new HashMap();
        if (!validateOnly) {
            for (Map.Entry<ConfigResource, Map<String, String>> entry : newConfigs.entrySet()) {
                ConfigResource resource = entry.getKey();
                Map map = this.configs.computeIfAbsent(resource, __ -> new HashMap());
                map.clear();
                map.putAll(entry.getValue());
            }
        }
        CompletableFuture<Map<ConfigResource, ApiError>> future = new CompletableFuture<Map<ConfigResource, ApiError>>();
        this.maybeCheckAlterConfigsPrincipals(future, context.principal());
        future.complete(results);
        return future;
    }

    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(ControllerRequestContext context, BrokerHeartbeatRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<BrokerRegistrationReply> registerBroker(ControllerRequestContext context, BrokerRegistrationRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> waitForReadyBrokers(int minBrokers) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(ControllerRequestContext context, Collection<ClientQuotaAlteration> quotaAlterations, boolean validateOnly) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AlterReplicaExclusionsReply> alterBrokerReplicaExclusions(ControllerRequestContext context, AlterBrokerReplicaExclusionsRequestData request) {
        Set exclusions = request.brokersToExclude().stream().map(brokerExclusion -> new BrokerReplicaExclusionResult(brokerExclusion.brokerId(), this.expectedAlterBrokerReplicaExclusionSuccess != false ? Optional.empty() : Optional.of(ApiError.fromThrowable((Throwable)new InvalidBrokerReplicaExclusionException("mocked error"))), ExclusionOp.OpType.forId((byte)brokerExclusion.exclusionOperationCode()), brokerExclusion.reason())).collect(Collectors.toSet());
        return CompletableFuture.completedFuture(new AlterReplicaExclusionsReply(this.expectedAlterBrokerReplicaExclusionSuccess.booleanValue(), false, exclusions));
    }

    public CompletableFuture<Map<Integer, String>> describeBrokerReplicaExclusions(ControllerRequestContext context) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AlterBrokerHealthResponseData> alterBrokerHealth(ControllerRequestContext context, AlterBrokerHealthRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DescribeBrokerHealthResponseData> describeBrokerHealth(ControllerRequestContext context) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<AllocateProducerIdsResponseData> allocateProducerIds(ControllerRequestContext context, AllocateProducerIdsRequestData request) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<UpdateFeaturesResponseData> updateFeatures(ControllerRequestContext context, UpdateFeaturesRequestData request) {
        throw new UnsupportedOperationException();
    }

    public synchronized CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext context, List<CreatePartitionsRequestData.CreatePartitionsTopic> topicList, boolean validateOnly) {
        if (!this.active) {
            CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> future = new CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>>();
            future.completeExceptionally((Throwable)NOT_CONTROLLER_EXCEPTION);
            return future;
        }
        ArrayList<CreatePartitionsResponseData.CreatePartitionsTopicResult> results = new ArrayList<CreatePartitionsResponseData.CreatePartitionsTopicResult>();
        for (CreatePartitionsRequestData.CreatePartitionsTopic topic : topicList) {
            if (this.topicNameToId.containsKey(topic.name())) {
                try {
                    context.applyPartitionChangeQuota(topic.count());
                    results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(Errors.NONE.code()).setErrorMessage(null));
                }
                catch (ThrottlingQuotaExceededException e) {
                    ApiError apiError = new ApiError(Errors.THROTTLING_QUOTA_EXCEEDED);
                    results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
                }
                continue;
            }
            results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage("No such topic as " + topic.name()));
        }
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<Void> registerController(ControllerRequestContext context, ControllerRegistrationRequestData request) {
        throw new UnsupportedOperationException();
    }

    public void beginShutdown() {
        this.active = false;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int curClaimEpoch() {
        return this.active ? 1 : -1;
    }

    public void close() {
        this.beginShutdown();
    }

    public CompletableFuture<AssignReplicasToDirsResponseData> assignReplicasToDirs(ControllerRequestContext context, AssignReplicasToDirsRequestData request) {
        throw new UnsupportedOperationException("not implemented");
    }

    static class MockTopic {
        private final String name;
        private final Uuid id;
        private final int numPartitions;

        MockTopic(String name, Uuid id) {
            this(name, id, 1);
        }

        MockTopic(String name, Uuid id, int numPartitions) {
            this.name = name;
            this.id = id;
            this.numPartitions = numPartitions;
        }
    }

    public static class Builder {
        private final Map<String, MockTopic> initialTopics = new HashMap<String, MockTopic>();
        private Iterator<KafkaPrincipal> expectedAlterConfigsPrincipals = null;
        private boolean expectedAlterBrokerReplicaExclusionSuccess = true;

        public Builder newInitialTopic(String name, Uuid id) {
            this.initialTopics.put(name, new MockTopic(name, id));
            return this;
        }

        public Builder newInitialTopic(String name, Uuid id, int numPartitions) {
            this.initialTopics.put(name, new MockTopic(name, id, numPartitions));
            return this;
        }

        public Builder setExpectedAlterConfigsPrincipals(Iterator<KafkaPrincipal> expectedAlterConfigsPrincipals) {
            this.expectedAlterConfigsPrincipals = expectedAlterConfigsPrincipals;
            return this;
        }

        public Builder setExpectedAlterExclusionResultSuccess(Boolean isSuccessful) {
            this.expectedAlterBrokerReplicaExclusionSuccess = isSuccessful;
            return this;
        }

        public MockController build() {
            return new MockController(this.initialTopics.values(), this.expectedAlterConfigsPrincipals, this.expectedAlterBrokerReplicaExclusionSuccess);
        }
    }
}

