/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test.junit;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.test.api.AutoStart;
import org.apache.kafka.common.test.api.ClusterConfig;
import org.apache.kafka.common.test.api.ClusterConfigBrokerProperty;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterFeature;
import org.apache.kafka.common.test.api.ClusterTemplate;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.ClusterTests;
import org.apache.kafka.common.test.api.DetectThreadLeak;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.server.common.Feature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.ReflectionUtils;

public class ClusterTestExtensions
implements TestTemplateInvocationContextProvider,
BeforeEachCallback,
AfterEachCallback {
    private static final String METRICS_METER_TICK_THREAD_PREFIX = "metrics-meter-tick-thread";
    private static final String SCALA_THREAD_PREFIX = "scala-";
    private static final String FORK_JOIN_POOL_THREAD_PREFIX = "ForkJoinPool";
    private static final String JUNIT_THREAD_PREFIX = "junit-";
    private static final String ATTACH_LISTENER_THREAD_PREFIX = "Attach Listener";
    private static final String PROCESS_REAPER_THREAD_PREFIX = "process reaper";
    private static final String RMI_THREAD_PREFIX = "RMI";
    private static final String DETECT_THREAD_LEAK_KEY = "detectThreadLeak";
    private static final Set<String> SKIPPED_THREAD_PREFIX = Set.of("metrics-meter-tick-thread", "scala-", "ForkJoinPool", "junit-", "Attach Listener", "process reaper", "RMI", "executor-");

    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    private boolean isClusterTest(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        return method.getDeclaredAnnotation(ClusterTemplate.class) != null || method.getDeclaredAnnotation(ClusterTest.class) != null || method.getDeclaredAnnotation(ClusterTests.class) != null;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        ClusterTests clusterTestsAnnot;
        ClusterTest clusterTestAnnot;
        ClusterTestDefaults defaults = this.getClusterTestDefaults(context.getRequiredTestClass());
        ArrayList<TestTemplateInvocationContext> generatedContexts = new ArrayList<TestTemplateInvocationContext>();
        ClusterTemplate clusterTemplateAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTemplate.class);
        if (clusterTemplateAnnot != null) {
            generatedContexts.addAll(this.processClusterTemplate(context, clusterTemplateAnnot));
        }
        if ((clusterTestAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTest.class)) != null) {
            generatedContexts.addAll(this.processClusterTest(context, clusterTestAnnot, defaults));
        }
        if ((clusterTestsAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTests.class)) != null) {
            generatedContexts.addAll(this.processClusterTests(context, clusterTestsAnnot, defaults));
        }
        return generatedContexts.stream();
    }

    public void beforeEach(ExtensionContext context) {
        if (this.isClusterTest(context)) {
            DetectThreadLeak detectThreadLeak = DetectThreadLeak.of(thread -> SKIPPED_THREAD_PREFIX.stream().noneMatch(prefix -> thread.getName().startsWith((String)prefix)));
            this.getStore(context).put((Object)DETECT_THREAD_LEAK_KEY, (Object)detectThreadLeak);
        }
    }

    public void afterEach(ExtensionContext context) {
        if (this.isClusterTest(context)) {
            DetectThreadLeak detectThreadLeak = (DetectThreadLeak)this.getStore(context).remove((Object)DETECT_THREAD_LEAK_KEY, DetectThreadLeak.class);
            if (detectThreadLeak == null) {
                return;
            }
            List threads = detectThreadLeak.newThreads();
            Assertions.assertTrue((boolean)threads.isEmpty(), (String)("Thread leak detected: " + threads.stream().map(Thread::getName).collect(Collectors.joining(", "))));
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{context.getUniqueId()}));
    }

    private TestTemplateInvocationContext invocationContextForClusterType(Type type, String baseDisplayName, ClusterConfig config) {
        switch (type) {
            case KRAFT: {
                return new RaftClusterInvocationContext(baseDisplayName, config, false);
            }
            case CO_KRAFT: {
                return new RaftClusterInvocationContext(baseDisplayName, config, true);
            }
            case ALL_NON_CORESIDENT: {
                return new RaftClusterInvocationContext(baseDisplayName, config.copyOf(), false);
            }
        }
        throw new IllegalArgumentException("Unsupported @Type value " + String.valueOf(type));
    }

    List<TestTemplateInvocationContext> processClusterTemplate(ExtensionContext context, ClusterTemplate annot) {
        if (annot.value().trim().isEmpty()) {
            throw new IllegalStateException("ClusterTemplate value can't be empty string.");
        }
        String baseDisplayName = context.getRequiredTestMethod().getName();
        List<TestTemplateInvocationContext> contexts = this.generateClusterConfigurations(context, annot.value()).stream().flatMap(config -> config.clusterTypes().stream().map(type -> this.invocationContextForClusterType((Type)type, baseDisplayName, (ClusterConfig)config))).collect(Collectors.toList());
        if (contexts.isEmpty()) {
            throw new IllegalStateException("ClusterConfig generator method should provide at least one config");
        }
        return contexts;
    }

    private List<ClusterConfig> generateClusterConfigurations(ExtensionContext context, String generateClustersMethods) {
        Object testInstance = context.getTestInstance().orElse(null);
        Method method = ReflectionUtils.getRequiredMethod((Class)context.getRequiredTestClass(), (String)generateClustersMethods, (Class[])new Class[0]);
        return (List)ReflectionUtils.invokeMethod((Method)method, testInstance, (Object[])new Object[0]);
    }

    private List<TestTemplateInvocationContext> processClusterTests(ExtensionContext context, ClusterTests annots, ClusterTestDefaults defaults) {
        List<TestTemplateInvocationContext> ret = Arrays.stream(annots.value()).flatMap(annot -> this.processClusterTestInternal(context, (ClusterTest)annot, defaults).stream()).collect(Collectors.toList());
        if (ret.isEmpty()) {
            throw new IllegalStateException("processClusterTests method should provide at least one config");
        }
        return ret;
    }

    private List<TestTemplateInvocationContext> processClusterTest(ExtensionContext context, ClusterTest annot, ClusterTestDefaults defaults) {
        List<TestTemplateInvocationContext> ret = this.processClusterTestInternal(context, annot, defaults);
        if (ret.isEmpty()) {
            throw new IllegalStateException("processClusterTest method should provide at least one config");
        }
        return ret;
    }

    private List<TestTemplateInvocationContext> processClusterTestInternal(ExtensionContext context, ClusterTest annot, ClusterTestDefaults defaults) {
        Type[] types = annot.types().length == 0 ? defaults.types() : annot.types();
        Map<String, String> serverProperties = Stream.concat(Arrays.stream(defaults.serverProperties()), Arrays.stream(annot.serverProperties())).filter(e -> e.id() == -1).collect(Collectors.toMap(ClusterConfigProperty::key, ClusterConfigProperty::value, (a, b) -> b));
        Map<Integer, Map<String, String>> perServerProperties = Stream.concat(Arrays.stream(defaults.serverProperties()), Arrays.stream(annot.serverProperties())).filter(e -> e.id() != -1).collect(Collectors.groupingBy(ClusterConfigProperty::id, Collectors.mapping(Function.identity(), Collectors.toMap(ClusterConfigProperty::key, ClusterConfigProperty::value, (a, b) -> b))));
        for (ClusterConfigBrokerProperty property : defaults.perBrokerOverrides()) {
            perServerProperties.put(property.brokerId(), Arrays.stream(property.perBrokerOverrides()).map(prop -> new AbstractMap.SimpleEntry<String, String>(prop.key(), prop.value())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        for (ClusterConfigBrokerProperty property : annot.perBrokerOverrides()) {
            perServerProperties.put(property.brokerId(), Arrays.stream(property.perBrokerOverrides()).map(prop -> new AbstractMap.SimpleEntry<String, String>(prop.key(), prop.value())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        Map<Feature, Short> features = Arrays.stream(annot.features()).collect(Collectors.toMap(ClusterFeature::feature, ClusterFeature::version));
        ClusterConfig config = ClusterConfig.builder().setTypes(new HashSet<Type>(Arrays.asList(types))).setBrokers(annot.brokers() == 0 ? defaults.brokers() : annot.brokers()).setControllers(annot.controllers() == 0 ? defaults.controllers() : annot.controllers()).setDisksPerBroker(annot.disksPerBroker() == 0 ? defaults.disksPerBroker() : annot.disksPerBroker()).setAutoStart(annot.autoStart() == AutoStart.DEFAULT ? defaults.autoStart() : annot.autoStart() == AutoStart.YES).setBrokerListenerName(ListenerName.normalised((String)annot.brokerListener())).setBrokerSecurityProtocol(annot.brokerSecurityProtocol()).setControllerListenerName(ListenerName.normalised((String)annot.controllerListener())).setControllerSecurityProtocol(annot.controllerSecurityProtocol()).setServerProperties(serverProperties).setPerServerProperties(perServerProperties).setMetadataVersion(annot.metadataVersion()).setTags(Arrays.asList(annot.tags())).setFeatures(features).build();
        return Arrays.stream(types).map(type -> this.invocationContextForClusterType((Type)type, context.getRequiredTestMethod().getName(), config)).collect(Collectors.toList());
    }

    private ClusterTestDefaults getClusterTestDefaults(Class<?> testClass) {
        return Optional.ofNullable(testClass.getDeclaredAnnotation(ClusterTestDefaults.class)).orElseGet(() -> EmptyClass.class.getDeclaredAnnotation(ClusterTestDefaults.class));
    }

    @ClusterTestDefaults
    private static final class EmptyClass {
        private EmptyClass() {
        }
    }
}

