/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.replica.ReplicaStatus;

@InterfaceStability.Evolving
@Confluent
public class PartitionResult {
    private final int leaderId;
    private final int leaderEpoch;
    private final List<ReplicaStatus> replicas;

    public PartitionResult(List<ReplicaStatus> replicas) {
        this(-1, -1, replicas);
    }

    public PartitionResult(ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse) {
        this(PartitionResult.toLeaderId(partitionResponse), partitionResponse.leaderEpoch(), PartitionResult.toReplicaStatusList(partitionResponse));
    }

    public PartitionResult(int leaderId, int leaderEpoch, List<ReplicaStatus> replicas) {
        this.leaderId = leaderId;
        this.replicas = replicas;
        this.leaderEpoch = leaderEpoch;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public OptionalInt leaderEpoch() {
        if (this.leaderEpoch < 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.leaderEpoch);
    }

    public List<ReplicaStatus> replicas() {
        return this.replicas;
    }

    private static int toLeaderId(ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse) {
        int leaderId = partitionResponse.leaderId();
        if (leaderId == -1) {
            for (ReplicaStatusResponseData.ReplicaStatusReplicaResponse response : partitionResponse.replicas()) {
                if (!response.isLeader()) continue;
                leaderId = response.id();
                break;
            }
        }
        return leaderId;
    }

    private static List<ReplicaStatus> toReplicaStatusList(ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse) {
        ArrayList<ReplicaStatus> replicas = new ArrayList<ReplicaStatus>(partitionResponse.replicas().size());
        for (ReplicaStatusResponseData.ReplicaStatusReplicaResponse replicaResponse : partitionResponse.replicas()) {
            Optional<ReplicaStatus.MirrorInfo> mirrorInfo = Optional.empty();
            if (replicaResponse.mirrorState() != null) {
                mirrorInfo = Optional.of(new ReplicaStatus.MirrorInfo(PartitionResult.toMirrorState(replicaResponse.mirrorState()), replicaResponse.mirrorLastFetchTimeMs(), replicaResponse.mirrorLastFetchSourceHighWatermark()));
            }
            replicas.add(new ReplicaStatus(replicaResponse.id(), replicaResponse.isLeader(), replicaResponse.isObserver(), replicaResponse.isIsrEligible(), replicaResponse.isInIsr(), replicaResponse.isCaughtUp(), replicaResponse.logStartOffset(), replicaResponse.logEndOffset(), replicaResponse.lastCaughtUpTimeMs(), replicaResponse.lastFetchTimeMs(), Optional.ofNullable(replicaResponse.linkName()), mirrorInfo, Optional.ofNullable(replicaResponse.replicationMode()), OptionalLong.of(replicaResponse.replicationSessionId())));
        }
        return replicas;
    }

    private static ReplicaStatus.MirrorInfo.State toMirrorState(String state) {
        try {
            return ReplicaStatus.MirrorInfo.State.valueOf(state);
        }
        catch (IllegalArgumentException e) {
            return ReplicaStatus.MirrorInfo.State.UNKNOWN;
        }
    }
}

