/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.SendBuilder;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddRaftVoterRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.AlterCellMigrationRequest;
import org.apache.kafka.common.requests.AlterCellRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.AppendRecordsRequest;
import org.apache.kafka.common.requests.AssignBrokersToCellRequest;
import org.apache.kafka.common.requests.AssignReplicasToDirsRequest;
import org.apache.kafka.common.requests.AssignTenantsToCellRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ControllerRegistrationRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateCellRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteCellRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteShareGroupStateRequest;
import org.apache.kafka.common.requests.DeleteTenantsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeBalancerStatusRequest;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsRequest;
import org.apache.kafka.common.requests.DescribeBrokerHealthRequest;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsRequest;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.DescribeCellLoadRequest;
import org.apache.kafka.common.requests.DescribeCellMigrationRequest;
import org.apache.kafka.common.requests.DescribeCellsRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeMirrorsRequest;
import org.apache.kafka.common.requests.DescribeNetworkRequest;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.DescribeSwitchoverStatusRequest;
import org.apache.kafka.common.requests.DescribeTenantsRequest;
import org.apache.kafka.common.requests.DescribeTopicPartitionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DrainCellRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitializeShareGroupStateRequest;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.InitiateShutdownRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListClientMetricsResourcesRequest;
import org.apache.kafka.common.requests.ListClusterLinksRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListMirrorsRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.requests.PushTelemetryRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RemoveRaftVoterRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.ReplicaStatusRequest;
import org.apache.kafka.common.requests.ReportClusterLinkStatusRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.ResolveOffsetRangeRequest;
import org.apache.kafka.common.requests.ReverseConnectionRequest;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareGroupDescribeRequest;
import org.apache.kafka.common.requests.ShareGroupHeartbeatRequest;
import org.apache.kafka.common.requests.StreamsGroupDescribeRequest;
import org.apache.kafka.common.requests.StreamsGroupHeartbeatRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellRequest;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateRaftVoterRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.WriteShareGroupStateRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;

public abstract class AbstractRequest
implements AbstractRequestResponse {
    private final short version;
    private final ApiKeys apiKey;

    public AbstractRequest(ApiKeys apiKey, short version) {
        if (!apiKey.isVersionSupported(version)) {
            throw new UnsupportedVersionException("The " + String.valueOf((Object)apiKey) + " protocol does not support version " + version);
        }
        this.version = version;
        this.apiKey = apiKey;
    }

    public short version() {
        return this.version;
    }

    public ApiKeys apiKey() {
        return this.apiKey;
    }

    public final Send toSend(RequestHeader header) {
        return SendBuilder.buildRequestSend(header, this.data());
    }

    public final Send toSend(RequestHeader header, MessageContext context) {
        return SendBuilder.buildRequestSend(header, this.data(), context);
    }

    public final ByteBuffer serializeWithHeader(RequestHeader header) {
        if (header.apiKey() != this.apiKey) {
            throw new IllegalArgumentException("Could not build request " + String.valueOf((Object)this.apiKey) + " with header api key " + String.valueOf((Object)header.apiKey()));
        }
        if (header.apiVersion() != this.version) {
            throw new IllegalArgumentException("Could not build request version " + this.version + " with header version " + header.apiVersion());
        }
        return RequestUtils.serialize(header.data(), header.headerVersion(), this.data(), this.version);
    }

    public final ByteBufferAccessor serialize() {
        return MessageUtil.toByteBufferAccessor(this.data(), this.version);
    }

    final int sizeInBytes() {
        return this.data().size(new ObjectSerializationCache(), this.version);
    }

    public String toString(boolean verbose) {
        return this.data().toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public AbstractResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public abstract AbstractResponse getErrorResponse(int var1, Throwable var2);

    public Map<Errors, Integer> errorCounts(Throwable e) {
        AbstractResponse response = this.getErrorResponse(0, e);
        if (response == null) {
            throw new IllegalStateException("Error counts could not be obtained for request " + String.valueOf(this));
        }
        return response.errorCounts();
    }

    public static RequestAndSize parseRequest(ApiKeys apiKey, short apiVersion, Readable readable, MessageContext context) {
        int bufferSize = readable.remaining();
        return new RequestAndSize(AbstractRequest.doParseRequest(apiKey, apiVersion, readable, context), bufferSize);
    }

    private static AbstractRequest doParseRequest(ApiKeys apiKey, short apiVersion, Readable readable, MessageContext context) {
        switch (apiKey) {
            case PRODUCE: {
                return ProduceRequest.parse(readable, apiVersion, context);
            }
            case FETCH: {
                return FetchRequest.parse(readable, apiVersion, context);
            }
            case LIST_OFFSETS: {
                return ListOffsetsRequest.parse(readable, apiVersion, context);
            }
            case METADATA: {
                return MetadataRequest.parse(readable, apiVersion, context);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(readable, apiVersion, context);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(readable, apiVersion, context);
            }
            case FIND_COORDINATOR: {
                return FindCoordinatorRequest.parse(readable, apiVersion, context);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(readable, apiVersion, context);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(readable, apiVersion, context);
            }
            case LEAVE_GROUP: {
                return LeaveGroupRequest.parse(readable, apiVersion, context);
            }
            case SYNC_GROUP: {
                return SyncGroupRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsRequest.parse(readable, apiVersion, context);
            }
            case LIST_GROUPS: {
                return ListGroupsRequest.parse(readable, apiVersion, context);
            }
            case SASL_HANDSHAKE: {
                return SaslHandshakeRequest.parse(readable, apiVersion, context);
            }
            case API_VERSIONS: {
                return ApiVersionsRequest.parse(readable, apiVersion, context);
            }
            case CREATE_TOPICS: {
                return CreateTopicsRequest.parse(readable, apiVersion, context);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsRequest.parse(readable, apiVersion, context);
            }
            case DELETE_RECORDS: {
                return DeleteRecordsRequest.parse(readable, apiVersion, context);
            }
            case INIT_PRODUCER_ID: {
                return InitProducerIdRequest.parse(readable, apiVersion, context);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return OffsetsForLeaderEpochRequest.parse(readable, apiVersion, context);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return AddPartitionsToTxnRequest.parse(readable, apiVersion, context);
            }
            case ADD_OFFSETS_TO_TXN: {
                return AddOffsetsToTxnRequest.parse(readable, apiVersion, context);
            }
            case END_TXN: {
                return EndTxnRequest.parse(readable, apiVersion, context);
            }
            case WRITE_TXN_MARKERS: {
                return WriteTxnMarkersRequest.parse(readable, apiVersion, context);
            }
            case TXN_OFFSET_COMMIT: {
                return TxnOffsetCommitRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_ACLS: {
                return DescribeAclsRequest.parse(readable, apiVersion, context);
            }
            case CREATE_ACLS: {
                return CreateAclsRequest.parse(readable, apiVersion, context);
            }
            case DELETE_ACLS: {
                return DeleteAclsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_CONFIGS: {
                return DescribeConfigsRequest.parse(readable, apiVersion, context);
            }
            case ALTER_CONFIGS: {
                return AlterConfigsRequest.parse(readable, apiVersion, context);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return AlterReplicaLogDirsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_LOG_DIRS: {
                return DescribeLogDirsRequest.parse(readable, apiVersion, context);
            }
            case SASL_AUTHENTICATE: {
                return SaslAuthenticateRequest.parse(readable, apiVersion, context);
            }
            case CREATE_PARTITIONS: {
                return CreatePartitionsRequest.parse(readable, apiVersion, context);
            }
            case CREATE_DELEGATION_TOKEN: {
                return CreateDelegationTokenRequest.parse(readable, apiVersion, context);
            }
            case RENEW_DELEGATION_TOKEN: {
                return RenewDelegationTokenRequest.parse(readable, apiVersion, context);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return ExpireDelegationTokenRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return DescribeDelegationTokenRequest.parse(readable, apiVersion, context);
            }
            case DELETE_GROUPS: {
                return DeleteGroupsRequest.parse(readable, apiVersion, context);
            }
            case ELECT_LEADERS: {
                return ElectLeadersRequest.parse(readable, apiVersion, context);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return IncrementalAlterConfigsRequest.parse(readable, apiVersion, context);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return AlterPartitionReassignmentsRequest.parse(readable, apiVersion, context);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return ListPartitionReassignmentsRequest.parse(readable, apiVersion, context);
            }
            case OFFSET_DELETE: {
                return OffsetDeleteRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return DescribeClientQuotasRequest.parse(readable, apiVersion, context);
            }
            case ALTER_CLIENT_QUOTAS: {
                return AlterClientQuotasRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return DescribeUserScramCredentialsRequest.parse(readable, apiVersion, context);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return AlterUserScramCredentialsRequest.parse(readable, apiVersion, context);
            }
            case VOTE: {
                return VoteRequest.parse(readable, apiVersion, context);
            }
            case BEGIN_QUORUM_EPOCH: {
                return BeginQuorumEpochRequest.parse(readable, apiVersion, context);
            }
            case END_QUORUM_EPOCH: {
                return EndQuorumEpochRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_QUORUM: {
                return DescribeQuorumRequest.parse(readable, apiVersion, context);
            }
            case ALTER_PARTITION: {
                return AlterPartitionRequest.parse(readable, apiVersion, context);
            }
            case UPDATE_FEATURES: {
                return UpdateFeaturesRequest.parse(readable, apiVersion, context);
            }
            case ENVELOPE: {
                return EnvelopeRequest.parse(readable, apiVersion, context);
            }
            case FETCH_SNAPSHOT: {
                return FetchSnapshotRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_CLUSTER: {
                return DescribeClusterRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_PRODUCERS: {
                return DescribeProducersRequest.parse(readable, apiVersion, context);
            }
            case BROKER_REGISTRATION: {
                return BrokerRegistrationRequest.parse(readable, apiVersion, context);
            }
            case BROKER_HEARTBEAT: {
                return BrokerHeartbeatRequest.parse(readable, apiVersion, context);
            }
            case UNREGISTER_BROKER: {
                return UnregisterBrokerRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_TRANSACTIONS: {
                return DescribeTransactionsRequest.parse(readable, apiVersion, context);
            }
            case LIST_TRANSACTIONS: {
                return ListTransactionsRequest.parse(readable, apiVersion, context);
            }
            case ALLOCATE_PRODUCER_IDS: {
                return AllocateProducerIdsRequest.parse(readable, apiVersion, context);
            }
            case CONSUMER_GROUP_HEARTBEAT: {
                return ConsumerGroupHeartbeatRequest.parse(readable, apiVersion, context);
            }
            case CONSUMER_GROUP_DESCRIBE: {
                return ConsumerGroupDescribeRequest.parse(readable, apiVersion, context);
            }
            case CONTROLLER_REGISTRATION: {
                return ControllerRegistrationRequest.parse(readable, apiVersion, context);
            }
            case GET_TELEMETRY_SUBSCRIPTIONS: {
                return GetTelemetrySubscriptionsRequest.parse(readable, apiVersion, context);
            }
            case PUSH_TELEMETRY: {
                return PushTelemetryRequest.parse(readable, apiVersion, context);
            }
            case ASSIGN_REPLICAS_TO_DIRS: {
                return AssignReplicasToDirsRequest.parse(readable, apiVersion, context);
            }
            case LIST_CLIENT_METRICS_RESOURCES: {
                return ListClientMetricsResourcesRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_TOPIC_PARTITIONS: {
                return DescribeTopicPartitionsRequest.parse(readable, apiVersion, context);
            }
            case SHARE_GROUP_HEARTBEAT: {
                return ShareGroupHeartbeatRequest.parse(readable, apiVersion, context);
            }
            case SHARE_GROUP_DESCRIBE: {
                return ShareGroupDescribeRequest.parse(readable, apiVersion, context);
            }
            case SHARE_FETCH: {
                return ShareFetchRequest.parse(readable, apiVersion, context);
            }
            case SHARE_ACKNOWLEDGE: {
                return ShareAcknowledgeRequest.parse(readable, apiVersion, context);
            }
            case ADD_RAFT_VOTER: {
                return AddRaftVoterRequest.parse(readable, apiVersion, context);
            }
            case REMOVE_RAFT_VOTER: {
                return RemoveRaftVoterRequest.parse(readable, apiVersion, context);
            }
            case UPDATE_RAFT_VOTER: {
                return UpdateRaftVoterRequest.parse(readable, apiVersion, context);
            }
            case INITIALIZE_SHARE_GROUP_STATE: {
                return InitializeShareGroupStateRequest.parse(readable, apiVersion, context);
            }
            case READ_SHARE_GROUP_STATE: {
                return ReadShareGroupStateRequest.parse(readable, apiVersion, context);
            }
            case WRITE_SHARE_GROUP_STATE: {
                return WriteShareGroupStateRequest.parse(readable, apiVersion, context);
            }
            case DELETE_SHARE_GROUP_STATE: {
                return DeleteShareGroupStateRequest.parse(readable, apiVersion, context);
            }
            case READ_SHARE_GROUP_STATE_SUMMARY: {
                return ReadShareGroupStateSummaryRequest.parse(readable, apiVersion, context);
            }
            case REPORT_CLUSTER_LINK_STATUS: {
                return ReportClusterLinkStatusRequest.parse(readable, apiVersion, context);
            }
            case STREAMS_GROUP_HEARTBEAT: {
                return StreamsGroupHeartbeatRequest.parse(readable, apiVersion, context);
            }
            case STREAMS_GROUP_DESCRIBE: {
                return StreamsGroupDescribeRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_SHARE_GROUP_OFFSETS: {
                return DescribeShareGroupOffsetsRequest.parse(readable, apiVersion, context);
            }
        }
        return AbstractRequest.maybeParseInternalRequest(apiKey, apiVersion, readable, context);
    }

    private static AbstractRequest maybeParseInternalRequest(ApiKeys apiKey, short apiVersion, Readable readable, MessageContext context) {
        switch (apiKey) {
            case REMOVE_BROKERS: {
                return RemoveBrokersRequest.parse(readable, apiVersion, context);
            }
            case INITIATE_SHUTDOWN: {
                return InitiateShutdownRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_BROKER_REMOVALS: {
                return DescribeBrokerRemovalsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_BROKER_ADDITIONS: {
                return DescribeBrokerAdditionsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_BALANCER_STATUS: {
                return DescribeBalancerStatusRequest.parse(readable, apiVersion, context);
            }
            case REPLICA_STATUS: {
                return ReplicaStatusRequest.parse(readable, apiVersion, context);
            }
            case CREATE_CLUSTER_LINKS: {
                return CreateClusterLinksRequest.parse(readable, apiVersion, context);
            }
            case LIST_CLUSTER_LINKS: {
                return ListClusterLinksRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_CLUSTER_LINKS: {
                return DescribeClusterLinksRequest.parse(readable, apiVersion, context);
            }
            case DELETE_CLUSTER_LINKS: {
                return DeleteClusterLinksRequest.parse(readable, apiVersion, context);
            }
            case ALTER_MIRRORS: {
                return AlterMirrorsRequest.parse(readable, apiVersion, context);
            }
            case LIST_MIRRORS: {
                return ListMirrorsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_MIRRORS: {
                return DescribeMirrorsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_SWITCHOVER_STATUS: {
                return DescribeSwitchoverStatusRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_EVEN_CLUSTER_LOAD_STATUS: {
                return DescribeEvenClusterLoadStatusRequest.parse(readable, apiVersion, context);
            }
            case INITIATE_REVERSE_CONNECTIONS: {
                return InitiateReverseConnectionsRequest.parse(readable, apiVersion, context);
            }
            case REVERSE_CONNECTION: {
                return ReverseConnectionRequest.parse(readable, apiVersion, context);
            }
            case ALTER_BROKER_HEALTH: {
                return AlterBrokerHealthRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_BROKER_HEALTH: {
                return DescribeBrokerHealthRequest.parse(readable, apiVersion, context);
            }
            case ALTER_BROKER_REPLICA_EXCLUSIONS: {
                return AlterBrokerReplicaExclusionsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_BROKER_REPLICA_EXCLUSIONS: {
                return DescribeBrokerReplicaExclusionsRequest.parse(readable, apiVersion, context);
            }
            case REPORT_QUOTA_CONSUMPTION: {
                return ReportQuotaConsumptionRequest.parse(readable, apiVersion, context);
            }
            case PUBLISH_QUOTA_TARGET: {
                return PublishQuotaTargetRequest.parse(readable, apiVersion, context);
            }
            case TRIGGER_EVEN_CLUSTER_LOAD: {
                return TriggerEvenClusterLoadRequest.parse(readable, apiVersion, context);
            }
            case COMPUTE_EVEN_CLUSTER_LOAD_PLAN: {
                return ComputeEvenClusterLoadPlanRequest.parse(readable, apiVersion, context);
            }
            case ALTER_MIRROR_TOPICS: {
                return AlterMirrorTopicsRequest.parse(readable, apiVersion, context);
            }
            case CREATE_CELL: {
                return CreateCellRequest.parse(readable, apiVersion, context);
            }
            case DRAIN_CELL: {
                return DrainCellRequest.parse(readable, apiVersion, context);
            }
            case DELETE_CELL: {
                return DeleteCellRequest.parse(readable, apiVersion, context);
            }
            case ALTER_CELL: {
                return AlterCellRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_CELLS: {
                return DescribeCellsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_TENANTS: {
                return DescribeTenantsRequest.parse(readable, apiVersion, context);
            }
            case ASSIGN_TENANTS_TO_CELL: {
                return AssignTenantsToCellRequest.parse(readable, apiVersion, context);
            }
            case ASSIGN_BROKERS_TO_CELL: {
                return AssignBrokersToCellRequest.parse(readable, apiVersion, context);
            }
            case UN_ASSIGN_BROKERS_FROM_CELL: {
                return UnAssignBrokersFromCellRequest.parse(readable, apiVersion, context);
            }
            case DELETE_TENANTS: {
                return DeleteTenantsRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_CELL_LOAD: {
                return DescribeCellLoadRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_NETWORK: {
                return DescribeNetworkRequest.parse(readable, apiVersion, context);
            }
            case APPEND_RECORDS: {
                return AppendRecordsRequest.parse(readable, apiVersion, context);
            }
            case ALTER_CELL_MIGRATION: {
                return AlterCellMigrationRequest.parse(readable, apiVersion, context);
            }
            case DESCRIBE_CELL_MIGRATION: {
                return DescribeCellMigrationRequest.parse(readable, apiVersion, context);
            }
            case RESOLVE_OFFSET_RANGE: {
                return ResolveOffsetRangeRequest.parse(readable, apiVersion, context);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseRequest`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public static abstract class Builder<T extends AbstractRequest> {
        private final ApiKeys apiKey;
        private final short oldestAllowedVersion;
        private final short latestAllowedVersion;
        private boolean peerIsConfluent = false;

        public Builder(ApiKeys apiKey, boolean enableUnstableLastVersion) {
            this(apiKey, apiKey.oldestVersion(), apiKey.latestVersion(enableUnstableLastVersion));
        }

        public Builder(ApiKeys apiKey) {
            this(apiKey, false);
        }

        public Builder(ApiKeys apiKey, short allowedVersion) {
            this(apiKey, allowedVersion, allowedVersion);
        }

        public Builder(ApiKeys apiKey, short oldestAllowedVersion, short latestAllowedVersion) {
            this.apiKey = apiKey;
            this.oldestAllowedVersion = oldestAllowedVersion;
            this.latestAllowedVersion = latestAllowedVersion;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public short oldestAllowedVersion() {
            return this.oldestAllowedVersion;
        }

        public short latestAllowedVersion() {
            return this.latestAllowedVersion;
        }

        public void setPeerIsConfluent(boolean peerIsConfluent) {
            this.peerIsConfluent = peerIsConfluent;
        }

        public boolean peerIsConfluent() {
            return this.peerIsConfluent;
        }

        public T build() {
            return this.build(this.latestAllowedVersion());
        }

        public abstract T build(short var1);
    }
}

