/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security;

import io.confluent.kafkarest.KafkaRestContext;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import java.util.Objects;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.Producer;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;

public final class KafkaRestSecurityModule
extends AbstractBinder {
    public static final String KAFKA_REST_CONTEXT_PROPERTY_NAME = "io.confluent.kafkarest.security.KafkaRestSecurityModule.KafkaRestContext";

    protected void configure() {
        this.bindFactory(KafkaRestContextFactory.class).to(KafkaRestContext.class).in(RequestScoped.class).ranked(1);
        this.bindFactory(AdminFactory.class).to(Admin.class).in(RequestScoped.class).ranked(1);
        this.bindFactory(ProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(RequestScoped.class).ranked(1);
    }

    private static final class KafkaRestContextFactory
    implements Factory<KafkaRestContext> {
        private final Provider<ContainerRequestContext> requestContext;

        @Inject
        private KafkaRestContextFactory(@Context Provider<ContainerRequestContext> requestContext) {
            this.requestContext = Objects.requireNonNull(requestContext);
        }

        public KafkaRestContext provide() {
            return (KafkaRestContext)Objects.requireNonNull(((ContainerRequestContext)this.requestContext.get()).getProperty(KafkaRestSecurityModule.KAFKA_REST_CONTEXT_PROPERTY_NAME), "KafkaRestContext cannot be null.");
        }

        public void dispose(KafkaRestContext context) {
        }
    }

    private static final class AdminFactory
    implements Factory<Admin> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private AdminFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Admin provide() {
            return ((KafkaRestContext)this.context.get()).getAdmin();
        }

        public void dispose(Admin admin) {
        }
    }

    private static final class ProducerFactory
    implements Factory<Producer<byte[], byte[]>> {
        private final Provider<KafkaRestContext> context;

        @Inject
        private ProducerFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Producer<byte[], byte[]> provide() {
            return ((KafkaRestContext)this.context.get()).getProducer();
        }

        public void dispose(Producer<byte[], byte[]> producer) {
        }
    }
}

