/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security;

import io.confluent.common.security.auth.AuthenticationCleanupFilter;
import io.confluent.common.security.auth.AuthenticationFilter;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.extension.RestResourceExtension;
import io.confluent.kafkarest.security.KafkaRestSecurityModule;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.SecureConfigProviderFactory;
import io.confluent.kafkarest.security.context.KafkaRestContextProviderFactory;
import io.confluent.kafkarest.security.filter.KafkaRestContextFilter;
import io.confluent.kafkarest.security.filter.KafkaRestImpersonationFilter;
import io.confluent.kafkarest.security.license.KafkaRestLicenseValidatorFilter;
import io.confluent.rest.RestConfigException;
import jakarta.ws.rs.core.Configurable;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaRestSecurityResourceExtension
implements RestResourceExtension {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestSecurityResourceExtension.class);
    private KafkaRestLicenseValidatorFilter licenseFilter = null;

    public void register(Configurable<?> config, KafkaRestConfig restConfig) {
        try {
            ConfluentSecureKafkaRestConfig secureKafkaRestConfig = new ConfluentSecureKafkaRestConfig(restConfig.getOriginalProperties(), Optional.empty());
            String restAuthTypeConfig = secureKafkaRestConfig.getString("confluent.rest.auth.propagate.method");
            String sslMappingRules = secureKafkaRestConfig.getString("confluent.rest.auth.ssl.principal.mapping.rules");
            Optional<Object> sslPrincipalMapper = Optional.empty();
            if (sslMappingRules != null) {
                sslPrincipalMapper = Optional.of(SslPrincipalMapper.fromRules((String)sslMappingRules));
            }
            if (restAuthTypeConfig != null && restAuthTypeConfig.length() > 0) {
                config.register(KafkaRestSecurityModule.class);
                config.register((Object)new AuthenticationFilter(restAuthTypeConfig, sslPrincipalMapper));
                if (this.isMdsEnabled(restConfig)) {
                    config.register((Object)new KafkaRestImpersonationFilter());
                }
                config.register((Object)new KafkaRestContextFilter(secureKafkaRestConfig));
                Map<String, Object> producerProps = secureKafkaRestConfig.licenseProducerConfigs();
                Map<String, Object> consumerProps = secureKafkaRestConfig.licenseConsumerConfigs();
                Map<String, Object> adminProps = secureKafkaRestConfig.licenseAdminConfigs();
                this.licenseFilter = new KafkaRestLicenseValidatorFilter(secureKafkaRestConfig.licenseTopic(), producerProps, consumerProps, adminProps, secureKafkaRestConfig.licenseString());
                config.register((Object)this.licenseFilter);
                config.register(AuthenticationCleanupFilter.class);
            }
        }
        catch (RestConfigException e) {
            log.error("Server configuration failed: ", (Throwable)e);
            System.exit(1);
        }
    }

    public void clean() {
        KafkaRestContextProviderFactory.getInstance().clean();
        SecureConfigProviderFactory.clean();
        if (this.licenseFilter != null) {
            this.licenseFilter.stopLicenseManager();
        }
    }

    private boolean isMdsEnabled(KafkaRestConfig restConfig) {
        return restConfig.originals().containsKey("confluent.metadata.bootstrap.server.urls");
    }
}

