/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.config;

import io.confluent.common.security.auth.RestAuthType;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.SystemTime;
import io.confluent.kafkarest.Time;
import io.confluent.kafkarest.security.config.SecureConfigProviderFactory;
import io.confluent.rest.RestConfigException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;

public final class ConfluentSecureKafkaRestConfig
extends KafkaRestConfig {
    public static final String CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_CONFIG = "confluent.rest.auth.ssl.principal.mapping.rules";
    private static final String CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_DOC = "A list of rules to map from the distinguished name (DN) in the client certificate to a short name principal for authentication with the Kafka broker. Rules are tested from left to right. The first rule that matches will be applied.";
    public static final String CONFLUENT_AUTH_PROPAGATE_CONFIG_CONFIG = "confluent.rest.auth.propagate.method";
    private static final String CONFLUENT_AUTH_PROPAGATE_CONFIG_DOC = "The mechanism used to authenticate Rest Proxy requests. When broker security is enabled, the principal from this authentication mechanism is propagated to Kafka broker requests.";
    private static final String CONFLUENT_AUTH_PROPAGATE_DEFAULT = "SSL";
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_DEFAULT_LICENSE = "";
    protected static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use Confluent Security Plugins for a 30-day trial period. If you are a subscriber and don't have a license key, please contact Confluent Support at support@confluent.io.";
    public static final String CONFLUENT_TOPIC_CONFIG = "confluent.license.topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-license";
    public static final String CONFLUENT_TOPIC_DOC = "Topic used for storing Confluent license";
    public static final String LICENSE_CONFIG_PREFIX = "confluent.license.";
    public static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.license.producer.";
    public static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.license.consumer.";
    public static final String CONFLUENT_TOPIC_ADMIN_PREFIX = "confluent.license.admin.";
    public static final String BOOTSTRAP_METADATA_SERVER_URLS_PROP = "confluent.metadata.bootstrap.server.urls";
    private static final String BOOTSTRAP_METADATA_SERVER_URLS_DOC = "Comma separated list of bootstrap metadata servers urls to which this Rest proxy connects to. For ex: http://localhost:8080,http://localhost:8081";
    private Optional<String> jwtToken;
    private static final ConfigDef confluentConfigDef = ConfluentSecureKafkaRestConfig.initConfigDef();

    public String licenseString() {
        return this.getPassword(CONFLUENT_LICENSE_CONFIG).value();
    }

    public String licenseTopic() {
        return this.getString(CONFLUENT_TOPIC_CONFIG);
    }

    public String bootstrapServers() {
        return this.getString("bootstrap.servers");
    }

    public ConfluentSecureKafkaRestConfig(Properties props, Optional<String> jwtToken) throws RestConfigException {
        super(confluentConfigDef, props, (Time)new SystemTime());
        this.jwtToken = jwtToken;
    }

    public void jwtToken(Optional<String> jwtToken) {
        this.jwtToken = jwtToken;
    }

    public Optional<String> jwtToken() {
        return this.jwtToken;
    }

    public Map<String, Object> licenseProducerConfigs() {
        Properties producerProperties = this.getProducerProperties();
        producerProperties.putAll((Map<?, ?>)this.originalsWithPrefix(LICENSE_CONFIG_PREFIX));
        producerProperties.putAll((Map<?, ?>)this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        producerProperties.put("client.id", "confluent-license-producer");
        return this.propertiesToMap(producerProperties);
    }

    public Map<String, Object> licenseConsumerConfigs() {
        Properties consumerProperties = this.getConsumerProperties();
        consumerProperties.putAll((Map<?, ?>)this.originalsWithPrefix(LICENSE_CONFIG_PREFIX));
        consumerProperties.putAll((Map<?, ?>)this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        consumerProperties.put("client.id", "confluent-license-consumer");
        return this.propertiesToMap(consumerProperties);
    }

    public Map<String, Object> licenseAdminConfigs() {
        Properties adminProperties = this.getAdminProperties();
        adminProperties.putAll((Map<?, ?>)this.originalsWithPrefix(LICENSE_CONFIG_PREFIX));
        adminProperties.putAll((Map<?, ?>)this.originalsWithPrefix(CONFLUENT_TOPIC_ADMIN_PREFIX));
        adminProperties.put("client.id", "confluent-license-admin");
        return this.propertiesToMap(adminProperties);
    }

    private Map<String, Object> propertiesToMap(Properties props) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        map.putIfAbsent("bootstrap.servers", this.bootstrapServers());
        return map;
    }

    public Properties getProducerProperties() {
        Properties originalProps = super.getProducerProperties();
        Properties secureProps = this.jwtToken.isPresent() ? this.getTokenClientProps() : SecureConfigProviderFactory.getInstance().getSecureConfigProvider(this).getProducerProperties(this);
        originalProps.putAll((Map<?, ?>)secureProps);
        return originalProps;
    }

    public Properties getConsumerProperties() {
        Properties originalProps = super.getConsumerProperties();
        Properties secureProps = this.jwtToken.isPresent() ? this.getTokenClientProps() : SecureConfigProviderFactory.getInstance().getSecureConfigProvider(this).getConsumerProperties(this);
        originalProps.putAll((Map<?, ?>)secureProps);
        return originalProps;
    }

    public Properties getAdminProperties() {
        Properties originalProps = super.getAdminProperties();
        Properties secureProps = this.jwtToken.isPresent() ? this.getTokenClientProps() : SecureConfigProviderFactory.getInstance().getSecureConfigProvider(this).getAdminProperties(this);
        originalProps.putAll((Map<?, ?>)secureProps);
        return originalProps;
    }

    public Map<String, Object> getSchemaRegistryConfigs() {
        Properties adminProps;
        Map configs = super.getSchemaRegistryConfigs();
        if (this.jwtToken.isPresent()) {
            Properties tokenProps = this.getTokenClientProps();
            for (String key : tokenProps.stringPropertyNames()) {
                configs.put(key, tokenProps.getProperty(key));
            }
        }
        if ((adminProps = this.getAdminProperties()).containsKey("sasl.jaas.config")) {
            configs.put("sasl.jaas.config", adminProps.get("sasl.jaas.config"));
        }
        return configs;
    }

    private static ConfigDef initConfigDef() {
        return ConfluentSecureKafkaRestConfig.baseKafkaRestConfigDef().define(CONFLUENT_AUTH_PROPAGATE_CONFIG_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_AUTH_PROPAGATE_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])RestAuthType.NAMES.toArray(new String[RestAuthType.NAMES.size()])), ConfigDef.Importance.LOW, CONFLUENT_AUTH_PROPAGATE_CONFIG_DOC).define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)CONFLUENT_DEFAULT_LICENSE, ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC).define(CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_DOC).define(BOOTSTRAP_METADATA_SERVER_URLS_PROP, ConfigDef.Type.STRING, (Object)CONFLUENT_DEFAULT_LICENSE, ConfigDef.Importance.HIGH, BOOTSTRAP_METADATA_SERVER_URLS_DOC).define(CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_CONFIG, ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.LOW, CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_DOC);
    }

    private Properties getTokenClientProps() {
        Properties properties = new Properties();
        properties.put("sasl.mechanism", "OAUTHBEARER");
        properties.put("sasl.login.callback.handler.class", "io.confluent.kafka.clients.plugins.auth.token.TokenBearerLoginCallbackHandler");
        properties.put("sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required  authenticationToken=\"" + this.jwtToken.get() + "\" metadataServerUrls=\"" + this.getString(BOOTSTRAP_METADATA_SERVER_URLS_PROP) + "\";");
        properties.put("bearer.auth.credentials.source", "MDS");
        this.originals().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("confluent.metadata.")).forEach(e -> properties.put(e.getKey(), e.getValue()));
        return properties;
    }
}

