/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.config;

import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.DefaultSecureConfigProvider;
import io.confluent.kafkarest.security.config.SaslSecureConfigProvider;
import io.confluent.kafkarest.security.config.SecureConfigProvider;
import io.confluent.kafkarest.security.config.SslSecureConfigProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public final class SecureConfigProviderFactory {
    private static volatile SecureConfigProviderFactory instance = null;
    private static final SecureConfigProvider defaultConfigProvider = new DefaultSecureConfigProvider();
    private final Map<String, SecureConfigProvider> authTypeSecureConfigProviderMap = new HashMap<String, SecureConfigProvider>();

    private SecureConfigProviderFactory() {
        this.authTypeSecureConfigProviderMap.put(SecurityProtocol.SSL.name, new SslSecureConfigProvider());
        SaslSecureConfigProvider saslSecureConfigProvider = new SaslSecureConfigProvider();
        this.authTypeSecureConfigProviderMap.put(SecurityProtocol.SASL_PLAINTEXT.name, saslSecureConfigProvider);
        this.authTypeSecureConfigProviderMap.put(SecurityProtocol.SASL_SSL.name, saslSecureConfigProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecureConfigProviderFactory getInstance() {
        if (instance != null) return instance;
        Class<SecureConfigProviderFactory> clazz = SecureConfigProviderFactory.class;
        synchronized (SecureConfigProviderFactory.class) {
            if (instance != null) return instance;
            instance = new SecureConfigProviderFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SecureConfigProvider getSecureConfigProvider(ConfluentSecureKafkaRestConfig kafkaRestConfig) {
        String clientSecurityProtocol = kafkaRestConfig.getString("client.security.protocol");
        if (this.authTypeSecureConfigProviderMap.containsKey(clientSecurityProtocol)) {
            return this.authTypeSecureConfigProviderMap.get(clientSecurityProtocol);
        }
        return defaultConfigProvider;
    }

    public static void clean() {
        instance = null;
    }
}

