/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.context;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.io.IOException;
import java.util.Objects;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.Producer;

public final class CachingKafkaRestContext
implements KafkaRestContext {
    private final KafkaRestContext delegate;
    private Admin adminClient;
    private KafkaConsumerManager kafkaConsumerManager;
    private Producer<byte[], byte[]> producer;
    private SchemaRegistryClient schemaRegistryClient;

    public CachingKafkaRestContext(KafkaRestContext delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public KafkaRestConfig getConfig() {
        return this.delegate.getConfig();
    }

    public synchronized KafkaConsumerManager getKafkaConsumerManager() {
        if (this.kafkaConsumerManager == null) {
            this.kafkaConsumerManager = this.delegate.getKafkaConsumerManager();
        }
        return this.kafkaConsumerManager;
    }

    public synchronized Admin getAdmin() {
        if (this.adminClient == null) {
            this.adminClient = this.delegate.getAdmin();
        }
        return this.adminClient;
    }

    public synchronized Producer<byte[], byte[]> getProducer() {
        if (this.producer == null) {
            this.producer = this.delegate.getProducer();
        }
        return this.producer;
    }

    public synchronized SchemaRegistryClient getSchemaRegistryClient() {
        if (this.schemaRegistryClient == null) {
            this.schemaRegistryClient = this.delegate.getSchemaRegistryClient();
        }
        return this.schemaRegistryClient;
    }

    public synchronized void shutdown() {
        this.delegate.shutdown();
        if (this.schemaRegistryClient != null) {
            try {
                this.schemaRegistryClient.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while closing schema registry client", e);
            }
        }
        if (this.adminClient != null) {
            this.adminClient.close();
        }
        if (this.kafkaConsumerManager != null) {
            this.kafkaConsumerManager.shutdown();
        }
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

