/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.filter;

import io.confluent.common.security.auth.CertificatePrincipal;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.auth.RestSecurityContext;
import io.confluent.security.auth.common.JwtBearerToken;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1001)
public class KafkaRestImpersonationFilter
implements ContainerRequestFilter {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";
    private static final Logger log = LoggerFactory.getLogger(KafkaRestImpersonationFilter.class);

    public void filter(ContainerRequestContext requestContext) {
        Principal userPrincipal = requestContext.getSecurityContext().getUserPrincipal();
        try {
            if (userPrincipal instanceof CertificatePrincipal) {
                if (requestContext.getHeaders().containsKey((Object)AUTHORIZATION_HEADER)) {
                    log.debug("Authorization header is present during impersonation flow for user {}", (Object)userPrincipal.getName());
                    String token = (String)((List)requestContext.getHeaders().get((Object)AUTHORIZATION_HEADER)).get(0);
                    if (token.contains(BEARER)) {
                        String jwt = token.split(" ")[1];
                        JwtBearerToken authToken = new JwtBearerToken(jwt);
                        JwtPrincipal principal = new JwtPrincipal((OAuthBearerToken)authToken);
                        this.updateSecurityContext(requestContext, (Principal)principal);
                    }
                    return;
                }
                log.error("No incoming Authorization header while impersonating user {}. Make sure AuthenticationHandler is configured", (Object)userPrincipal.getName());
            }
        }
        catch (Exception e) {
            log.error("Error while impersonating user {}", (Object)userPrincipal.getName(), (Object)e);
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource due to impersonation filter failure.").build());
        }
    }

    public void updateSecurityContext(ContainerRequestContext requestContext, Principal principal) throws LoginException {
        SecurityContext oldContext = requestContext.getSecurityContext();
        RestSecurityContext.clear();
        RestSecurityContext newContext = new RestSecurityContext(principal, oldContext.getAuthenticationScheme());
        requestContext.setSecurityContext((SecurityContext)newContext);
    }
}

