/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.license;

import io.confluent.common.security.license.ComponentBrokerCompatibilityLogger;
import io.confluent.common.security.license.MultiLicenseBrokerHandler;
import io.confluent.kafkarest.security.license.KafkaRestLicenseValidatorFilter;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.kafka.BrokerDetectionException;
import io.confluent.license.kafka.BrokerType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRestLicensePolicyEnforcer
extends ComponentBrokerCompatibilityLogger {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestLicensePolicyEnforcer.class);
    private final KafkaRestLicenseValidatorFilter kafkaRestLicenseValidatorFilter;

    public KafkaRestLicensePolicyEnforcer(MultiLicenseBrokerHandler handler, KafkaRestLicenseValidatorFilter kafkaRestLicenseValidatorFilter) {
        super(handler);
        this.kafkaRestLicenseValidatorFilter = kafkaRestLicenseValidatorFilter;
    }

    public void onBrokerDetectionException(BrokerDetectionException e) {
        this.kafkaRestLicenseValidatorFilter.hasIncompatibleLicense(false);
        log.warn("Failed to detect kafka broker type for REST Proxy license validation. Please ensure license clients are configured correctly and set bootstrap.servers.", (Throwable)e);
    }

    public void onIncompatibleLicenseDetected(List<License> licenses, BrokerType brokerType) {
        this.kafkaRestLicenseValidatorFilter.hasIncompatibleLicense(false);
        log.warn("Confluent does not support self-managed (Confluent Platform) components utilized with Confluent Platform brokers when operating under the installed 'Customer-Managed Confluent Platform for Confluent Cloud' Enterprise license. Please ensure you are connecting to a Confluent Cloud broker or update to a valid 'Confluent Platform' Enterprise license");
    }

    public synchronized void onLicenseValidated(List<License> licenses) {
        super.onLicenseValidated(licenses);
        boolean hasOnlyEnterpriseCpForCc = licenses.stream().allMatch(license -> license.deploymentScope() == License.DeploymentScope.CP_FOR_CC);
        if (hasOnlyEnterpriseCpForCc && this.brokerType() == BrokerType.CONFLUENT_CLOUD) {
            log.info("Detected Enterprise CP_FOR_CC license and CC broker");
            this.kafkaRestLicenseValidatorFilter.hasIncompatibleLicense(false);
        }
    }

    public void onLicenseValidationFailure(InvalidLicenseException exception) {
        log.error("No valid Enterprise license detected. Kafka REST security plugins require a valid Enterprise license. Please follow these instructions to configure a license: https://docs.confluent.io/platform/current/kafka-rest/production-deployment/rest-proxy/config.html#license-configuration-options");
    }
}

