/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.license;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.common.security.license.LicenseEventListener;
import io.confluent.common.security.license.MultiLicenseBrokerHandler;
import io.confluent.kafkarest.security.license.KafkaRestLicensePolicyEnforcer;
import io.confluent.license.kafka.BrokerDetector;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import java.util.Map;

@Priority(value=1)
public class KafkaRestLicenseValidatorFilter
implements ContainerRequestFilter {
    private final MultiLicenseBrokerHandler licenseBackgroundFetcher;
    private volatile boolean hasIncompatibleLicense = false;
    @VisibleForTesting
    private final KafkaRestLicensePolicyEnforcer licenseEnforcer;

    public KafkaRestLicenseValidatorFilter(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String license) {
        this.licenseBackgroundFetcher = new MultiLicenseBrokerHandler(topic, producerConfig, consumerConfig, topicConfig, license);
        this.licenseEnforcer = new KafkaRestLicensePolicyEnforcer(this.licenseBackgroundFetcher, this);
        this.licenseBackgroundFetcher.addListener((LicenseEventListener)this.licenseEnforcer);
        this.licenseBackgroundFetcher.startAsync();
    }

    public void filter(ContainerRequestContext requestContext) {
        if (!this.licenseBackgroundFetcher.hasValidLicense() || this.hasIncompatibleLicense) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.PAYMENT_REQUIRED).entity((Object)"Invalid License!").build());
        }
    }

    public synchronized void hasIncompatibleLicense(boolean hasIncompatibleLicense) {
        this.hasIncompatibleLicense = hasIncompatibleLicense;
    }

    @VisibleForTesting
    public boolean hasIncompatibleLicense() {
        return this.hasIncompatibleLicense;
    }

    public void stopLicenseManager() {
        this.licenseBackgroundFetcher.stopAsync();
    }

    @VisibleForTesting
    public MultiLicenseBrokerHandler getLicenseBackgroundFetcher() {
        return this.licenseBackgroundFetcher;
    }

    @VisibleForTesting
    public void setBrokerDetector(BrokerDetector brokerDetector) {
        this.licenseBackgroundFetcher.setBrokerDetector(brokerDetector);
    }
}

