/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Ticker;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.validator.AbstractSchemaRegistryClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class LruSchemaRegistryClient
extends AbstractSchemaRegistryClient {
    private static final int HTTP_NOT_FOUND = 404;
    private static final int SCHEMA_NOT_FOUND_ERROR_CODE = 40403;
    private static final int SUBJECT_NOT_FOUND_ERROR_CODE = 40401;
    private final RestService restService;
    private final AsyncLoadingCache<SubjectAndSchema, Integer> schemaCache;
    private final Cache<SubjectAndSchema, Long> missingSchemaCache;
    private final Cache<SubjectAndSchema, Long> missingSubjectCache;
    private final AsyncLoadingCache<SubjectAndId, ParsedSchema> idCache;
    private final Cache<SubjectAndId, Long> missingIdCache;
    private final int maxRetries;
    private final int retriesWaitMs;
    private final int missingIdQueryRange;
    private int currentMaxSchemaId = -1;
    private final Map<String, SchemaProvider> providers;

    public LruSchemaRegistryClient(List<String> baseUrls, int maxCacheSize, int maxRetries, int retriesWaitMs, Map<String, ?> configs, Map<String, String> httpHeaders, int missingIdQueryRange, long missingIdCacheTtl, long missingSchemaCacheTtl) {
        this(baseUrls, maxCacheSize, maxRetries, retriesWaitMs, configs, httpHeaders, Ticker.systemTicker(), missingIdQueryRange, missingIdCacheTtl, missingSchemaCacheTtl);
    }

    public LruSchemaRegistryClient(List<String> baseUrls, int maxCacheSize, int maxRetries, int retriesWaitMs, Map<String, ?> configs, Map<String, String> httpHeaders, Ticker ticker, int missingIdQueryRange, long missingIdCacheTtl, long missingSchemaCacheTtl) {
        this(new RestService(baseUrls), maxCacheSize, maxRetries, retriesWaitMs, configs, httpHeaders, ticker, missingIdQueryRange, missingIdCacheTtl, missingSchemaCacheTtl);
    }

    public LruSchemaRegistryClient(RestService restService, int maxCacheSize, int maxRetries, int retriesWaitMs, Map<String, ?> configs, Map<String, String> httpHeaders, Ticker ticker, int missingIdQueryRange, long missingIdCacheTtl, long missingSchemaCacheTtl) {
        this.maxRetries = maxRetries;
        this.retriesWaitMs = retriesWaitMs;
        this.restService = restService;
        this.missingIdQueryRange = missingIdQueryRange;
        if (httpHeaders != null) {
            restService.setHttpHeaders(httpHeaders);
        }
        if (configs != null && !configs.isEmpty()) {
            restService.configure(configs);
            SslFactory sslFactory = new SslFactory(configs);
            if (sslFactory.sslContext() != null) {
                restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
            }
        }
        this.schemaCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).ticker(() -> ((Ticker)ticker).read()).buildAsync(key -> this.retry(() -> this.getIdFromRegistry(key.subject(), key.schema())));
        this.missingSchemaCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).ticker(() -> ((Ticker)ticker).read()).expireAfterWrite(missingSchemaCacheTtl, TimeUnit.SECONDS).build();
        this.missingSubjectCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).ticker(() -> ((Ticker)ticker).read()).expireAfterWrite(missingSchemaCacheTtl, TimeUnit.SECONDS).build();
        this.idCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).ticker(() -> ((Ticker)ticker).read()).buildAsync(key -> this.retry(() -> this.getSchemaBySubjectAndIdFromRegistry(key.subject(), key.id())));
        this.missingIdCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).ticker(() -> ((Ticker)ticker).read()).expireAfterWrite(missingIdCacheTtl, TimeUnit.SECONDS).build();
        this.providers = new HashMap<String, SchemaProvider>();
        this.initProviders();
    }

    protected LruSchemaRegistryClient(AsyncLoadingCache<SubjectAndSchema, Integer> schemaCache, AsyncLoadingCache<SubjectAndId, ParsedSchema> idCache, Cache<SubjectAndId, Long> missingIdCache, int missingIdQueryRange, Cache<SubjectAndSchema, Long> missingSchemaCache, Cache<SubjectAndSchema, Long> missingSubjectCache) {
        this.maxRetries = 0;
        this.retriesWaitMs = 0;
        this.restService = null;
        this.schemaCache = schemaCache;
        this.idCache = idCache;
        this.missingIdCache = missingIdCache;
        this.missingIdQueryRange = missingIdQueryRange;
        this.providers = new HashMap<String, SchemaProvider>();
        this.missingSchemaCache = missingSchemaCache;
        this.missingSubjectCache = missingSubjectCache;
        this.initProviders();
    }

    private void initProviders() {
        this.providers.put("AVRO", (SchemaProvider)new AvroSchemaProvider());
        this.providers.put("JSON", (SchemaProvider)new JsonSchemaProvider());
        this.providers.put("PROTOBUF", (SchemaProvider)new ProtobufSchemaProvider());
        HashMap<String, LruSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, LruSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
    }

    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider = this.providers.get(schemaType);
        if (schemaProvider == null) {
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    public Optional<ParsedSchema> parseSchema(Schema schema) {
        String schemaType = schema.getSchemaType();
        SchemaProvider schemaProvider = this.providers.get(schemaType);
        if (schemaProvider == null) {
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schema, false);
    }

    private ParsedSchema getSchemaBySubjectAndIdFromRegistry(String subject, int id) throws IOException, RestClientException {
        if (this.missingIdCache.getIfPresent((Object)new SubjectAndId(subject, id)) != null) {
            throw new RestClientException("This ID " + id + " is banned", 404, 40403);
        }
        if (this.currentMaxSchemaId >= 0 && id > this.currentMaxSchemaId + this.missingIdQueryRange) {
            this.missingIdCache.put((Object)new SubjectAndId(subject, id), (Object)System.currentTimeMillis());
            throw new RestClientException("This ID " + id + " is not allowed", 404, 40403);
        }
        SchemaString restSchema = this.restService.getId(id, subject, true);
        this.currentMaxSchemaId = restSchema.getMaxId();
        return this.parseSchema(new Schema(null, null, null, restSchema)).orElseThrow(() -> new IOException("Could not parse schema"));
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema) throws IOException, RestClientException {
        if (this.missingSchemaCache.getIfPresent((Object)new SubjectAndSchema(subject, schema)) != null) {
            throw new RestClientException("Could not find the schema under subject " + subject, 404, 40403);
        }
        if (this.missingSubjectCache.getIfPresent((Object)new SubjectAndSchema(subject, schema)) != null) {
            throw new RestClientException("The subject " + subject + " is not found", 404, 40401);
        }
        Schema response = this.restService.lookUpSubjectVersion(new RegisterSchemaRequest(schema), subject, false, false);
        return response.getId();
    }

    private <T> T retry(Callable<T> callable) throws Exception {
        T result = null;
        for (int i = 0; i < this.maxRetries + 1; ++i) {
            block3: {
                try {
                    result = callable.call();
                }
                catch (RestClientException e) {
                    if (e.getStatus() == 404 && i < this.maxRetries) break block3;
                    throw e;
                }
            }
            if (result != null) break;
            if (this.retriesWaitMs <= 0) continue;
            Thread.sleep(this.retriesWaitMs);
        }
        return result;
    }

    @Override
    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        try {
            return (ParsedSchema)this.idCache.get((Object)new SubjectAndId(subject, id)).get();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RestClientException) {
                RestClientException rce = (RestClientException)cause;
                if (rce.getStatus() == 404 && rce.getErrorCode() == 40403 && this.missingIdCache.getIfPresent((Object)new SubjectAndId(subject, id)) == null) {
                    this.missingIdCache.put((Object)new SubjectAndId(subject, id), (Object)System.currentTimeMillis());
                }
                throw (RestClientException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        try {
            return this.restService.getVersion(subject, version, lookupDeletedSchema);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try {
            return (Integer)this.schemaCache.get((Object)new SubjectAndSchema(subject, schema)).get();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RestClientException) {
                RestClientException rce = (RestClientException)cause;
                if (rce.getStatus() == 404) {
                    if (rce.getErrorCode() == 40403 && this.missingSchemaCache.getIfPresent((Object)new SubjectAndSchema(subject, schema)) == null) {
                        this.missingSchemaCache.put((Object)new SubjectAndSchema(subject, schema), (Object)System.currentTimeMillis());
                    } else if (rce.getErrorCode() == 40401 && this.missingSubjectCache.getIfPresent((Object)new SubjectAndSchema(subject, schema)) == null) {
                        this.missingSubjectCache.put((Object)new SubjectAndSchema(subject, schema), (Object)System.currentTimeMillis());
                    }
                }
                throw (RestClientException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public RegisterSchemaResponse getIdWithResponse(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        int id = this.getId(subject, schema, normalize);
        return new RegisterSchemaResponse(id);
    }

    @Override
    public void reset() {
        this.schemaCache.synchronous().invalidateAll();
        this.idCache.synchronous().invalidateAll();
        this.missingIdCache.invalidateAll();
    }

    public void close() throws IOException {
        if (this.restService != null) {
            this.restService.close();
        }
    }

    static class SubjectAndId {
        private final String subject;
        private final int id;

        public SubjectAndId(String subject, int id) {
            this.subject = subject;
            this.id = id;
        }

        public String subject() {
            return this.subject;
        }

        public int id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndId that = (SubjectAndId)o;
            return Objects.equals(this.subject, that.subject) && this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.id);
        }

        public String toString() {
            return "SubjectAndSchema{subject='" + this.subject + "', id=" + this.id + "}";
        }
    }

    static class SubjectAndSchema {
        private final String subject;
        private final ParsedSchema schema;

        public SubjectAndSchema(String subject, ParsedSchema schema) {
            this.subject = subject;
            this.schema = schema;
        }

        public String subject() {
            return this.subject;
        }

        public ParsedSchema schema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndSchema that = (SubjectAndSchema)o;
            return Objects.equals(this.subject, that.subject) && this.schema.equals(that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.schema);
        }

        public String toString() {
            return "SubjectAndSchema{subject='" + this.subject + "', schema=" + String.valueOf(this.schema) + "}";
        }
    }
}

