/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.request;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import kafka.network.SocketServer;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.utils.Utils;

public final class RequestUtils {
    public static Socket connect(SocketServer socketServer, ListenerName listenerName) throws Exception {
        return new Socket("localhost", socketServer.boundPort(listenerName));
    }

    public static AbstractResponse sendAndReceive(AbstractRequest request, Socket socket, String clientId, int correlationId) throws Exception {
        RequestUtils.send(request, socket, clientId, correlationId);
        return RequestUtils.receive(socket, request.apiKey(), request.version());
    }

    private static void send(AbstractRequest request, Socket socket, String clientId, int correlationId) throws Exception {
        RequestHeader header = RequestUtils.requestHeader(request.apiKey(), request.version(), clientId, correlationId);
        RequestUtils.sendWithHeader(request, header, socket);
    }

    private static RequestHeader requestHeader(ApiKeys apiKey, short apiVersion, String clientId, int correlationId) {
        return new RequestHeader(apiKey, apiVersion, clientId, correlationId);
    }

    private static void sendWithHeader(AbstractRequest request, RequestHeader header, Socket socket) throws Exception {
        byte[] serializedBytes = Utils.toArray((ByteBuffer)request.serializeWithHeader(header));
        RequestUtils.sendRequest(socket, serializedBytes);
    }

    private static void sendRequest(Socket socket, byte[] request) throws Exception {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length);
        outgoing.write(request);
        outgoing.flush();
    }

    private static AbstractResponse receive(Socket socket, ApiKeys apiKey, short version) throws Exception {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] responseBytes = new byte[len];
        incoming.readFully(responseBytes);
        ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)apiKey.responseHeaderVersion(version));
        return AbstractResponse.parseResponse((ApiKeys)apiKey, (ByteBuffer)responseBuffer, (short)version, (MessageContext)MessageContext.IDENTITY);
    }
}

